/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.notifier;

import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.mail.MessagingException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.consumer.ServiceContext;
import org.gcube.messaging.common.consumer.ghn.GHNNotification;
import org.gcube.messaging.common.consumer.notifier.Notification;
import org.gcube.messaging.common.consumer.ri.RINotification;

public class Notifier
implements Runnable {
    public static GCUBELog logger = new GCUBELog(Notifier.class);
    private static ConcurrentLinkedQueue<Notification> notificationQueue = null;
    private boolean notifiyByMail = false;

    public Notifier(boolean notifyByMail) {
        this.notifiyByMail = notifyByMail;
        notificationQueue = new ConcurrentLinkedQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Notification notification) {
        try {
            ConcurrentLinkedQueue<Notification> concurrentLinkedQueue = notificationQueue;
            synchronized (concurrentLinkedQueue) {
                notificationQueue.add(notification);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error enqueuing Notification with Message: " + notification.getMessage()), (Throwable)e);
        }
    }

    private void sendGHNNotificationMail(Notification not) throws IOException, MessagingException {
        String messageTosend = "***** gCube Monitoring *****\n\nType: " + ((GHNNotification)not).getType() + "\n" + "GHN: " + ((GHNNotification)not).getSourceGHN() + "\n" + "Address: " + InetAddress.getByName(((GHNNotification)not).getSourceGHN().substring(0, ((GHNNotification)not).getSourceGHN().indexOf(58))) + "\n" + not.getMessage() + "\n\n" + "Date/Time: " + not.getTime() + "\n\n";
        String domain = this.getDomain(not.getSourceGHN());
        ServiceContext.getContext().getMailClient().sendMailNotification(messageTosend, not, not.getScope().toString(), domain);
    }

    private void sendRINotificationMail(Notification not) throws IOException, MessagingException {
        String messageTosend = "***** gCube Monitoring *****\n\nType: " + ((RINotification)not).getType() + "\n" + "GHN: " + ((RINotification)not).getSourceGHN() + "\n" + "Address: " + InetAddress.getByName(((RINotification)not).getSourceGHN().substring(0, ((RINotification)not).getSourceGHN().indexOf(58))) + "\n" + "ServiceClass: " + ((RINotification)not).getServiceClass() + "\n" + "ServiceName: " + ((RINotification)not).getServiceName() + "\n" + not.getMessage() + "\n\n" + "Date/Time: " + not.getTime() + "\n\n";
        String domain = this.getDomain(not.getSourceGHN());
        ServiceContext.getContext().getMailClient().sendMailNotification(messageTosend, not, not.getScope().toString(), domain);
    }

    private String getDomain(String ghnName) {
        try {
            String temp = ghnName.substring(ghnName.indexOf(".") + 1);
            return temp.substring(0, temp.indexOf(":"));
        }
        catch (Exception e) {
            logger.error((Object)("Error extracting domain from ghn " + ghnName));
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int size = 0;
        while (true) {
            ConcurrentLinkedQueue<Notification> concurrentLinkedQueue = notificationQueue;
            synchronized (concurrentLinkedQueue) {
                size = notificationQueue.size();
            }
            if (size == 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            Notification not = null;
            ConcurrentLinkedQueue<Notification> concurrentLinkedQueue2 = notificationQueue;
            synchronized (concurrentLinkedQueue2) {
                not = notificationQueue.poll();
            }
            this.sendNotification(not);
        }
    }

    private void sendNotification(Notification not) {
        if (this.notifiyByMail) {
            if (not instanceof GHNNotification) {
                logger.debug((Object)"Sending GHN Notification Mail");
                try {
                    this.sendGHNNotificationMail(not);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            } else if (not instanceof RINotification) {
                logger.debug((Object)"Sending RI Notification Mail");
                try {
                    this.sendRINotificationMail(not);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

