/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.consumer.mail;

import java.io.File;
import java.io.StringBufferInputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.messaging.common.consumer.ServiceContext;
import org.gcube.messaging.common.consumer.liferay.LiferayClient;
import org.gcube.vomanagement.usermanagement.ws.UserModel;
import org.gcube.vomanagement.usermanagement.ws.UserModelCustomAttrsMapEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MailRecipientHelper {
    private Document domDocument = null;
    private Long diskQuotaThreshold = null;
    private Long virtualMemoryThreshold = null;
    private Double cpuLoadThreshold = null;
    public static GCUBELog logger = new GCUBELog(MailRecipientHelper.class);

    public MailRecipientHelper(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        builder = factory.newDocumentBuilder();
        this.domDocument = builder.parse(file);
    }

    public MailRecipientHelper() throws Exception {
    }

    public void parse(String file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        String scope = "";
        builder = factory.newDocumentBuilder();
        this.domDocument = builder.parse(new StringBufferInputStream(file));
        Element root = this.domDocument.getDocumentElement();
        scope = root.getAttributes().getNamedItem("name").getNodeValue();
        ServiceContext.getContext().getMonitoringManager().cleanMonitoringConf(scope);
        NodeList nodes = root.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            Node node = nodes.item(j);
            if (!(node instanceof Element)) continue;
            if (!ServiceContext.getContext().connectToUsermanagementDB() && ((Element)node).getTagName().compareTo("NotificationConfiguration") == 0) {
                NodeList domains = node.getChildNodes();
                for (int i = 0; i < domains.getLength(); ++i) {
                    Node domain = domains.item(i);
                    if (!(domain instanceof Element) || ((Element)domain).getTagName().compareTo("Domain") != 0) continue;
                    String domainName = domain.getAttributes().getNamedItem("name").getNodeValue();
                    String siteName = domain.getAttributes().getNamedItem("site").getNodeValue();
                    NodeList users = domain.getChildNodes();
                    ServiceContext.getContext().getMonitoringManager().insertDomain(domainName, siteName);
                    for (int k = 0; k < users.getLength(); ++k) {
                        Node user = users.item(k);
                        if (!(user instanceof Element) || ((Element)user).getTagName().compareTo("User") != 0) continue;
                        String name = user.getAttributes().getNamedItem("name").getNodeValue();
                        String email = user.getAttributes().getNamedItem("email").getNodeValue();
                        boolean notify = Boolean.parseBoolean(user.getAttributes().getNamedItem("notify").getNodeValue());
                        boolean receiveSummary = Boolean.parseBoolean(user.getAttributes().getNamedItem("receiveSummary").getNodeValue());
                        boolean admin = Boolean.parseBoolean(user.getAttributes().getNamedItem("admin").getNodeValue());
                        ServiceContext.getContext().getMonitoringManager().insertUser(new MonitorUser(name, email, scope, notify, receiveSummary, admin));
                        ServiceContext.getContext().getMonitoringManager().associateUserAndDomain(email, domainName, scope);
                    }
                }
                continue;
            }
            if (((Element)node).getTagName().compareTo("CPULoad") == 0) {
                logger.debug((Object)node.getFirstChild().getNodeValue());
                this.cpuLoadThreshold = Double.parseDouble(node.getFirstChild().getNodeValue());
                continue;
            }
            if (((Element)node).getTagName().compareTo("DiskQuota") == 0) {
                logger.debug((Object)node.getFirstChild().getNodeValue());
                this.diskQuotaThreshold = Long.parseLong(node.getFirstChild().getNodeValue());
                continue;
            }
            if (((Element)node).getTagName().compareTo("VirtualMemory") != 0) continue;
            logger.debug((Object)node.getFirstChild().getNodeValue());
            this.virtualMemoryThreshold = Long.parseLong(node.getFirstChild().getNodeValue());
        }
        try {
            if (ServiceContext.getContext().connectToUsermanagementDB()) {
                this.updateUserinfo(scope);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error Getting user info from Usermanagement WS", (Throwable)e);
            throw e;
        }
    }

    private void updateUserinfo(String scope) throws ServiceException, Exception {
        LiferayClient client = new LiferayClient();
        for (UserModel user : client.getUsersWithRole(LiferayClient.siteManagerRoleName)) {
            String siteName = "";
            ArrayList<String> domains = null;
            boolean notify = false;
            boolean receiveSummary = false;
            for (int i = 0; i < user.getCustomAttrsMap().getEntry().length; ++i) {
                UserModelCustomAttrsMapEntry entry = user.getCustomAttrsMap().getEntry(i);
                if (entry.getKey().compareTo(LiferayClient.siteDomainsCustomAttributeName) != 0) continue;
                if (entry.getValue() != null) {
                    domains = this.getDomains(entry.getValue());
                    continue;
                }
                if (entry.getKey().compareTo(LiferayClient.receiveNotificationCustomAttributeName) != 0) continue;
                if (entry.getValue() != null) {
                    notify = Boolean.parseBoolean(entry.getValue());
                    continue;
                }
                if (entry.getKey().compareTo(LiferayClient.receiveSummaryCustomAttributeName) != 0) continue;
                if (entry.getValue() != null) {
                    receiveSummary = Boolean.parseBoolean(entry.getValue());
                    continue;
                }
                if (entry.getKey().compareTo(LiferayClient.siteNameCustomAttributeName) != 0 || entry.getValue() == null) continue;
                siteName = entry.getValue();
            }
            if (domains == null || siteName.compareTo("") == 0) {
                logger.warn((Object)("The information related to user " + user.getScreenName() + " are not available"));
                return;
            }
            for (String domain : domains) {
                ServiceContext.getContext().getMonitoringManager().insertDomain(domain, siteName);
                ServiceContext.getContext().getMonitoringManager().associateUserAndDomain(user.getScreenName(), domain, scope);
            }
            ServiceContext.getContext().getMonitoringManager().insertUser(new MonitorUser(user.getScreenName(), user.getEmail(), scope, notify, receiveSummary, false));
        }
        for (UserModel user : client.getUsersWithRole(LiferayClient.infraManagerRoleName)) {
            boolean notify = false;
            boolean receiveSummary = false;
            for (int i = 0; i < user.getCustomAttrsMap().getEntry().length; ++i) {
                UserModelCustomAttrsMapEntry entry = user.getCustomAttrsMap().getEntry(i);
                if (entry.getKey().compareTo(LiferayClient.receiveNotificationCustomAttributeName) != 0) continue;
                if (entry.getValue() != null) {
                    notify = Boolean.parseBoolean(entry.getValue());
                    continue;
                }
                if (entry.getKey().compareTo(LiferayClient.receiveSummaryCustomAttributeName) != 0 || entry.getValue() == null) continue;
                receiveSummary = Boolean.parseBoolean(entry.getValue());
            }
            ResultSet domains = ServiceContext.getContext().getMonitoringManager().getDomains();
            while (domains.next()) {
                ServiceContext.getContext().getMonitoringManager().associateUserAndDomain(user.getScreenName(), domains.getString("Name"), scope);
            }
            ServiceContext.getContext().getMonitoringManager().insertUser(new MonitorUser(user.getScreenName(), user.getEmail(), scope, notify, receiveSummary, true));
        }
    }

    private ArrayList<String> getDomains(String value) {
        ArrayList<String> domains = new ArrayList<String>();
        StringTokenizer token = new StringTokenizer(value, ",");
        while (token.hasMoreElements()) {
            domains.add(token.nextToken());
        }
        return domains;
    }

    public Long getDiskQuotaThreshold() {
        return this.diskQuotaThreshold;
    }

    public void setDiskQuotaThreshold(Long diskQuotaThreshold) {
        this.diskQuotaThreshold = diskQuotaThreshold;
    }

    public Long getVirtualMemoryThreshold() {
        return this.virtualMemoryThreshold;
    }

    public void setVirtualMemoryThreshold(Long virtualMemoryThreshold) {
        this.virtualMemoryThreshold = virtualMemoryThreshold;
    }

    public Double getCpuLoadThreshold() {
        return this.cpuLoadThreshold;
    }

    public void setCpuLoadThreshold(Double cpuLoadThreshold) {
        this.cpuLoadThreshold = cpuLoadThreshold;
    }

    public class MonitorUser {
        private String mail;
        private String name;
        private String scope;
        private boolean receiveSummary;
        private boolean notify;
        private boolean admin;

        public MonitorUser(String name, String mail, String scope, boolean notify, boolean receiveSummary, boolean admin) {
            this.name = name;
            this.mail = mail;
            this.receiveSummary = receiveSummary;
            this.notify = notify;
            this.admin = admin;
            this.scope = scope;
        }

        public String getMail() {
            return this.mail;
        }

        public void setMail(String mail) {
            this.mail = mail;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isReceiveSummary() {
            return this.receiveSummary;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public void setReceiveSummary(boolean receiveSummary) {
            this.receiveSummary = receiveSummary;
        }

        public boolean isNotify() {
            return this.notify;
        }

        public void setNotify(boolean notify) {
            this.notify = notify;
        }

        public boolean isAdmin() {
            return this.admin;
        }

        public void setAdmin(boolean admin) {
            this.admin = admin;
        }
    }
}

