package org.gcube.messaging.monitoring.probes.ghn;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.messaging.common.messages.Test;


/**
 * GHN Probe, that checks for Disk Quota
 * 
 * @author Andrea Manzi (CERN)
 *
 */
public class GHNDiskProbe extends GHNProbe{
	

	public GHNDiskProbe(){}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public void run() throws Exception {
		Test test = new Test();
		try {
			//get free space of the user home
			long freeSpace = GHNContext.getContext().getFreeSpace(GHNContext.getContext().getLocation());			
			test.setDescription("Check the local GHN Disk Quota");
			test.setType(Test.TestType.DISK_QUOTA);
			test.setTestNumber(Integer.valueOf(number++));
			test.setTestResult(new Long(freeSpace));
			sendMessageWithTest(test);
		}catch (Exception e){
			logger.error("Error getting Disk quota",e);	
		} 
		 
	}

}

