package org.gcube.messaging.monitoring.probes.ghn;

import java.util.ArrayList;
import java.util.HashMap;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.messaging.common.messages.Test;

/**
 * Gets the CPU Info
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class GHNInformationProbe extends GHNProbe{

	
	private final static long UPDATE_TIME = 216000;//6 hours

	/**
	 * Default Constructor
	 */	public GHNInformationProbe(){}
	/*
	 * (non-Javadoc)
	 * @see org.gcube.common.core.utils.handlers.GCUBEHandler#run()
	 */

	@Override
	public void run() throws Exception {
		this.setInterval(UPDATE_TIME);
		Test test = new Test();
		try {
			ArrayList<HashMap<String, String>>  cpuInfo= GHNContext.getContext().getCPUInfo();	
			test.setDescription("Get the GHN CPUs Info");
			test.setType(Test.TestType.CPUINFO);
			test.setTestNumber(Integer.valueOf(number++));
			test.setTestResult(cpuInfo);
			 sendMessageWithTest(test);
		}catch (Exception e){
			logger.error("Error getting CPU Info",e);	
		}
		
	}

}
