/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.monitoring.probes.ri;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.Events;
import org.gcube.common.core.contexts.ghn.GHNConsumer;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.monitoring.GCUBENotificationProbe;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.messages.RIMessage;
import org.gcube.messaging.common.messages.Test;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class RINotificationProbe
extends GCUBENotificationProbe {
    public void run() throws Exception {
        GHNConsumer ghnManager = new GHNConsumer(){

            protected void onRIRegistration(Events.GHNRIRegistrationEvent event) {
                try {
                    ((GCUBEServiceContext)event.getPayload()).getInstance().subscribeResourceEvents((GCUBEResource.ResourceConsumer)new RIResourceConsumer(((GCUBEServiceContext)event.getPayload()).getName(), ((GCUBEServiceContext)event.getPayload()).getServiceClass()), new GCUBEResource.ResourceTopic[]{GCUBEResource.ResourceTopic.ADDSCOPE, GCUBEResource.ResourceTopic.REMOVESCOPE});
                }
                catch (Exception e) {
                    GCUBELocalProducer.logger.error((Object)"Error sending message to broker", (Throwable)e);
                }
            }
        };
        try {
            GHNContext.getContext().subscribeGHNEvents(ghnManager, new Events.GHNTopic[]{Events.GHNTopic.RIREGISTRATION});
        }
        catch (Exception e) {
            this.logger.error((Object)"Error Subscribing to GHN events", (Throwable)e);
        }
    }

    public static void sendRIMessage(RIMessage message) {
        new RINotificationProbe().sendMessage((GCUBEMessage)message);
    }

    private static RIMessage<Test> createRIMessage(GCUBEScope scope) {
        return new RIMessage(GHNContext.getContext().getHostnameAndPort(), scope);
    }

    public void sendMessage(GCUBEMessage message) {
        ActiveMQClient.getSingleton().sendMessage(message, new String[]{Test.TestType.TEST.name()});
    }

    private class RIResourceConsumer
    extends GCUBEResource.ResourceConsumer {
        String serviceName;
        String serviceClass;

        RIResourceConsumer(String serviceName, String serviceClass) {
            this.serviceClass = serviceClass;
            this.serviceName = serviceName;
        }

        protected void onAddScope(GCUBEResource.AddScopeEvent event) {
            for (GCUBEScope scope : (GCUBEScope[])event.getPayload()) {
                GCUBELocalProducer.logger.debug((Object)("Added Scope " + scope.toString() + " to RI"));
                Test test = new Test();
                test.setDescription("Added Scope " + scope.toString() + " to RI");
                test.setType(Test.TestType.NOTIFICATION);
                test.setTestResult((Object)scope.toString());
                if (GCUBELocalProducer.checkStartScope((GCUBEScope)scope)) {
                    test.setPriority(Test.Priority.LOW);
                } else {
                    test.setPriority(Test.Priority.HIGH);
                }
                try {
                    for (GCUBEScope scope1 : GCUBELocalProducer.getMonitoredScope()) {
                        RIMessage message = RINotificationProbe.createRIMessage(scope1);
                        message.setServiceName(this.serviceName);
                        message.setServiceClass(this.serviceClass);
                        message.setTest(test);
                        message.setTimeNow();
                        RINotificationProbe.sendRIMessage(message);
                    }
                }
                catch (Exception e) {
                    RINotificationProbe.this.logger.error((Object)"Error sending message to broker", (Throwable)e);
                }
            }
        }

        protected void onRemoveScope(GCUBEResource.RemoveScopeEvent event) {
            for (GCUBEScope scope : (GCUBEScope[])event.getPayload()) {
                GCUBELocalProducer.logger.debug((Object)("Removed Scope " + scope + "from RI"));
                Test test = new Test();
                test.setDescription("Removed Scope " + scope + " from RI");
                test.setType(Test.TestType.NOTIFICATION);
                test.setTestResult((Object)scope.toString());
                test.setPriority(Test.Priority.HIGH);
                try {
                    for (GCUBEScope scope1 : GCUBELocalProducer.getMonitoredScope()) {
                        RIMessage message = RINotificationProbe.createRIMessage(scope1);
                        message.setServiceName(this.serviceName);
                        message.setServiceClass(this.serviceClass);
                        message.setTest(test);
                        message.setTimeNow();
                        RINotificationProbe.sendRIMessage(message);
                    }
                    RIMessage message = RINotificationProbe.createRIMessage(scope);
                    message.setServiceName(this.serviceName);
                    message.setServiceClass(this.serviceClass);
                    message.setTest(test);
                    message.setTimeNow();
                    RINotificationProbe.sendRIMessage(message);
                }
                catch (Exception e) {
                    RINotificationProbe.this.logger.error((Object)"Error sending message to broker", (Throwable)e);
                }
            }
        }
    }
}

