/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.opensearch.common.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gcube.opensearch.opensearchlibrary.OpenSearchConstants;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResourceCache;
import org.gcube.rest.commons.resourceawareservice.resources.StatefulResource;
import org.gcube.rest.commons.resourceawareservice.resources.exceptions.StatefulResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
public class OpenSearchDataSourceResource
extends StatefulResource {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private transient EnvHintCollection envHints = new EnvHintCollection();
    @JsonIgnore
    private static final transient Logger logger = LoggerFactory.getLogger(OpenSearchDataSourceResource.class);
    @JsonIgnore
    public transient ISOpenSearchResource[] openSearchGenericResources = null;
    @JsonIgnore
    public transient ISOpenSearchResourceCache cache = new ISOpenSearchResourceCache();
    public List<String> searchableFields = new ArrayList<String>();
    public List<String> presentableFields = new ArrayList<String>();
    public List<String> allPresentableNames = new ArrayList<String>();
    private String adaptorID;
    private List<String> collections;
    private Set<String> supportedRelations;
    private List<String> fields;
    private List<String> descriptionDocumentURI;
    private List<FixedParam> fixedParameters;
    private List<String> openSearchResource;
    private String scope;
    private List<String> openSearchResourceXML;
    private String hostname;

    public static void main(String[] args) throws JAXBException {
        ArrayList fixedParameters = Lists.newArrayList();
        FixedParam fp = new FixedParam();
        fp.params = Lists.newArrayList((Object[])new String[]{"this is a fixed param", "this is another fixed param"});
        FixedParam fp2 = new FixedParam();
        fp2.params = Lists.newArrayList((Object[])new String[]{"a", "b"});
        fixedParameters.add(fp);
        fixedParameters.add(fp2);
        OpenSearchDataSourceResource resource = new OpenSearchDataSourceResource();
        resource.setFixedParameters(fixedParameters);
        resource.setFields(Lists.newArrayList((Object[])new String[]{"field1"}));
        System.out.println(resource.toJSON());
        System.out.println(resource.toXML());
    }

    @XmlElement
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @XmlElement
    public List<FixedParam> getFixedParameters() {
        return this.fixedParameters;
    }

    @XmlElement
    public List<String> getCollections() {
        return this.collections;
    }

    public void setCollections(List<String> collections) {
        this.collections = collections;
    }

    public void setFixedParameters(List<FixedParam> fixedParameters) {
        this.fixedParameters = fixedParameters;
    }

    @XmlElement
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @XmlElement
    public String getAdaptorID() {
        return this.adaptorID;
    }

    public void setAdaptorID(String adaptorID) {
        this.adaptorID = adaptorID;
    }

    @XmlElement
    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    @XmlElement
    public List<String> getCollectionID() {
        return this.collections;
    }

    public void setCollectionID(List<String> collectionIDs) {
        this.collections = collectionIDs;
    }

    public void setDescriptionDocumentURI(String descriptionDocumentURI) throws Exception {
        this.descriptionDocumentURI = Lists.newArrayList((Object[])new String[]{descriptionDocumentURI});
    }

    @XmlElement
    public List<String> getDescriptionDocumentURI() {
        return this.descriptionDocumentURI;
    }

    public void setDescriptionDocumentURI(List<String> descriptionDocumentURIs) {
        this.descriptionDocumentURI = descriptionDocumentURIs;
    }

    @XmlElement
    public List<String> getOpenSearchResource() {
        return this.openSearchResource;
    }

    public void setOpenSearchResource(List<String> openSearchResource) {
        this.openSearchResource = openSearchResource;
    }

    public EnvHintCollection getISEnvHints() {
        return this.getEnvHints();
    }

    @XmlElement
    public List<String> getOpenSearchResourceXML() {
        return this.openSearchResourceXML;
    }

    public void setOpenSearchResourceXML(List<String> openSearchResourceXML) {
        this.openSearchResourceXML = openSearchResourceXML;
    }

    public EnvHintCollection getEnvHints() {
        return this.envHints;
    }

    public void setEnvHints(EnvHintCollection envHints) {
        this.envHints = envHints;
    }

    @XmlElement
    public Set<String> getSupportedRelations() {
        return this.supportedRelations;
    }

    public void setSupportedRelations(Set<String> supportedRelations) {
        this.supportedRelations = supportedRelations;
    }

    public static Set<String> getSupportedRelationsSet() {
        HashSet relations = Sets.newHashSet();
        for (OpenSearchConstants.SupportedRelations relation : OpenSearchConstants.SupportedRelations.values()) {
            String relStr = null;
            if (relation.equals((Object)OpenSearchConstants.SupportedRelations.eq)) {
                relStr = "=";
            } else if (relation.equals((Object)OpenSearchConstants.SupportedRelations.exact)) {
                relStr = "==";
            } else if (relation.equals((Object)OpenSearchConstants.SupportedRelations.any)) {
                relStr = "any";
            } else if (relation.equals((Object)OpenSearchConstants.SupportedRelations.all)) {
                relStr = "all";
            }
            relations.add(relStr);
        }
        return relations;
    }

    public void onLoad() throws StatefulResourceException {
    }

    public void onClose() throws StatefulResourceException {
    }

    public void onDestroy() throws StatefulResourceException {
    }

    @XmlRootElement
    public static class FixedParam {
        private List<String> params;

        @XmlElement
        public List<String> getParams() {
            return this.params;
        }

        public void setParams(List<String> params) {
            this.params = params;
        }
    }
}

