/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource;

import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.utils.Locators;
import gr.uoa.di.madgik.rr.element.search.Field;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBERetrySameException;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.opensearch.opensearchdatasource.FailedToRevertException;
import org.gcube.opensearch.opensearchdatasource.OpenSearchDataSource;
import org.gcube.opensearch.opensearchdatasource.OpenSearchDataSourceConfig;
import org.gcube.opensearch.opensearchdatasource.ServiceContext;
import org.gcube.opensearch.opensearchdatasource.StatefulContext;
import org.gcube.opensearch.opensearchdatasource.processor.FieldDefinitionInfo;
import org.gcube.opensearch.opensearchdatasource.processor.GCQLNodeAnnotation;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchCollectionEnricher;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchGcqlAnnotator;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchGcqlProcessor;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchGcqlQueryContainer;
import org.gcube.opensearch.opensearchdatasource.processor.OpenSearchProjector;
import org.gcube.opensearch.opensearchlibrary.DescriptionDocument;
import org.gcube.opensearch.opensearchlibrary.queryelements.BasicQueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.BasicURLElementFactory;
import org.gcube.opensearch.opensearchlibrary.urlelements.URLElementFactory;
import org.gcube.opensearch.opensearchlibrary.utils.FactoryClassNamePair;
import org.gcube.opensearch.opensearchoperator.OpenSearchOp;
import org.gcube.opensearch.opensearchoperator.OpenSearchOpConfig;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResourceCache;
import org.gcube.opensearch.opensearchoperator.resource.OpenSearchResource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import search.library.util.cql.query.tree.GCQLNode;

public class OpenSearchDataSourceResource
extends GCUBEWSResource {
    EnvHintCollection envHints = new EnvHintCollection();
    static GCUBELog logger = new GCUBELog(OpenSearchDataSource.class);
    public ISOpenSearchResource[] openSearchGenericResources = null;
    public ISOpenSearchResourceCache cache = new ISOpenSearchResourceCache();
    String[][] fixedParameters;
    public List<String> searchableFields = new ArrayList<String>();
    public List<String> presentableFields = new ArrayList<String>();
    public List<String> allPresentableNames = new ArrayList<String>();
    private static final int ISRETRY = 3;
    int inittime = (int)Calendar.getInstance().getTimeInMillis() / 1000 / 60;
    public static final String RP_ADAPTOR_ID = "AdaptorID";
    public static final String RP_COLLECTION_ID = "CollectionID";
    public static final String RP_SUPPORTED_RELATIONS = "SupportedRelations";
    public static final String RP_FIELDS = "Fields";
    public static final String RP_DESCRIPTION_DOCUMENT_URI = "DescriptionDocumentURI";
    public static final String RP_FIXEDPARAMETERS = "FixedParameters";
    public static final String RP_OPENSEARCH_RESOURCE = "OpenSearchResource";
    protected static String[] RPNames = new String[]{"AdaptorID", "CollectionID", "SupportedRelations", "Fields", "DescriptionDocumentURI", "OpenSearchResource", "FixedParameters"};
    protected boolean bInitializing;

    private Document retrieveDescriptionDocument(String descriptionDocumentURI) throws Exception {
        URL DDUrl = new URL(descriptionDocumentURI);
        URLConnection conn = DDUrl.openConnection();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        Document descriptionDocument = builder.parse(new InputSource(in));
        in.close();
        return descriptionDocument;
    }

    public static String[] retrieveTemplates(DescriptionDocument dd, OpenSearchResource res) throws Exception {
        Map uniqueTemplates = dd.getUniqueTemplates();
        ArrayList supportedTemplates = new ArrayList();
        for (List templates : uniqueTemplates.values()) {
            supportedTemplates.addAll(templates);
        }
        return supportedTemplates.toArray(new String[1]);
    }

    public String[] getPropertyNames() {
        return RPNames;
    }

    public boolean isInitializing() {
        return this.bInitializing;
    }

    public void setIsInitializing(boolean isInitializing) {
        this.bInitializing = isInitializing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(Object ... args) throws Exception {
        int i;
        this.envHints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(ServiceContext.getContext().getScope().toString())));
        logger.debug((Object)"initialise is called!");
        this.setIsInitializing(true);
        GCUBEWSResourceKey key = (GCUBEWSResourceKey)args[0];
        String adaptorID = key.getValue().toString();
        String[] fields = (String[])args[1];
        String[] collectionID = (String[])args[2];
        String[][] fixedParameters = (String[][])args[5];
        XMLResult[] openSearchResourceXML = (XMLResult[])args[3];
        String[] openSearchResourceIds = (String[])args[4];
        this.getResourcePropertySet().get(RP_ADAPTOR_ID).clear();
        this.getResourcePropertySet().get(RP_ADAPTOR_ID).add((Object)adaptorID);
        int size = OpenSearchDataSource.SupportedRelations.values().length;
        this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).clear();
        this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).add((Object)"=");
        logger.debug((Object)("Just added to the resource property set RP_ADAPTOR_ID: " + this.getResourcePropertySet().get(RP_ADAPTOR_ID).get(0)));
        this.getResourcePropertySet().get(RP_COLLECTION_ID).clear();
        this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).clear();
        this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).clear();
        this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).clear();
        int providerCount = collectionID.length;
        this.openSearchGenericResources = new ISOpenSearchResource[providerCount];
        this.fixedParameters = new String[providerCount][];
        int fixedParamNo = 0;
        for (int i2 = 0; i2 < providerCount; ++i2) {
            try {
                ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
                synchronized (iSOpenSearchResourceCache) {
                    this.openSearchGenericResources[i2] = new ISOpenSearchResource(openSearchResourceXML[i2].toString(), this.cache.descriptionDocuments, this.cache.resourcesXML, this.cache.XSLTs, this.envHints);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Could not create ISOpenSearchResource :", (Throwable)e);
                throw e;
            }
            DescriptionDocument dd = new DescriptionDocument(this.openSearchGenericResources[i2].getDescriptionDocument(), (URLElementFactory)new BasicURLElementFactory(), (QueryElementFactory)new BasicQueryElementFactory());
            String[] templates = OpenSearchDataSourceResource.retrieveTemplates(dd, (OpenSearchResource)this.openSearchGenericResources[i2]);
            this.getResourcePropertySet().get(RP_COLLECTION_ID).add((Object)collectionID[i2]);
            logger.debug((Object)("Just added to the resource property set RP_COLLECTION_ID : " + this.getResourcePropertySet().get(RP_COLLECTION_ID).get(i2)));
            this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).add((Object)this.openSearchGenericResources[i2].getDescriptionDocURL().toString());
            logger.debug((Object)("Just added to the resource property set RP_DESCRIPTION_DOCUMENT_URI: " + this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).get(i2)));
            this.fixedParameters[i2] = fixedParameters[i2];
            size = fixedParameters[i2].length;
            for (int j = 0; j < size; ++j) {
                this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).add((Object)(this.openSearchGenericResources[i2].getDescriptionDocURL().toString() + ":" + fixedParameters[i2][j]));
                logger.debug((Object)("Just added to the resource property set RP_FIXEDPARAMETERS: " + this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).get(fixedParamNo++)));
            }
            this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).add((Object)openSearchResourceIds[i2]);
            logger.debug((Object)("Just added to the resource property set RP_OPENSEARCH_RESOURCE: " + this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).get(i2)));
        }
        this.setIsInitializing(false);
        HashMap parameters = new HashMap();
        for (i = 0; i < providerCount; ++i) {
            parameters.putAll(this.openSearchGenericResources[i].getParameters());
        }
        this.getResourcePropertySet().get(RP_FIELDS).clear();
        this.allPresentableNames.clear();
        for (i = 0; i < fields.length; ++i) {
            List f;
            String[] splitField = fields[i].split(":");
            this.getResourcePropertySet().get(RP_FIELDS).add((Object)(fields[i] + ":" + (String)parameters.get(splitField[splitField.length - 1])));
            logger.debug((Object)("Just added to the resource property set RP_FIELDS : " + this.getResourcePropertySet().get(RP_FIELDS).get(i)));
            if (!splitField[splitField.length - 2].equals("p") || (f = Field.getFieldsWithName((boolean)false, (String)splitField[splitField.length - 1])).isEmpty()) continue;
            this.allPresentableNames.add(((Field)f.get(0)).getName());
        }
        this.filterFieldInfo(this.presentableFields, this.searchableFields);
        logger.debug((Object)"initialise returned!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProviders(String[] fields, String[] collectionIds, String[] openSearchResourceIDs, String[][] fixedParams) throws Exception {
        int i;
        logger.debug((Object)"addProviders is called!");
        int providerToAddCount = collectionIds.length;
        String[][] savedFixedParams = this.fixedParameters;
        ISOpenSearchResource[] savedOpenSearchResources = this.openSearchGenericResources;
        ISOpenSearchResource[] openSearchResourcesToAdd = new ISOpenSearchResource[providerToAddCount];
        XMLResult[] openSearchResourceXML = new XMLResult[providerToAddCount];
        for (i = 0; i < providerToAddCount; ++i) {
            openSearchResourceXML[i] = OpenSearchDataSourceResource.retrieveGenericResource(openSearchResourceIDs[i], GCUBEScope.getScope((String)((String)this.getResourcePropertySet().getScope().get(0))));
            ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
            synchronized (iSOpenSearchResourceCache) {
                openSearchResourcesToAdd[i] = new ISOpenSearchResource(openSearchResourceXML[i].toString(), this.cache.descriptionDocuments, this.cache.resourcesXML, this.cache.XSLTs, this.envHints);
                continue;
            }
        }
        for (i = 0; i < fields.length; ++i) {
            this.getResourcePropertySet().get(RP_FIELDS).add((Object)fields[i]);
            logger.debug((Object)("Just added to the resource property set RP_FIELDS : " + this.getResourcePropertySet().get(RP_FIELDS).get(i)));
        }
        this.allPresentableNames.clear();
        for (i = 0; i < this.getResourcePropertySet().get(RP_FIELDS).size(); ++i) {
            List f;
            String[] splitField = ((String)this.getResourcePropertySet().get(RP_FIELDS).get(i)).split(":");
            if (!splitField[splitField.length - 2].equals("p") || (f = Field.getFieldsWithName((boolean)false, (String)splitField[splitField.length - 1])).isEmpty()) continue;
            this.allPresentableNames.add(((Field)f.get(0)).getName());
        }
        this.filterFieldInfo(this.presentableFields, this.searchableFields);
        try {
            int providerCount = this.getResourcePropertySet().get(RP_COLLECTION_ID).size();
            this.fixedParameters = new String[providerCount + providerToAddCount][];
            this.openSearchGenericResources = new ISOpenSearchResource[providerCount + providerToAddCount];
            int i2 = 0;
            for (i2 = 0; i2 < providerCount; ++i2) {
                this.fixedParameters[i2] = savedFixedParams[i2];
                this.openSearchGenericResources[i2] = savedOpenSearchResources[i2];
            }
            for (int j = 0; j < providerToAddCount; ++j) {
                this.fixedParameters[i2 + j] = fixedParams[j];
                this.openSearchGenericResources[i2 + j] = openSearchResourcesToAdd[j];
                this.getResourcePropertySet().get(RP_COLLECTION_ID).add((Object)collectionIds[j]);
                logger.debug((Object)("Just added to the resource property set RP_COLLECTIONID : " + this.getResourcePropertySet().get(RP_COLLECTION_ID).get(providerCount + j)));
                this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).add((Object)openSearchResourceIDs[j]);
                logger.debug((Object)("Just added to the resource property set RP_OPENSEARCHRESOURCE : " + this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).get(providerCount + j)));
                this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).add((Object)this.openSearchGenericResources[i2 + j].getDescriptionDocURL().toString());
                logger.debug((Object)("Just added to the resource property set RP_DESCRIPTION_DOCUMENT_URI : " + this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).get(providerCount + j)));
            }
        }
        catch (Exception e) {
            this.fixedParameters = savedFixedParams;
            this.openSearchGenericResources = savedOpenSearchResources;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
        try {
            int i;
            int i2;
            int size;
            logger.debug((Object)"OnLoad started!");
            this.setIsInitializing(true);
            boolean clearCacheOnStartup = true;
            OpenSearchDataSourceConfig config = (OpenSearchDataSourceConfig)StatefulContext.getPortTypeContext().getProperty("config", new boolean[]{false});
            if (config != null) {
                clearCacheOnStartup = config.getClearCacheOnStartup();
                logger.debug((Object)("Read configuration property: clearCacheOnStartup = " + config.getClearCacheOnStartup()));
            } else {
                logger.warn((Object)"Could not read configuration property: clearCacheOnStartup. Using default: true");
            }
            String scope = (String)this.getResourcePropertySet().getScope().get(0);
            logger.debug((Object)("Loaded scope: " + scope));
            this.getServiceContext().setScope(GCUBEScope.getScope((String)scope));
            this.envHints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(scope)));
            ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
            synchronized (iSOpenSearchResourceCache) {
                int i3;
                this.cache = new ISOpenSearchResourceCache();
                size = ois.readInt();
                for (i3 = 0; i3 < size; ++i3) {
                    this.cache.XSLTs.put((String)ois.readObject(), (String)ois.readObject());
                }
                size = ois.readInt();
                for (i3 = 0; i3 < size; ++i3) {
                    this.cache.descriptionDocuments.put((String)ois.readObject(), (String)ois.readObject());
                }
                size = ois.readInt();
                for (i3 = 0; i3 < size; ++i3) {
                    this.cache.resourcesXML.put((String)ois.readObject(), (String)ois.readObject());
                }
                for (Map.Entry e : this.cache.resourcesXML.entrySet()) {
                    this.cache.resources.put(e.getKey(), new ISOpenSearchResource((String)this.cache.resourcesXML.get(e.getKey()), this.cache.descriptionDocuments, this.cache.resourcesXML, this.cache.XSLTs, this.envHints));
                }
            }
            String adaptorID = (String)ois.readObject();
            this.getResourcePropertySet().get(RP_ADAPTOR_ID).clear();
            this.getResourcePropertySet().get(RP_ADAPTOR_ID).add((Object)adaptorID);
            size = ois.readInt();
            this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).clear();
            for (i2 = 0; i2 < size; ++i2) {
                this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).add((Object)((String)ois.readObject()));
            }
            logger.debug((Object)("Just read supported relations size= " + size));
            size = ois.readInt();
            this.getResourcePropertySet().get(RP_FIELDS).clear();
            this.allPresentableNames.clear();
            for (i2 = 0; i2 < size; ++i2) {
                this.getResourcePropertySet().get(RP_FIELDS).add((Object)((String)ois.readObject()));
            }
            for (i2 = 0; i2 < size; ++i2) {
                List f;
                String[] splitField = ((String)this.getResourcePropertySet().get(RP_FIELDS).get(i2)).split(":");
                if (!splitField[splitField.length - 2].equals("p") || (f = Field.getFieldsWithName((boolean)false, (String)splitField[splitField.length - 1])).isEmpty()) continue;
                this.allPresentableNames.add(((Field)f.get(0)).getName());
            }
            logger.debug((Object)("Just read fields size= " + size));
            this.filterFieldInfo(this.presentableFields, this.searchableFields);
            size = ois.readInt();
            this.getResourcePropertySet().get(RP_COLLECTION_ID).clear();
            for (i2 = 0; i2 < size; ++i2) {
                this.getResourcePropertySet().get(RP_COLLECTION_ID).add((Object)((String)ois.readObject()));
            }
            logger.debug((Object)("Just read collections size= " + size));
            int providerCount = this.getResourcePropertySet().get(RP_COLLECTION_ID).size();
            size = ois.readInt();
            this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).clear();
            for (int i4 = 0; i4 < size; ++i4) {
                this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).add((Object)((String)ois.readObject()));
            }
            logger.debug((Object)("Just read description document uris size= " + size));
            int fixedParameterProviderCount = 0;
            this.fixedParameters = new String[providerCount][];
            size = ois.readInt();
            this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).clear();
            List[] tmpFixedParameters = new List[providerCount];
            for (i = 0; i < providerCount; ++i) {
                tmpFixedParameters[i] = new ArrayList();
            }
            for (i = 0; i < size; ++i) {
                String fixedParameter = (String)ois.readObject();
                this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).add((Object)fixedParameter);
                if (i > 0 && !((String)this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).get(i)).split(":")[0].equals(((String)this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).get(i)).split(":")[0])) {
                    ++fixedParameterProviderCount;
                }
                tmpFixedParameters[fixedParameterProviderCount].add(fixedParameter);
            }
            for (i = 0; i < providerCount; ++i) {
                this.fixedParameters[i] = tmpFixedParameters[i].toArray(new String[0]);
            }
            logger.debug((Object)("Just read fixed parameters size= " + size));
            size = ois.readInt();
            this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).clear();
            for (i = 0; i < size; ++i) {
                this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).add((Object)((String)ois.readObject()));
            }
            logger.debug((Object)("Just read opensearch resource size= " + size));
            this.openSearchGenericResources = new ISOpenSearchResource[providerCount];
            ISOpenSearchResourceCache i5 = this.cache;
            synchronized (i5) {
                for (int i6 = 0; i6 < providerCount; ++i6) {
                    this.openSearchGenericResources[i6] = (ISOpenSearchResource)this.cache.resources.get(this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).get(i6));
                }
            }
            if (firstLoad && clearCacheOnStartup) {
                logger.debug((Object)"OnLoad clearing cache");
                try {
                    this.clearCache(GCUBEScope.getScope((String)scope));
                }
                catch (FailedToRevertException e) {
                    logger.warn((Object)"Could not clear cache");
                    throw e;
                }
                catch (Exception e) {
                    logger.warn((Object)"Could not clear cache. Will use stored generic resource");
                }
            }
            this.setIsInitializing(false);
            logger.debug((Object)"OnLoad finished!");
        }
        catch (Exception e) {
            logger.error((Object)"Caught exception during OnLoad", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStore(ObjectOutputStream oos) throws Exception {
        int i;
        int size;
        logger.debug((Object)"OnStore started!");
        ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
        synchronized (iSOpenSearchResourceCache) {
            size = this.cache.XSLTs.size();
            oos.writeInt(size);
            for (Map.Entry e : this.cache.XSLTs.entrySet()) {
                oos.writeObject(e.getKey());
                oos.writeObject(e.getValue());
            }
            size = this.cache.descriptionDocuments.size();
            oos.writeInt(size);
            for (Map.Entry e : this.cache.descriptionDocuments.entrySet()) {
                oos.writeObject(e.getKey());
                oos.writeObject(e.getValue());
            }
            size = this.cache.resourcesXML.size();
            oos.writeInt(size);
            for (Map.Entry e : this.cache.resourcesXML.entrySet()) {
                oos.writeObject(e.getKey());
                oos.writeObject(e.getValue());
            }
        }
        oos.writeObject((String)this.getResourcePropertySet().get(RP_ADAPTOR_ID).get(0));
        size = this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).size();
        oos.writeInt(size);
        logger.debug((Object)("Just wrote supported relations size= " + size));
        for (i = 0; i < size; ++i) {
            oos.writeObject((String)this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).get(i));
        }
        size = this.getResourcePropertySet().get(RP_FIELDS).size();
        oos.writeInt(size);
        logger.debug((Object)("Just wrote fields size= " + size));
        for (i = 0; i < size; ++i) {
            oos.writeObject((String)this.getResourcePropertySet().get(RP_FIELDS).get(i));
        }
        size = this.getResourcePropertySet().get(RP_COLLECTION_ID).size();
        oos.writeInt(size);
        logger.debug((Object)("Just wrote collection size= " + size));
        for (i = 0; i < size; ++i) {
            oos.writeObject((String)this.getResourcePropertySet().get(RP_COLLECTION_ID).get(i));
        }
        size = this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).size();
        oos.writeInt(size);
        logger.debug((Object)("Just wrote description document uris size= " + size));
        for (i = 0; i < size; ++i) {
            oos.writeObject((String)this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).get(i));
        }
        size = this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).size();
        oos.writeInt(size);
        for (i = 0; i < size; ++i) {
            oos.writeObject((String)this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).get(i));
        }
        size = this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).size();
        oos.writeInt(size);
        logger.debug((Object)("Just wrote opensearch resource size= " + size));
        for (i = 0; i < size; ++i) {
            oos.writeObject((String)this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).get(i));
        }
        logger.debug((Object)"OnStore finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache(GCUBEScope scope) throws Exception {
        int providerCount = this.getResourcePropertySet().get(RP_COLLECTION_ID).size();
        String[] genericResourceXML = new String[providerCount];
        for (int i = 0; i < providerCount; ++i) {
            genericResourceXML[i] = OpenSearchDataSourceResource.retrieveGenericResource(this.getOpenSearchResource(i), scope).toString();
        }
        ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
        synchronized (iSOpenSearchResourceCache) {
            int i;
            ISOpenSearchResource[] savedResources = new ISOpenSearchResource[providerCount];
            String[] savedDdUris = new String[providerCount];
            for (i = 0; i < providerCount; ++i) {
                savedResources[i] = this.openSearchGenericResources[i];
                savedDdUris[i] = this.getDescriptionDocumentURI(i);
            }
            this.cache.descriptionDocuments.clear();
            this.cache.resources.clear();
            this.cache.resourcesXML.clear();
            this.cache.XSLTs.clear();
            for (i = 0; i < providerCount; ++i) {
                String genericResourceId = this.getOpenSearchResource(i);
                ISOpenSearchResourceCache cache = this.cache;
                String ddURI = savedDdUris[i];
                EnvHintCollection envHints = this.getISEnvHints();
                Exception ex = null;
                boolean fail = false;
                try {
                    this.openSearchGenericResources[i] = new ISOpenSearchResource(genericResourceXML[i], cache.descriptionDocuments, cache.resourcesXML, cache.XSLTs, envHints);
                }
                catch (Exception e) {
                    logger.warn((Object)"Could not create OpenSearch resource instance during cache clearing. Using old instance.", (Throwable)e);
                    fail = true;
                    ex = e;
                }
                cache.resources.put(ddURI, this.openSearchGenericResources[i]);
                if (fail) continue;
                DescriptionDocument dd = null;
                ddURI = this.openSearchGenericResources[i].getDescriptionDocURL();
                try {
                    dd = new DescriptionDocument(this.openSearchGenericResources[i].getDescriptionDocument(), (URLElementFactory)new BasicURLElementFactory(), (QueryElementFactory)new BasicQueryElementFactory());
                }
                catch (Exception e) {
                    logger.warn((Object)"Could not create Description Document instance during cache clearing. Using old OpenSearch resource instance.", (Throwable)e);
                    fail = true;
                    ex = e;
                }
                if (!fail && !fail) {
                    try {
                        if (i == 0) {
                            this.setDescriptionDocumentURI(ddURI);
                        } else {
                            this.addDescriptionDocumentURI(ddURI);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Could not update WS resource with the new Description Document URI. Using old OpenSearch resource instance", (Throwable)e);
                        fail = true;
                        ex = e;
                    }
                }
                if (!fail) continue;
                cache.resources.clear();
                for (int j = 0; j < providerCount; ++j) {
                    this.openSearchGenericResources[j] = savedResources[j];
                    cache.resources.put(savedDdUris[j], savedResources[j]);
                }
                this.setDescriptionDocumentURI(savedDdUris);
                throw ex;
            }
        }
    }

    public static XMLResult retrieveGenericResource(String id, GCUBEScope scope) throws Exception {
        ISClient client = null;
        GCUBEGenericQuery query = null;
        client = (ISClient)GHNContext.getImplementation(ISClient.class);
        query = client.getQuery("GCUBEResourceQuery");
        query.addParameters(new QueryParameter[]{new QueryParameter("FILTER", "$result/ID/string() eq '" + id + "'"), new QueryParameter("TYPE", "GenericResource"), new QueryParameter("RESULT", "$result/Profile/Body")});
        List res = null;
        Exception ex = null;
        for (int retryOnError = 0; retryOnError < 3; ++retryOnError) {
            try {
                res = client.execute((ISQuery)query, scope);
                break;
            }
            catch (Exception e) {
                logger.error((Object)"Could not retrieve generic resource. continuing");
                ex = e;
                continue;
            }
        }
        if (res == null || res.size() == 0) {
            if (ex != null) {
                throw new GCUBERetrySameException("The generic resource with ID: " + id + " was not found.", (Throwable)ex);
            }
            throw new GCUBERetrySameException("The generic resource with ID: " + id + " was not found.");
        }
        if (res.size() > 1) {
            throw new GCUBERetrySameException("The generic resource with ID: " + id + " was found " + res.size() + " times published.");
        }
        return (XMLResult)res.get(0);
    }

    public void store() {
        if (!this.isInitializing()) {
            super.store();
        }
    }

    public String getAdaptorID() {
        return (String)this.getResourcePropertySet().get(RP_ADAPTOR_ID).get(0);
    }

    public void setAdaptorID(String adaptorID) {
        this.getResourcePropertySet().get(RP_ADAPTOR_ID).clear();
        this.getResourcePropertySet().get(RP_ADAPTOR_ID).add((Object)adaptorID);
    }

    public String[] getFields() {
        int size = this.getResourcePropertySet().get(RP_FIELDS).size();
        String[] fields = new String[size];
        for (int i = 0; i < size; ++i) {
            fields[i] = (String)this.getResourcePropertySet().get(RP_FIELDS).get(i);
        }
        return fields;
    }

    public String[] getCollectionID() {
        int size = this.getResourcePropertySet().get(RP_COLLECTION_ID).size();
        String[] colIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            colIDs[i] = (String)this.getResourcePropertySet().get(RP_COLLECTION_ID).get(i);
        }
        return colIDs;
    }

    public void setCollectionID(String[] collectionIDs) throws Exception {
        int size = collectionIDs.length;
        this.getResourcePropertySet().get(RP_COLLECTION_ID).clear();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_COLLECTION_ID).add((Object)collectionIDs[i]);
        }
    }

    public void addCollectionID(String collectionID) {
        String[] collections = this.getCollectionID();
        String[] newCollections = new String[collections.length + 1];
        for (int i = 0; i < collections.length; ++i) {
            newCollections[i] = collections[i];
        }
        newCollections[collections.length] = collectionID;
        try {
            this.setCollectionID(newCollections);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to set CollectionID resource property.", (Throwable)e);
        }
    }

    public String[] getDescriptionDocumentURI() {
        int size = this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).size();
        String[] ddURIs = new String[size];
        for (int i = 0; i < size; ++i) {
            ddURIs[i] = (String)this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).get(i);
        }
        return ddURIs;
    }

    public String getDescriptionDocumentURI(int i) {
        return (String)this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).get(i);
    }

    public void setDescriptionDocumentURI(String descriptionDocumentURI) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).clear();
            this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).add((Object)descriptionDocumentURI);
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public void addDescriptionDocumentURI(String descriptionDocumentURI) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).add((Object)descriptionDocumentURI);
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public void setDescriptionDocumentURI(String[] descriptionDocumentURIs) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).clear();
            for (int i = 0; i < descriptionDocumentURIs.length; ++i) {
                this.getResourcePropertySet().get(RP_DESCRIPTION_DOCUMENT_URI).add((Object)descriptionDocumentURIs[i]);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public String[] getFixedParameters() {
        int size = this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).size();
        String[] fixedParameters = new String[size];
        for (int i = 0; i < size; ++i) {
            fixedParameters[i] = (String)this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).get(i);
        }
        return fixedParameters;
    }

    public void setFixedParameters(String[] fixedParameters) throws Exception {
        int size = fixedParameters.length;
        this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).clear();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_FIXEDPARAMETERS).add((Object)fixedParameters[i]);
        }
    }

    public String getOpenSearchResource(int i) {
        return (String)this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).get(i);
    }

    public String[] getOpenSearchResource() {
        String[] openSearchResources = new String[this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).size()];
        for (int i = 0; i < openSearchResources.length; ++i) {
            openSearchResources[i] = (String)this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).get(i);
        }
        return openSearchResources;
    }

    public void setOpenSearchResource(String openSearchResource) {
        this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).clear();
        this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).add((Object)openSearchResource);
    }

    public void setOpenSearchResource(String[] openSearchResource) {
        this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).clear();
        for (int i = 0; i < openSearchResource.length; ++i) {
            this.getResourcePropertySet().get(RP_OPENSEARCH_RESOURCE).add((Object)openSearchResource[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDescriptionDocument(int i) {
        ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
        synchronized (iSOpenSearchResourceCache) {
            return this.openSearchGenericResources[i].getDescriptionDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSearchResource getCachedOpenSearchResource(String ddURL) {
        ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
        synchronized (iSOpenSearchResourceCache) {
            return (OpenSearchResource)this.cache.resources.get(ddURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpenSearchResource> getCachedOpenSearchResources() {
        ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
        synchronized (iSOpenSearchResourceCache) {
            return new ArrayList<OpenSearchResource>(this.cache.resources.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCachedOpenSearchResource(String ddURL, XMLResult resource) throws Exception {
        ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
        synchronized (iSOpenSearchResourceCache) {
            this.cache.resources.put(ddURL, new ISOpenSearchResource(resource.toString(), this.envHints));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCachedOpenSearchResources(Map<String, XMLResult> resources) throws Exception {
        ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
        synchronized (iSOpenSearchResourceCache) {
            for (Map.Entry<String, XMLResult> e : resources.entrySet()) {
                this.cache.resources.put(e.getKey(), new ISOpenSearchResource(e.getValue().toString(), this.envHints));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI query(String cqlQuery) throws RemoteException {
        try {
            Map<String, FactoryClassNamePair> factories = null;
            OpenSearchDataSourceConfig config = (OpenSearchDataSourceConfig)StatefulContext.getPortTypeContext().getProperty("config", new boolean[]{false});
            if (config != null) {
                factories = config.getFactories();
                logger.debug((Object)("Read configuration property: factories = " + config.getFactories()));
            } else {
                logger.warn((Object)"Could not read configuration property: factories. Operating using only basic factories");
            }
            OpenSearchOpConfig cfg = new OpenSearchOpConfig(null, null, null, factories);
            ISOpenSearchResourceCache iSOpenSearchResourceCache = this.cache;
            synchronized (iSOpenSearchResourceCache) {
                cfg.ISCache = this.cache;
            }
            OpenSearchGcqlProcessor processor = new OpenSearchGcqlProcessor();
            OpenSearchGcqlAnnotator annotator = new OpenSearchGcqlAnnotator();
            GCQLNode queryTree = processor.parseQuery(cqlQuery);
            GCQLNodeAnnotation annotationTree = annotator.processNode(queryTree);
            String collection = annotator.getFirstEncounteredCollectionId(annotationTree);
            processor.setAnnotationTree(annotationTree);
            processor.setCollection(collection);
            processor.setFields(this.allPresentableNames);
            processor.setDataSourceLocator(((GCUBEWSResourceKey)this.getID()).getValue());
            logger.debug((Object)("Datasource locator is " + ((GCUBEWSResourceKey)this.getID()).getValue()));
            OpenSearchGcqlQueryContainer query = (OpenSearchGcqlQueryContainer)processor.processQuery(this.presentableFields, this.searchableFields);
            int index = -1;
            for (int i = 0; i < this.getResourcePropertySet().get(RP_COLLECTION_ID).size(); ++i) {
                if (!this.getResourcePropertySet().get(RP_COLLECTION_ID).get(i).equals(processor.getCollection())) continue;
                index = i;
                break;
            }
            if (index == -1) {
                throw new RemoteException("Could not locate provider");
            }
            OpenSearchOp op = new OpenSearchOp((OpenSearchResource)this.openSearchGenericResources[index], this.fixedParameters[index], cfg, new EnvHintCollection());
            URI loc = op.query(query.queries.get(processor.getCollection()).get("*").get(0).toString());
            OpenSearchCollectionEnricher colEnricher = new OpenSearchCollectionEnricher(collection, loc);
            new Thread(colEnricher).start();
            loc = colEnricher.getLocator();
            FieldDefinitionInfo fieldDefInfo = this.createFieldDefinition(query.getProjectedFields());
            FieldDefinition[] fieldDef = fieldDefInfo.fieldDefinition;
            Map<String, Integer> fieldPositions = fieldDefInfo.fieldPositions;
            RecordDefinition[] definition = new RecordDefinition[]{new GenericRecordDefinition(fieldDef)};
            OpenSearchProjector projector = new OpenSearchProjector(loc, definition, processor.getProjectedFields(), fieldPositions);
            projector.setReaderTimeout(3L, TimeUnit.MINUTES);
            new Thread(projector).start();
            return Locators.localToTCP((URI)projector.getProjectionLocator());
        }
        catch (Exception e) {
            logger.error((Object)("Unable to execute query: \"" + cqlQuery + "\""), (Throwable)e);
            throw new RemoteException("Could not execute query", e);
        }
    }

    private FieldDefinitionInfo createFieldDefinition(Map<String, String> projections) {
        Integer pos = 0;
        HashMap<String, Integer> fieldPositions = new HashMap<String, Integer>();
        ArrayList<StringFieldDefinition> fieldDef = new ArrayList<StringFieldDefinition>();
        fieldDef.add(new StringFieldDefinition("gDocCollectionID"));
        Integer n = pos;
        Integer n2 = pos = Integer.valueOf(pos + 1);
        fieldPositions.put("gDocCollectionID", n);
        fieldDef.add(new StringFieldDefinition("ObjectID"));
        n = pos;
        n2 = pos = Integer.valueOf(pos + 1);
        fieldPositions.put("ObjectID", n);
        if (projections.size() > 0) {
            Integer n3;
            Integer n4;
            String fieldId;
            String proj;
            for (Map.Entry<String, String> current : projections.entrySet()) {
                proj = current.getValue();
                fieldId = current.getKey();
                if (!proj.equalsIgnoreCase("gDocCollectionID")) continue;
                fieldDef.add(new StringFieldDefinition(fieldId));
                n4 = pos;
                n3 = pos = Integer.valueOf(pos + 1);
                fieldPositions.put("gDocCollectionID", n4);
            }
            for (Map.Entry<String, String> current : projections.entrySet()) {
                proj = current.getValue();
                fieldId = current.getKey();
                if (!proj.equalsIgnoreCase("gDocCollectionLang")) continue;
                fieldDef.add(new StringFieldDefinition(fieldId));
                n4 = pos;
                n3 = pos = Integer.valueOf(pos + 1);
                fieldPositions.put("gDocCollectionLang", n4);
            }
            for (Map.Entry<String, String> current : projections.entrySet()) {
                proj = current.getValue();
                fieldId = current.getKey();
                if (proj.equalsIgnoreCase("gDocCollectionLang") || proj.equalsIgnoreCase("gDocCollectionID")) continue;
                fieldDef.add(new StringFieldDefinition(fieldId));
                fieldPositions.put(fieldId, pos);
                n4 = pos;
                n3 = pos = Integer.valueOf(pos + 1);
            }
            if (fieldDef.size() == 1) {
                logger.error((Object)" no valid projection ");
            }
        }
        return new FieldDefinitionInfo(fieldDef.toArray(new FieldDefinition[fieldDef.size()]), fieldPositions);
    }

    public EnvHintCollection getISEnvHints() {
        return this.envHints;
    }

    public void onResourceRemoval() {
    }

    protected void filterFieldInfo(List<String> presentableFields, List<String> searchableFields) {
        presentableFields.clear();
        searchableFields.clear();
        HashSet<String> searchableSet = new HashSet<String>();
        HashSet<String> presentableSet = new HashSet<String>();
        for (String field : this.getFields()) {
            String fieldName = OpenSearchDataSourceResource.getFieldName(field, "p");
            if (fieldName != null) {
                if (!presentableSet.add(fieldName)) continue;
                logger.trace((Object)("added presentable field: " + fieldName));
                presentableFields.add(fieldName);
                continue;
            }
            fieldName = OpenSearchDataSourceResource.getFieldName(field, "s");
            if (!searchableSet.add(fieldName)) continue;
            logger.trace((Object)("added searchable field: " + fieldName));
            searchableFields.add(fieldName);
        }
    }

    private static String getFieldName(String field, String type) {
        int from = field.indexOf(":", field.indexOf(":") + 1) + 1;
        String t = field.substring(from, from + type.length());
        if (!t.equals(type)) {
            return null;
        }
        from = field.indexOf(":", from) + 1;
        int to = field.indexOf(":", from);
        return field.substring(from, to);
    }
}

