package org.gcube.opensearch.opensearchdatasource;

import java.util.ArrayList;

import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.rr.ResourceRegistry;

import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.state.GCUBEWSHome;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.opensearch.opensearchdatasource.cacherefresh.CacheRefresher;
import org.globus.wsrf.ResourceException;


/**
 * In charge of creating and retrieving OpenSearchResource instances. The "ResourceHome" entity according to the factory pattern.
 
 * @author gerasimos.farantatos, NKUA
 *
 */
public class OpenSearchDataSourceResourceHome extends GCUBEWSHome {

	private EnvHintCollection envHints;
	CacheRefresher refresher;
	
    public GCUBEStatefulPortTypeContext getPortTypeContext() {
    	return StatefulContext.getPortTypeContext();
    }

    /*
	 * (non-Javadoc)
	 * @see org.gcube.common.core.state.GCUBEWSHome#onRemove(org.gcube.common.core.state.GCUBEWSResource)
	 */
	protected boolean onRemove(GCUBEWSResource resource) throws ResourceException {
		((OpenSearchDataSourceResource) resource).onResourceRemoval();
		return super.onRemove(resource);
	}
	
	@Override
	protected void onInitialisation() throws Exception {
    	try{
    		logger.debug("Now in resource home onInitialisation");
    	
    		TCPConnectionManager.Init(new TCPConnectionManagerConfig(GHNContext.getContext().getHostname(), new ArrayList<PortRange>(), true));
    		TCPConnectionManager.RegisterEntry(new TCPConnectionHandler());
    		TCPConnectionManager.RegisterEntry(new TCPStoreConnectionHandler());
    		logger.debug("Connection manager for gRS2 Initialized");
    		
    		envHints = new EnvHintCollection();
    		envHints.AddHint(new NamedEnvHint("retryOnErrorTimes", new EnvHint("5")));
    		envHints.AddHint(new NamedEnvHint("retryOnErrorInterval", new EnvHint("200")));
    	
    		InformationSystem.Init("gr.uoa.di.madgik.environment.gcube.GCubeInformationSystemProvider", envHints);
    		logger.debug("Information system initialized");
    		ResourceRegistry.startBridging();
    		logger.debug("Registry bridging initiated");
    	}catch(Exception e){
    		logger.error("Could not initialize Information System", e);
    	}
    
		super.onInitialisation();
	}
	
	@Override
	protected void onReady() throws Exception {	
		super.onReady();
		// Get configuration:
		OpenSearchDataSourceConfig config = (OpenSearchDataSourceConfig) StatefulContext.getPortTypeContext().getProperty("config", false);
		if(config != null){
			logger.debug("OpenSearch DataSource Config:" +
					"\n   clearCacheOnStartup: " + config.getClearCacheOnStartup() +
					"\n   cacheRefreshIntervalMillis: " + config.getCacheRefreshIntervalMillis());
			refresher = new CacheRefresher(config.getCacheRefreshIntervalMillis());
		}else
			refresher = new CacheRefresher(0);
			
	
		Thread cacheRefresher = new Thread(refresher);
		cacheRefresher.setDaemon(true);
		cacheRefresher.start();
	}
	
	public void refreshCache() {
		refresher.forceRefresh();
	}
}
