package org.gcube.opensearch.opensearchdatasource;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.gcube.common.core.persistence.GCUBEWSFilePersistenceDelegate;

/**
 * This class handles the storing/loading of resource state.
 * 
 * @author Vasilis Verroios, NKUA
 */
public class OpenSearchDataSourceResourcePersistenceDelegate extends GCUBEWSFilePersistenceDelegate<OpenSearchDataSourceResource> {

//	/** For each resource being loaded, indicates whether it is being loaded for
//	 * the first time since the container started or not */
//	private Map<FullTextIndexLookupResource, Boolean> firstLoad = new HashMap<FullTextIndexLookupResource, Boolean>();
//	
//	/*
//	 * (non-Javadoc)
//	 * @see org.gcube.common.core.persistence.GCUBEFilePersistenceDelegate#onLoad(org.gcube.common.core.state.GCUBEStatefulResource, boolean)
//	 */
//	protected void onLoad(FullTextIndexLookupResource resource, boolean firstLoad) throws Exception {
//		synchronized(this.firstLoad) {
//			this.firstLoad.put(resource, firstLoad);
//		}
//		
//		StringWriter w = new StringWriter();
//		new Throwable().printStackTrace(new PrintWriter(w));
//		logger.debug("!!!!!!!!!! onLoad called on FullTextIndexLookupResourcePersistenceDelegate!");
//		logger.debug("caller for "+resource.getID()+" is\n"+w.toString());
//        try {
//             super.onLoad(resource,firstLoad);
//        } catch (Exception e) {
//             logger.error("problem",e);
//             throw e;
//        }
//	}
	
	/*
	 * (non-Javadoc)
	 * @see org.gcube.common.core.persistence.GCUBEWSFilePersistenceDelegate#onLoad(org.gcube.common.core.state.GCUBEWSResource, java.io.ObjectInputStream)
	 */
	protected void onLoad(OpenSearchDataSourceResource resource, ObjectInputStream ois) throws Exception {
		super.onLoad(resource, ois);
//		resource.onLoad(ois, firstLoad.get(resource));
		resource.onLoad(ois, true);
//		synchronized(this.firstLoad) {
//			this.firstLoad.remove(resource);
//		}
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.gcube.common.core.persistence.GCUBEWSFilePersistenceDelegate#onStore(org.gcube.common.core.state.GCUBEWSResource, java.io.ObjectOutputStream)
	 */
	protected void onStore(OpenSearchDataSourceResource resource, ObjectOutputStream oos) throws Exception {
		super.onStore(resource, oos);
		resource.onStore(oos);
	}
}