/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import java.util.ArrayList;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.state.GCUBEWSHome;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.opensearch.opensearchdatasource.OpenSearchDataSourceConfig;
import org.gcube.opensearch.opensearchdatasource.OpenSearchDataSourceResource;
import org.gcube.opensearch.opensearchdatasource.StatefulContext;
import org.gcube.opensearch.opensearchdatasource.cacherefresh.CacheRefresher;
import org.globus.wsrf.ResourceException;

public class OpenSearchDataSourceResourceHome
extends GCUBEWSHome {
    private EnvHintCollection envHints;
    CacheRefresher refresher;

    public GCUBEStatefulPortTypeContext getPortTypeContext() {
        return StatefulContext.getPortTypeContext();
    }

    protected boolean onRemove(GCUBEWSResource resource) throws ResourceException {
        ((OpenSearchDataSourceResource)resource).onResourceRemoval();
        return super.onRemove(resource);
    }

    protected void onInitialisation() throws Exception {
        try {
            this.logger.debug((Object)"Now in resource home onInitialisation");
            TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(GHNContext.getContext().getHostname(), new ArrayList(), true));
            TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
            TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
            this.logger.debug((Object)"Connection manager for gRS2 Initialized");
            this.envHints = new EnvHintCollection();
            this.envHints.AddHint(new NamedEnvHint("retryOnErrorTimes", new EnvHint("5")));
            this.envHints.AddHint(new NamedEnvHint("retryOnErrorInterval", new EnvHint("200")));
            InformationSystem.Init((String)"gr.uoa.di.madgik.environment.gcube.GCubeInformationSystemProvider", (EnvHintCollection)this.envHints);
            this.logger.debug((Object)"Information system initialized");
            ResourceRegistry.startBridging();
            this.logger.debug((Object)"Registry bridging initiated");
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not initialize Information System", (Throwable)e);
        }
        super.onInitialisation();
    }

    protected void onReady() throws Exception {
        super.onReady();
        OpenSearchDataSourceConfig config = (OpenSearchDataSourceConfig)StatefulContext.getPortTypeContext().getProperty("config", new boolean[]{false});
        if (config != null) {
            this.logger.debug((Object)("OpenSearch DataSource Config:\n   clearCacheOnStartup: " + config.getClearCacheOnStartup() + "\n   cacheRefreshIntervalMillis: " + config.getCacheRefreshIntervalMillis()));
            this.refresher = new CacheRefresher(config.getCacheRefreshIntervalMillis());
        } else {
            this.refresher = new CacheRefresher(0L);
        }
        Thread cacheRefresher = new Thread(this.refresher);
        cacheRefresher.setDaemon(true);
        cacheRefresher.start();
    }

    public void refreshCache() {
        this.refresher.forceRefresh();
    }
}

