/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.processor;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchProjector
implements Runnable {
    public static long TimeoutDef = 180L;
    public static TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private static Logger logger = LoggerFactory.getLogger((String)OpenSearchProjector.class.getName());
    private URI inLocator = null;
    private Map<String, String> projectedFields = null;
    private Map<String, Integer> fieldPositions = null;
    private RecordWriter<GenericRecord> writer = null;
    private long timeout = TimeoutDef;
    private TimeUnit timeUnit = TimeUnitDef;

    public OpenSearchProjector(URI inLocator, RecordDefinition[] projectionRecordDefinitions, Map<String, String> projectedFields, Map<String, Integer> fieldPositions) throws Exception {
        this.inLocator = inLocator;
        this.projectedFields = projectedFields;
        this.fieldPositions = fieldPositions;
        this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), projectionRecordDefinitions, 50, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
    }

    public void setReaderTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public URI getProjectionLocator() throws Exception {
        return this.writer.getLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ForwardReader reader = null;
        try {
            reader = new ForwardReader(this.inLocator);
            while (reader.getStatus() != IBuffer.Status.Dispose) {
                if (reader.getStatus() == IBuffer.Status.Close && reader.availableRecords() == 0) {
                    break;
                }
                Record rec = reader.get(this.timeout, this.timeUnit);
                if (rec == null) {
                    if (reader.getStatus() == IBuffer.Status.Open) {
                        logger.warn("Producer has timed out");
                    }
                    break;
                }
                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                    logger.info("Consumer side stopped consumption. Stopping.");
                    break;
                }
                BufferEvent event = reader.receive();
                if (event != null) {
                    try {
                        this.writer.emit(event);
                    }
                    catch (Exception e) {
                        logger.warn("Could not emit event");
                    }
                }
                GenericRecord outRec = new GenericRecord();
                Field[] fields = new Field[this.projectedFields.size() + 2];
                fields[0] = new StringField(((StringField)rec.getField("gDocCollectionID")).getPayload());
                fields[1] = new StringField(((StringField)rec.getField("ObjectID")).getPayload());
                if (this.projectedFields.get("gDocCollectionLang") != null) {
                    fields[this.fieldPositions.get((Object)"gDocCollectionLang").intValue()] = new StringField();
                    if (rec.getField("gDocCollectionLang") == null) {
                        ((StringField)fields[this.fieldPositions.get("gDocCollectionLang")]).setPayload("*");
                    } else {
                        ((StringField)fields[this.fieldPositions.get("gDocCollectionLang")]).setPayload(((StringField)rec.getField("gDocCollectionLang")).getPayload());
                    }
                }
                for (Map.Entry<String, String> projectedField : this.projectedFields.entrySet()) {
                    int position = this.fieldPositions.get(projectedField.getKey());
                    StringField field = (StringField)rec.getField(projectedField.getValue());
                    fields[position] = new StringField(field != null ? field.getPayload() : "");
                }
                outRec.setFields(fields);
                if (this.writer.put((Record)outRec, 60L, TimeUnit.SECONDS)) continue;
                if (this.writer.getStatus() == IBuffer.Status.Open) {
                    logger.warn("Consumer has timed out");
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("Could not perform result projection", (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                logger.warn("Could not close reader", (Throwable)e);
            }
            try {
                this.writer.close();
            }
            catch (Exception e) {
                logger.warn("Could not close writer", (Throwable)e);
            }
        }
    }
}

