/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.app;

import com.google.common.io.Resources;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.gcube.opensearch.opensearchdatasource.inject.OpenSearchServiceModule;
import org.gcube.opensearch.opensearchdatasource.service.OpenSearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchApp
extends Application {
    private Set<Class<?>> classes = new HashSet();
    private Set<Object> singletons = new HashSet();
    private static final Logger logger = LoggerFactory.getLogger(OpenSearchApp.class);

    public OpenSearchApp(@Context ServletContext servletContext) throws Exception {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
        }
        catch (Exception e) {
            throw new Exception("could not load property file  : deploy.properties");
        }
        String scope = properties.getProperty("scope").trim();
        String resourcesFoldername = properties.getProperty("resourcesFoldername").trim();
        logger.info("Initializing injector");
        Injector injector = Guice.createInjector((Module[])new Module[]{new OpenSearchServiceModule(resourcesFoldername)});
        logger.info("Getting service instance from injector");
        OpenSearchService service = (OpenSearchService)injector.getInstance(OpenSearchService.class);
        service.setScope(scope);
        logger.info("setting context attribute to register the service as managed");
        servletContext.setAttribute("resource-aware-managed-service", (Object)service);
        this.singletons.add(service);
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

