/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchdatasource.resources;

import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.inject.Inject;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.gcube.opensearch.opensearchdatasource.service.OpenSearchOperator;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ISOpenSearchResourceCache;
import org.gcube.rest.commons.helpers.JSONConverter;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourceawareservice.resources.StatefulResource;
import org.gcube.rest.commons.resourceawareservice.resources.exceptions.StatefulResourceException;
import org.gcube.rest.opensearch.common.resources.OpenSearchDataSourceResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchDataSourceResourceFactory
extends ResourceFactory<OpenSearchDataSourceResource> {
    private static final Logger logger = LoggerFactory.getLogger(OpenSearchDataSourceResourceFactory.class);
    private final OpenSearchOperator operator;

    @Inject
    public OpenSearchDataSourceResourceFactory(OpenSearchOperator operator) {
        this.operator = operator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSearchDataSourceResource createResource(String resourceID, String params) throws StatefulResourceException {
        OpenSearchDataSourceResource resource = (OpenSearchDataSourceResource)new Gson().fromJson(params, OpenSearchDataSourceResource.class);
        if (resource.getScope() != null && !resource.getScope().equalsIgnoreCase(this.getScope())) {
            logger.error("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
            throw new StatefulResourceException("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
        }
        logger.info("resource after deserialization 1.");
        logger.info(JSONConverter.convertToJSON((Object)resource, (boolean)true));
        resource.setResourceID(resourceID);
        resource.getEnvHints().AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(resource.getScope())));
        int providerCount = 0;
        if (resource.getOpenSearchResourceXML() != null && resource.getOpenSearchResourceXML().size() > 0) {
            providerCount = resource.getOpenSearchResourceXML().size();
        }
        resource.openSearchGenericResources = new ISOpenSearchResource[providerCount];
        if (resource.getOpenSearchResource() == null) {
            ArrayList l = Lists.newArrayList();
            resource.setOpenSearchResource((List)l);
        }
        ArrayList emptyList = Lists.newArrayList();
        resource.setDescriptionDocumentURI((List)emptyList);
        for (int i = 0; i < providerCount; ++i) {
            try {
                ISOpenSearchResourceCache iSOpenSearchResourceCache = resource.cache;
                synchronized (iSOpenSearchResourceCache) {
                    resource.openSearchGenericResources[i] = new ISOpenSearchResource(((String)resource.getOpenSearchResourceXML().get(i)).toString(), resource.cache.descriptionDocuments, resource.cache.resourcesXML, resource.cache.XSLTs, resource.getEnvHints());
                }
            }
            catch (Exception e) {
                logger.error("Could not create ISOpenSearchResource :", (Throwable)e);
                throw new StatefulResourceException("Could not create ISOpenSearchResource :", e);
            }
            try {
                resource.getDescriptionDocumentURI().add(resource.openSearchGenericResources[i].getDescriptionDocURL());
                continue;
            }
            catch (Exception e) {
                throw new StatefulResourceException("error creating description document and retrieving templates", e);
            }
        }
        logger.info("openSearchGenericResources size : " + resource.openSearchGenericResources.length);
        HashMap parameters = new HashMap();
        for (int i = 0; i < providerCount; ++i) {
            parameters.putAll(resource.openSearchGenericResources[i].getParameters());
        }
        logger.info("parameters : " + parameters);
        ArrayList presentables = Lists.newArrayList();
        ArrayList newFields = Lists.newArrayList();
        for (String field : resource.getFields()) {
            String[] splitField = field.split(":");
            newFields.add(field + ":" + (String)parameters.get(splitField[splitField.length - 1]));
        }
        resource.setFields((List)newFields);
        resource.allPresentableNames = resource.presentableFields;
        logger.info("openSearchResource : " + resource.getOpenSearchResource());
        logger.info("resource before addProviders : " + JSONConverter.convertToJSON((Object)resource, (boolean)true));
        try {
            this.operator.addProviders(resource, resource.getFields(), resource.getCollectionID(), resource.getOpenSearchResource(), resource.getFixedParameters());
        }
        catch (Exception e) {
            throw new StatefulResourceException("error in addProviders", e);
        }
        logger.info("resource after addProviders : " + JSONConverter.convertToJSON((Object)resource, (boolean)true));
        resource.setSupportedRelations(OpenSearchDataSourceResource.getSupportedRelationsSet());
        resource.setHostname(this.getHostname());
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadResource(OpenSearchDataSourceResource resource) throws StatefulResourceException {
        super.loadResource((StatefulResource)resource);
        resource.setHostname(this.getHostname());
        resource.getEnvHints().AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(resource.getScope())));
        int providerCount = 0;
        if (resource.getOpenSearchResourceXML() != null && resource.getOpenSearchResourceXML().size() > 0) {
            providerCount = resource.getOpenSearchResourceXML().size();
        }
        resource.openSearchGenericResources = new ISOpenSearchResource[providerCount];
        if (resource.getOpenSearchResource() == null) {
            ArrayList l = Lists.newArrayList();
            resource.setOpenSearchResource((List)l);
        }
        ArrayList emptyList = Lists.newArrayList();
        resource.setDescriptionDocumentURI((List)emptyList);
        for (int i = 0; i < providerCount; ++i) {
            try {
                ISOpenSearchResourceCache iSOpenSearchResourceCache = resource.cache;
                synchronized (iSOpenSearchResourceCache) {
                    resource.openSearchGenericResources[i] = new ISOpenSearchResource(((String)resource.getOpenSearchResourceXML().get(i)).toString(), resource.cache.descriptionDocuments, resource.cache.resourcesXML, resource.cache.XSLTs, resource.getEnvHints());
                }
            }
            catch (Exception e) {
                logger.error("Could not create ISOpenSearchResource :", (Throwable)e);
                throw new StatefulResourceException("Could not create ISOpenSearchResource :", e);
            }
            try {
                resource.getDescriptionDocumentURI().add(resource.openSearchGenericResources[i].getDescriptionDocURL());
                continue;
            }
            catch (Exception e) {
                throw new StatefulResourceException("error creating description document and retrieving templates", e);
            }
        }
        logger.info("openSearchGenericResources size : " + resource.openSearchGenericResources.length);
        HashMap parameters = new HashMap();
        for (int i = 0; i < providerCount; ++i) {
            parameters.putAll(resource.openSearchGenericResources[i].getParameters());
        }
        logger.info("parameters : " + parameters);
        ArrayList presentables = Lists.newArrayList();
        ArrayList newFields = Lists.newArrayList();
        for (String field : resource.getFields()) {
            String[] splitField = field.split(":");
            newFields.add(field);
        }
        resource.setFields((List)newFields);
        resource.allPresentableNames = resource.presentableFields;
        logger.info("openSearchResource" + resource.getOpenSearchResource());
        logger.info("resource before addProviders : " + JSONConverter.convertToJSON((Object)resource, (boolean)true));
        try {
            this.operator.addProviders(resource, resource.getFields(), resource.getCollectionID(), resource.getOpenSearchResource(), resource.getFixedParameters());
        }
        catch (Exception e) {
            throw new StatefulResourceException("error in addProviders", e);
        }
        logger.info("resource after addProviders : " + JSONConverter.convertToJSON((Object)resource, (boolean)true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getScope() {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
            String string = properties.getProperty("scope");
            return string;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHostname() {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
            String string = properties.getProperty("hostname");
            return string;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
    }
}

