/**
 * 
 */
package ISClient;

import java.io.FileReader;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;

/**
 * @author Spyros Boutsis, NKUA
 *
 */
public class UpdateGenericResource {
	
	public static void main(String[] args) {
		
		if (args.length < 2) {
			System.out.println("Wrong number of arguments. Usage:");
			System.out.println("UpdateGenericResource <scope> <GR_File_Name> [ <GR_File_Name2> ... ]");
			System.exit(-1);
		}
		
		try {
			GCUBEScope scope = GCUBEScope.getScope(args[0]);
			ISPublisher publisher = GHNContext.getImplementation(ISPublisher.class);
			GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl() {  public boolean isSecurityEnabled() {return false;}};
			
			for (int i=1; i< args.length; i++) {
				GCUBEGenericResource resource = GHNContext.getImplementation(GCUBEGenericResource.class);
				FileReader fis = new FileReader(args[i]);
				resource.load(fis);
				if (resource.getID().trim().length() == 0) {
					System.out.println("The given resource does not have an assigned ID, thus it cannot be updated in the IS.");
					System.exit(-1);
				}
								
				publisher.registerGCUBEResource(resource, scope, managerSec);
				System.out.println("Generic resource updated.");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
