/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.queryelements.extensions.time;

import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Map;
import org.gcube.opensearch.opensearchlibrary.TimeConstants;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElement;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElementDecorator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class TimeQueryElement
extends QueryElementDecorator {
    private Element query = null;
    private Map<String, String> nsPrefixes = null;
    protected String role = null;
    private String start = null;
    private String end = null;

    private String parseOptionalString(String attribute) throws Exception {
        Attr n = this.query.getAttributeNodeNS(null, attribute);
        if (n != null || (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", attribute)) != null) {
            return n.getNodeValue();
        }
        return null;
    }

    private String parseInt(String attribute) throws Exception {
        String valueStr = null;
        Attr n = this.query.getAttributeNodeNS(null, attribute);
        if (n != null || (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", attribute)) != null) {
            try {
                valueStr = n.getNodeValue().trim();
                Integer.parseInt(valueStr);
            }
            catch (Exception e) {
                throw new Exception("Invalid " + attribute + " value", e);
            }
            return valueStr;
        }
        return null;
    }

    private String parseOptionalNonNegativeInt(String attribute) throws Exception {
        String valueStr = null;
        Attr n = this.query.getAttributeNodeNS(null, attribute);
        if (n != null || (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", attribute)) != null) {
            try {
                valueStr = n.getNodeValue().trim();
                Integer value = Integer.parseInt(valueStr);
                if (value < 0) {
                    throw new Exception(attribute + " attribute must be non-negative");
                }
                return valueStr;
            }
            catch (Exception e) {
                throw new Exception("Invalid " + attribute + " value", e);
            }
        }
        return null;
    }

    public TimeQueryElement(Element query, Map<String, String> nsPrefixes, QueryElement el) {
        super(el);
        this.query = query;
        this.nsPrefixes = nsPrefixes;
    }

    @Override
    public void parse() throws Exception {
        for (String param : Arrays.asList(TimeConstants.startQname, TimeConstants.endQname)) {
            String paramName = this.nsPrefixes.get("http://a9.com/-/opensearch/extensions/time/1.0/") + param.substring(param.indexOf(":") + 1);
            Attr n = this.query.getAttributeNodeNS(null, paramName);
            if (n == null && (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", paramName)) == null) continue;
            try {
                if (param.compareTo(TimeConstants.startQname) == 0) {
                    this.start = URLDecoder.decode(n.getNodeValue(), "UTF-8");
                    continue;
                }
                if (param.compareTo(TimeConstants.endQname) != 0) continue;
                this.end = URLDecoder.decode(n.getNodeValue(), "UTF-8");
            }
            catch (Exception e) {
                throw new Exception("Error while processing query attribute", e);
            }
        }
        this.el.parse();
    }

    @Override
    public Map<String, String> getQueryParameters() throws Exception {
        Map<String, String> m = this.el.getQueryParameters();
        if (this.start != null) {
            m.put(TimeConstants.encodedTimeExtensionsNS + ":start", this.start);
        }
        if (this.end != null) {
            m.put(TimeConstants.encodedTimeExtensionsNS + ":end", this.end);
        }
        return m;
    }
}

