/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchlibrary.queryelements.extensions.sru;

import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gcube.opensearch.opensearchlibrary.SRUConstants;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElement;
import org.gcube.opensearch.opensearchlibrary.queryelements.QueryElementDecorator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SRUQueryElement
extends QueryElementDecorator {
    private Element query = null;
    private Map<String, String> nsPrefixes = null;
    protected String role = null;
    private Map<String, String> SRUParams = new HashMap<String, String>();

    private String parseOptionalString(String attribute) throws Exception {
        Attr n = this.query.getAttributeNodeNS(null, attribute);
        if (n != null || (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", attribute)) != null) {
            return n.getNodeValue();
        }
        return null;
    }

    private String parseInt(String attribute) throws Exception {
        String valueStr = null;
        Attr n = this.query.getAttributeNodeNS(null, attribute);
        if (n != null || (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", attribute)) != null) {
            try {
                valueStr = n.getNodeValue().trim();
                Integer.parseInt(valueStr);
            }
            catch (Exception e) {
                throw new Exception("Invalid " + attribute + " value", e);
            }
            return valueStr;
        }
        return null;
    }

    private String parseOptionalNonNegativeInt(String attribute) throws Exception {
        String valueStr = null;
        Attr n = this.query.getAttributeNodeNS(null, attribute);
        if (n != null || (n = this.query.getAttributeNodeNS("http://a9.com/-/spec/opensearch/1.1/", attribute)) != null) {
            try {
                valueStr = n.getNodeValue().trim();
                Integer value = Integer.parseInt(valueStr);
                if (value < 0) {
                    throw new Exception(attribute + " attribute must be non-negative");
                }
                return valueStr;
            }
            catch (Exception e) {
                throw new Exception("Invalid " + attribute + " value", e);
            }
        }
        return null;
    }

    public SRUQueryElement(Element query, Map<String, String> nsPrefixes, QueryElement el) {
        super(el);
        this.query = query;
        this.nsPrefixes = nsPrefixes;
    }

    @Override
    public void parse() throws Exception {
        String paramValue;
        String paramName;
        for (String param : Arrays.asList(SRUConstants.queryTypeQname, SRUConstants.queryQname, SRUConstants.recordPackingQname, SRUConstants.recordSchemaQname, SRUConstants.sortKeysQname, SRUConstants.stylesheetQname, SRUConstants.renderingQname, SRUConstants.httpAcceptQname, SRUConstants.httpAcceptCharsetQname, SRUConstants.httpAcceptCharsetQname, SRUConstants.httpAcceptEncodingQname, SRUConstants.httpAcceptLanguageQname, SRUConstants.httpAcceptRangesQname, SRUConstants.facetLimitQname, SRUConstants.facetSortQname, SRUConstants.facetRangeFieldQname, SRUConstants.facetLowValueQname, SRUConstants.facetHighValueQname, SRUConstants.facetCountQname)) {
            paramName = this.nsPrefixes.get("http://a9.com/-/opensearch/extensions/sru/2.0/") + param.substring(param.indexOf(":") + 1);
            paramValue = null;
            paramValue = this.parseOptionalString(paramName);
            if (param.equals(SRUConstants.sortKeysQname) || param.equals(SRUConstants.httpAcceptQname)) {
                paramValue = URLDecoder.decode(paramValue, "UTF-8");
            }
            if (paramValue == null) continue;
            this.SRUParams.put(param, paramValue);
        }
        for (String param : Arrays.asList(SRUConstants.startRecordQname, SRUConstants.maximumRecordsQname, SRUConstants.resultSetTTLQname)) {
            paramName = this.nsPrefixes.get("http://a9.com/-/opensearch/extensions/sru/2.0/") + param.substring(param.indexOf(":") + 1);
            paramValue = null;
            paramValue = this.parseOptionalNonNegativeInt(paramName);
            if (paramValue == null) continue;
            this.SRUParams.put(param, paramValue);
        }
        this.el.parse();
    }

    @Override
    public Map<String, String> getQueryParameters() throws Exception {
        Map<String, String> m = this.el.getQueryParameters();
        m.putAll(this.SRUParams);
        return m;
    }
}

