/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchoperator.record;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenSearchRecord
extends Record {
    private String uniqueIdentifier = "";

    public OpenSearchRecord(String payload) {
        this.setFields(new Field[]{new StringField(payload)});
    }

    public OpenSearchRecord(String payload, String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
        this.setFields(new Field[]{new StringField(payload)});
    }

    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public void setPayload(String payload) throws GRS2RecordDefinitionException, GRS2BufferException {
        this.getField("payload").setPayload(payload);
    }

    public String getPayload() throws GRS2RecordDefinitionException, GRS2BufferException {
        return this.getField("payload").getPayload();
    }

    public StringField getField(String name) throws GRS2RecordDefinitionException, GRS2BufferException {
        return (StringField)super.getField(name);
    }

    public void extendSend(DataOutput out) throws GRS2RecordSerializationException {
        this.extendDeflate(out);
    }

    public void extendReceive(DataInput in) throws GRS2RecordSerializationException {
        this.extendInflate(in, false);
    }

    public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.uniqueIdentifier);
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("Could not deflate record", (Throwable)e);
        }
    }

    public void extendInflate(DataInput in, boolean reset) throws GRS2RecordSerializationException {
        try {
            this.uniqueIdentifier = in.readUTF();
        }
        catch (IOException e) {
            throw new GRS2RecordSerializationException("Could not inflate record", (Throwable)e);
        }
    }

    public void extendDispose() {
        this.uniqueIdentifier = null;
    }

    protected void extendMakeLocal() {
    }

    public void extendSendToXML(Document doc, Element element) throws GRS2RecordSerializationException {
        Element elm = doc.createElement("uniqueIdentifier");
        elm.setTextContent(this.uniqueIdentifier);
        element.appendChild(elm);
    }

    public void extendReceiveFromXML(Element element) throws GRS2RecordSerializationException {
        this.uniqueIdentifier = element.getElementsByTagName("uniqueIdentifier").item(0).getTextContent();
    }
}

