/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.opensearch.opensearchoperator.resource;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import org.gcube.opensearch.opensearchoperator.resource.LocalOpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.OpenSearchResource;
import org.gcube.opensearch.opensearchoperator.resource.ResourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalResourceRepository
implements ResourceRepository {
    private Logger logger = LoggerFactory.getLogger((String)LocalResourceRepository.class.getName());
    private Map<String, File> fileResources = new HashMap<String, File>();
    private Map<String, String> URLResources = new HashMap<String, String>();
    private Map<String, OpenSearchResource> otherResources = new HashMap<String, OpenSearchResource>();
    private File schemaFile = null;

    public LocalResourceRepository(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    public void add(String dirPath) throws Exception {
        File dir = new File(dirPath);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        File[] resourceFiles = dir.listFiles(filter);
        if (resourceFiles == null) {
            throw new Exception("Error while listing directory files");
        }
        for (File res : resourceFiles) {
            LocalOpenSearchResource resource;
            try {
                resource = new LocalOpenSearchResource(res, this.schemaFile);
            }
            catch (Exception e) {
                this.logger.warn("Error while processing resource file " + res.getName() + ". Ignoring.", (Throwable)e);
                continue;
            }
            this.fileResources.put(resource.getDescriptionDocURL().toString(), res);
        }
    }

    public void addURL(String resourceURL) throws Exception {
        LocalOpenSearchResource resource = new LocalOpenSearchResource(resourceURL, this.schemaFile);
        this.URLResources.put(resource.getDescriptionDocURL(), resourceURL);
    }

    public void add(OpenSearchResource resource) {
        this.otherResources.put(resource.getDescriptionDocURL(), resource);
    }

    @Override
    public OpenSearchResource get(String descriptionDocURL) throws Exception {
        if (this.fileResources.containsKey(descriptionDocURL)) {
            return new LocalOpenSearchResource(this.fileResources.get(descriptionDocURL), this.schemaFile);
        }
        if (this.otherResources.containsKey(descriptionDocURL)) {
            return this.otherResources.get(descriptionDocURL);
        }
        if (this.URLResources.containsKey(descriptionDocURL)) {
            return new LocalOpenSearchResource(this.URLResources.get(descriptionDocURL), this.schemaFile);
        }
        return null;
    }
}

