package org.gcube.personalization.profileadministration.client.library.plugins;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.personalization.profileadministration.client.library.proxies.ProfileAdministrationCLDefaultProxy;
import org.gcube.personalization.profileadministration.client.library.proxies.ProfileAdministrationCLProxyI;
import org.gcube.personalization.profileadministration.client.library.stubs.ProfileAdministrationStub;
import org.gcube.personalization.profileadministration.client.library.utils.ProfileAdministrationCLConstants;

/**
 * ProfileAdministration Client Library plugin. Exposes information that allows CL Framework
 * components to act on behalf of ProfileAdministration CL.
 * 
 * @author Panagiota Koltsida, NKUA
 * 
 */
public class ProfileAdministrationCLPlugin implements Plugin<ProfileAdministrationStub, ProfileAdministrationCLProxyI> {

	/**
	 * Implementation of Plugin operations. With these callbacks the library
	 * describes Search to the framework.
	 */

	@Override
	public String name() {
		return ProfileAdministrationCLConstants.NAME;
	}

	@Override
	public String namespace() {
		return ProfileAdministrationCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return ProfileAdministrationCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return ProfileAdministrationCLConstants.gcubeName;
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public ProfileAdministrationStub resolve(EndpointReference reference,
			ProxyConfig<?, ?> proxyConfig) throws Exception {
		return StubFactory.stubFor(ProfileAdministrationCLConstants.perspr).at(reference);
	}

	@Override
	public ProfileAdministrationCLDefaultProxy newProxy(ProxyDelegate<ProfileAdministrationStub> delegate) {
		return new ProfileAdministrationCLDefaultProxy(delegate);
	}

}
