package profileAdministration;

import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.personalization.profileadministration.stubs.ProfileAdministrationPortType;
import org.gcube.personalization.profileadministration.stubs.service.ProfileAdministrationServiceAddressingLocator;

/**
* This is a client for testing the ProfileAdministration service
* It shows how to update the default profile, which is a generic resource
* It also shows how to create and delete a user profile
* 
* For more information about the usage of the ProfileAdministration service please visit the D4Science wiki site
* 
* @author Panagiota Koltsida, NKUA
*
*/
public class ProfileAdministrationClient {

	private static final String defaultprofile = "<userprofile><userinfo><username></username><fullname></fullname><email></email>" +
	"</userinfo><preferences><searchpreferences><EngineType>InternalEngine</EngineType><Persistence>false</Persistence>" +
	"<FaultTolerance>false</FaultTolerance></searchpreferences><moodleURL></moodleURL><language>En</language>" +
	"<langcolpairs></langcolpairs><xslts><metadataxslt></metadataxslt><presentationxslt></presentationxslt></xslts>" +
	"</preferences></userprofile>";

	/**
	 * @param args0 = GCUBEScope
	 * @param args1 = the URI of a RI of the ProfileAdministration service for the passed scope 
	 */
	public static void main(String[] args) {
		ProfileAdministrationServiceAddressingLocator pLocator = new ProfileAdministrationServiceAddressingLocator();
		EndpointReferenceType profileAdministrationEpr = new EndpointReferenceType();
		ProfileAdministrationPortType port = null;

		String serviceuri = args[1];

		System.out.println("START TESTING.....");
		try {
			profileAdministrationEpr.setAddress(new AttributedURI(serviceuri));
			port = pLocator.getProfileAdministrationPortTypePort(profileAdministrationEpr);
			port = GCUBERemotePortTypeContext.getProxy(port, GCUBEScope.getScope(args[0]));

			System.out.println("Start invoking the methods of the profileadministration service...");
			System.out.println("The 'setDefaultProfile' method will be invoked. This method sets (if it does not exist) or updates" +
					" the default UserProfile generic resource which is saved on IS. For testing reasons this profile is inside the client" +
			" so as not to produce any problems, but it can be updated with any valid xml");
			
			// invoke the 'setDefaultProfile' method
			port.setDefaultProfile(defaultprofile);

			System.out.println("The default profile was just created by invoking the setDefaultProfile Method. It is saved on IS as a generic resource");

			System.out.println("A new user profile will be created for a clientUser.");
			// invoke the 'createUserProfile' method
			port.createUserProfile("clientUser");
			System.out.println("The new user profile has been created. The profile is stored on CMS");
			System.out.println("Delete this user profile by invoking the 'dropUserProfile' method");
			// invoke the 'dropuserprofile' method
			port.dropUserProfile("clientUser");
			System.out.println("The profile has been deleted succesfully");
		} catch (Exception e) {
			System.out.println("An exception was thrown:  " + e.getMessage());
			e.printStackTrace();
		}
		System.out.println("TESTING FINISHED....................");
	}
}
