package org.gcube.personalization.userprofileaccess.client.library.proxies;

import org.gcube.personalization.userprofileaccess.client.library.beans.Types.GetElementResponse;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.SetElement;
import org.gcube.personalization.userprofileaccess.client.library.beans.Types.SetElementValue;
import org.gcube.personalization.userprofileaccess.client.library.exceptions.UserProfileAccessException;

/**
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public interface UserProfileAccessCLProxyI {

	public String getUserProfile() throws UserProfileAccessException;

	public String getElementValue(final String elementName) throws UserProfileAccessException;
	
	public void setElementValue(final SetElementValue params) throws UserProfileAccessException;
	
	public GetElementResponse getElement(final String elementName) throws UserProfileAccessException;
	
	public void setElement(final SetElement params) throws UserProfileAccessException;
	
	public void deleteElement(final String elementName) throws UserProfileAccessException;

	public void updateUserProfile(final String profileContent) throws UserProfileAccessException;

	public void destroy() throws UserProfileAccessException;

}
