/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.personalization.userprofileaccess.impl;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.namespace.QName;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.personalization.userprofileaccess.impl.UserProfileAccessResource;
import org.gcube.personalization.userprofileaccess.impl.UserProfileAccessService;
import org.gcube.personalization.userprofileaccess.impl.UserProfilesUpdateIUtils;

public class ServiceContext
extends GCUBEServiceContext {
    static GCUBELog logger = new GCUBELog(UserProfileAccessService.class);
    public static final String JNDI_NAME = "gcube/personalization/userprofileaccess";
    private static ServiceContext cache = new ServiceContext();

    public static ServiceContext getContext() {
        return cache;
    }

    private ServiceContext() {
    }

    public String getJNDIName() {
        return JNDI_NAME;
    }

    protected void onReady() {
        try {
            ISNotifier notifier = (ISNotifier)GHNContext.getImplementation(ISNotifier.class);
            ArrayList<ISNotifier.GCUBENotificationTopic> notTopics = new ArrayList<ISNotifier.GCUBENotificationTopic>();
            QName qName = new QName("http://gcube-system.org/namespaces/informationsystem/registry", "GenericResource");
            ISNotifier.GCUBENotificationTopic notificationTopic = new ISNotifier.GCUBENotificationTopic(qName);
            notificationTopic.setPrecondition("/Profile/Name[starts-with(.,'PresentationConfig-|-')]or/Profile/Name[starts-with(.,'MetadataXSLT-|-')]");
            notTopics.add(notificationTopic);
            for (GCUBEScope scope : ServiceContext.getContext().getInstance().getScopes().values()) {
                XSLTNotificationConsumer con = new XSLTNotificationConsumer(scope);
                notifier.registerToISNotification((ISNotifier.BaseNotificationConsumer)con, notTopics, (GCUBESecurityManager)ServiceContext.getContext(), new GCUBEScope[]{scope});
                logger.debug((Object)("Registered to IS notification for Generic resources with scope: " + scope));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not register to Generic resource topic.", (Throwable)e);
            e.printStackTrace();
            return;
        }
    }

    private class XSLTNotificationConsumer
    extends ISNotifier.BaseNotificationConsumer
    implements Runnable {
        private static final String createOperation = "create";
        private static final String updateOperation = "update";
        private static final String deleteOperation = "destroy";
        private GCUBEScope scope;
        private LinkedBlockingQueue<String> newResourcesList = new LinkedBlockingQueue();
        private LinkedBlockingQueue<String> deletedResourcesList = new LinkedBlockingQueue();
        Thread worker = new Thread(this);
        Object locker = new Object();
        private static final long sleepCon = 2700000L;

        public XSLTNotificationConsumer(GCUBEScope scope) {
            this.scope = scope;
            logger.debug((Object)("the worker thread will be started now. Working on resources for scope --> " + this.scope));
            this.worker.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNotificationReceived(ISNotifier.NotificationEvent event) {
            logger.debug((Object)"Notification is received...");
            String id = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
            String profile = null;
            logger.debug((Object)("notification is received for the generic resource with ID --> " + id + " in scope --> " + this.scope));
            String operation = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(2).getChildNodes().item(0).getNodeValue();
            logger.debug((Object)("Generic resource's operation --> " + operation));
            if (!operation.equals(deleteOperation)) {
                profile = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
                logger.debug((Object)("Generic resource's PROFILE -->  " + profile));
            }
            Object object = this.locker;
            synchronized (object) {
                if (operation.equals(createOperation) || operation.equals(updateOperation)) {
                    if (!this.newResourcesList.contains(id)) {
                        this.newResourcesList.offer(id);
                        logger.debug((Object)"resource added to the creation list");
                    } else {
                        logger.debug((Object)"resource already exists in the creation list and it was not added");
                    }
                } else if (operation.equals(deleteOperation)) {
                    if (this.newResourcesList.contains(id)) {
                        this.newResourcesList.remove(id);
                        logger.debug((Object)"resource removed from the creation list, since it is deleted before being examined");
                    }
                    if (!this.deletedResourcesList.contains(id)) {
                        this.deletedResourcesList.offer(id);
                        logger.debug((Object)"resource added to the deletion list");
                    } else {
                        logger.debug((Object)"resource already exists in the deletion list and it was not added");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        logger.debug((Object)("Start working on the list for deletions... (SCOPE --> " + this.scope + ")"));
                        Object object = this.locker;
                        synchronized (object) {
                            String id;
                            ArrayList<String> resourcesList;
                            ArrayList<UserProfileAccessResource> profilesResources = UserProfilesUpdateIUtils.getRIsProfilesIDs(this.scope);
                            if (this.deletedResourcesList.isEmpty()) {
                                logger.debug((Object)"Deletion list is empty.");
                            } else {
                                resourcesList = new ArrayList<String>();
                                while (!this.deletedResourcesList.isEmpty()) {
                                    id = this.deletedResourcesList.poll();
                                    logger.info((Object)("resource that was deleted is --> " + id));
                                    resourcesList.add(id);
                                }
                                try {
                                    UserProfilesUpdateIUtils.removeGRReferencesFromProfiles(profilesResources, resourcesList, this.scope);
                                }
                                catch (GCUBEFault e) {
                                    logger.error((Object)"An exception was thrown", (Throwable)e);
                                }
                            }
                            logger.debug((Object)("Start working on the list for new Generic Resources... (SCOPE --> " + this.scope + ")"));
                            if (this.newResourcesList.isEmpty()) {
                                logger.debug((Object)"List of new generic resources is empty.");
                            } else {
                                resourcesList = new ArrayList();
                                while (!this.newResourcesList.isEmpty()) {
                                    id = this.newResourcesList.poll();
                                    logger.info((Object)("Generic resource that was created is --> " + id));
                                    resourcesList.add(id);
                                }
                                try {
                                    UserProfilesUpdateIUtils.addNewXsltsToProfiles(profilesResources, resourcesList, this.scope);
                                }
                                catch (GCUBEFault e) {
                                    logger.error((Object)"An exception was thrown", (Throwable)e);
                                }
                            }
                        }
                        logger.debug((Object)"Going to sleep for 45 minutes....");
                        Thread.sleep(2700000L);
                    }
                }
                catch (InterruptedException e) {
                    logger.error((Object)"worker is interrupted");
                    continue;
                }
                break;
            }
        }
    }
}

