/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.personalization.userprofileaccess.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.contentmanager.stubs.CollectionReference;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.personalization.userprofileaccess.impl.CMSUtils;
import org.gcube.personalization.userprofileaccess.impl.ServiceContext;
import org.gcube.personalization.userprofileaccess.impl.StatefulContext;
import org.globus.wsrf.container.ServiceHost;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserProfileAccessFactoryService
extends GCUBEPortType {
    private static final String fPath = "gcube/personalization/userprofileaccess/UserProfileAccessFactory";
    private EndpointReferenceType sEpr = new EndpointReferenceType();
    private static GCUBELog logger = new GCUBELog(UserProfileAccessFactoryService.class);
    static ISClient client = null;
    private static final String UserProfileID = "UserProfileID";
    private static final String DefaultUserProfile = "DefaultUserProfile";
    protected static final String MetadataXSLT = "MetadataXSLT";
    private static final int metadataXSLTLength = 15;
    protected static final String userProfileCollectionName = "UserProfiles";
    private static final String userProfileCollectionDesc = "This collection is used to store the user profiles";

    public UserProfileAccessFactoryService() throws GCUBEFault {
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Exception e) {
            throw new GCUBERetrySameFault(new String[]{"Failes to call the IS client"});
        }
        String address = null;
        try {
            address = ServiceHost.getBaseURL().toString() + fPath;
            this.sEpr.setAddress((AttributedURI)new Address(address));
            logger.info((Object)("own EPR is: " + this.sEpr));
        }
        catch (Exception e1) {
            throw new GCUBERetrySameFault(new String[]{"Failes to get own service epr"});
        }
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    private String getProfileId(EndpointReferenceType epr) throws GCUBEFault {
        try {
            WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            gquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/../Source", epr.getAddress().toString()), new AtomicCondition("/../SourceKey", epr.getProperties().get_any()[0].getValue())});
            Iterator i$ = client.execute((ISQuery)gquery, ServiceContext.getContext().getScope()).iterator();
            if (i$.hasNext()) {
                RPDocument d = (RPDocument)i$.next();
                return (String)d.evaluate("//UserProfileID/text()").get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the requested property.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to get the requested property."});
        }
        return null;
    }

    private static List<String[]> retrieveGenericResourcesFromNameParts(String[] nameParts, GCUBEScope scope) throws Exception {
        if (nameParts.length == 0) {
            throw new Exception("At least one name part has to be specified");
        }
        String condition = "contains($result/Profile/Name/string(), '" + nameParts[0] + "')";
        for (int i = 1; i < nameParts.length; ++i) {
            condition = condition + " and contains($result/Profile/Name/string(), '" + nameParts[i] + "')";
        }
        GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
        query.addParameters(new QueryParameter[]{new QueryParameter("FILTER", condition), new QueryParameter("TYPE", "GenericResource"), new QueryParameter("RESULT", "<Result>{$result/ID}{$result/Profile/Name}</Result>")});
        List result = client.execute((ISQuery)query, scope);
        LinkedList<String[]> ret = new LinkedList<String[]>();
        if (result == null || result.size() == 0) {
            throw new Exception("No generic resources were found.");
        }
        for (XMLResult r : result) {
            String[] nameAndID = new String[]{(String)r.evaluate("//Name/text()").get(0), (String)r.evaluate("//ID/text()").get(0)};
            ret.add(nameAndID);
        }
        return ret;
    }

    private String[][] getDefaultXslts(String xsltType) throws GCUBEFault {
        String[][] pairs = null;
        try {
            String[] nameParts = new String[]{xsltType, "-|-default"};
            List<String[]> namesAndIDs = UserProfileAccessFactoryService.retrieveGenericResourcesFromNameParts(nameParts, ServiceContext.getContext().getScope());
            pairs = new String[namesAndIDs.size()][2];
            for (int i = 0; i < namesAndIDs.size(); ++i) {
                pairs[i][0] = namesAndIDs.get(i)[0];
                pairs[i][1] = namesAndIDs.get(i)[1];
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve the xslts", (Throwable)e);
            logger.debug((Object)"Default XLSTs do not exist on the IS. The new profile will not contain any XSLT");
            return null;
        }
        return pairs;
    }

    private String getDefaultProfile(String name) throws GCUBEFault {
        try {
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", name)});
            List result = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
            if (result == null || result.size() == 0) {
                throw new Exception("Generic resource not found.");
            }
            logger.debug((Object)("Default profile retrieved. The ID of the resource is --> " + ((GCUBEGenericResource)result.get(0)).getID()));
            return ((GCUBEGenericResource)result.get(0)).getBody();
        }
        catch (Exception e) {
            logger.error((Object)"Error while trying to retrieve the default user profile", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Error while trying to retrieve the default user profile"});
        }
    }

    static String getGenericResourceNameByID(String id, GCUBEScope scope) throws GCUBEFault {
        try {
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", id)});
            List result = client.execute((ISQuery)query, scope);
            if (result == null || result.size() == 0) {
                throw new Exception("Generic resource not found.");
            }
            return ((GCUBEGenericResource)result.get(0)).getName();
        }
        catch (Exception e) {
            logger.error((Object)("Error while trying to retrieve the name of the generic resource with ID: " + id), (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Error while trying to retrieve the name of the generic resource with ID: " + id});
        }
    }

    public EndpointReferenceType createResource(String username) throws GCUBEFault {
        logger.debug((Object)"Start creating the resource..................");
        String cmsId = null;
        EndpointReferenceType epr = null;
        GCUBEScope scope = ServiceContext.getContext().getScope();
        String docName = username + "_" + scope.getName();
        LinkedList<EndpointReferenceType> result = new LinkedList<EndpointReferenceType>();
        try {
            AtomicCondition cond = new AtomicCondition("/../SourceKey", username + "." + scope.getName());
            WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            gquery.addAtomicConditions(new AtomicCondition[]{cond});
            gquery.addGenericCondition("$result//Data/child::*[local-name()='ServiceName']/string() eq 'UserProfileAccess'");
            for (RPDocument d : client.execute((ISQuery)gquery, scope)) {
                result.add(d.getEndpoint());
            }
            if (result == null || result.size() == 0) {
                logger.info((Object)"There is no WS-Resource for the requested profile. A new WS-Resource will be created");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the WS-Resources", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to get the WS-Resources."});
        }
        if (result != null && result.size() > 0) {
            for (int j = 0; j < result.size(); ++j) {
                logger.debug((Object)("EPR --> " + result));
                if (!((EndpointReferenceType)result.get(j)).getAddress().toString().startsWith(this.sEpr.getAddress().toString().substring(0, this.sEpr.getAddress().toString().lastIndexOf(47)))) continue;
                epr = (EndpointReferenceType)result.get(j);
                break;
            }
            if (epr != null) {
                logger.info((Object)"There is already a ws-resource that had been created by the same RI of the UserProfileAccess. Return this rersource");
                return epr;
            }
            logger.info((Object)"Ws-resources exist for this user, but they hadn't been created by this RI. A new ws-Resource will be created");
            cmsId = this.getProfileId((EndpointReferenceType)result.get(0));
        }
        GCUBEWSResource wsResource = null;
        GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getPortTypeContext();
        if (cmsId == null) {
            DocumentWriter writer;
            DocumentReader reader;
            String collectionID = null;
            CollectionReference ref = null;
            String id = CMSUtils.getCollectionByName(userProfileCollectionName, scope);
            if (id == null) {
                ref = CMSUtils.createCollection(userProfileCollectionName, userProfileCollectionDesc, scope);
                try {
                    reader = CMSUtils.getDocumentReaderByCollectionReference(ref, scope);
                    writer = CMSUtils.getDocumentWriterByCollectionReference(ref, scope);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to instantiate reader and writer for the collection with ID: " + ref.getCollectionID()));
                    throw new GCUBEUnrecoverableFault(new String[]{"Failed to instantiate reader and writer for the collection with ID: " + ref.getCollectionID()});
                }
            }
            logger.info((Object)"A collection with name 'UserProfiles' already exists. The new profile will be associated with this collection");
            logger.info((Object)("The ID of the existing collection is: " + id));
            collectionID = id;
            try {
                reader = CMSUtils.getDocumentReaderByID(collectionID, scope);
                writer = CMSUtils.getDocumentWriterByID(collectionID, scope);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to instantiate reader and writer for the collection with ID: " + collectionID));
                throw new GCUBEUnrecoverableFault(new String[]{"Failed to instantiate reader and writer for the collection with ID: " + collectionID});
            }
            if (collectionID == null && ref == null) {
                logger.error((Object)"The collection ID is null. Either failed to retrieve the ID of the existing collection or to create a new one. An exception will be thrown");
                throw new GCUBEUnrecoverableFault(new String[]{"Failed to create or retrieve the collection. Cannot create a new user profile."});
            }
            cmsId = CMSUtils.findDocumentIDFromName(reader, docName, scope);
            if (cmsId == null) {
                logger.info((Object)("The returned id of the cms is null. Create a new user profile in cms for user --> " + username));
                String pr = this.getDefaultProfile(DefaultUserProfile);
                String[][] mPairs = this.getDefaultXslts(MetadataXSLT);
                try {
                    Document doc = CMSUtils.parseXMLFileToDOM(pr);
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    Element eUsername = (Element)xpath.evaluate("/userprofile/userinfo/username", doc, XPathConstants.NODE);
                    eUsername.setTextContent(username);
                    Element mXslts = (Element)xpath.evaluate("/userprofile/preferences/xslts/metadataxslt", doc, XPathConstants.NODE);
                    if (mPairs != null) {
                        logger.debug((Object)"Going to add the default metadata XSLTS in the profile...");
                        for (int j = 0; j < mPairs.length; ++j) {
                            Element xs = doc.createElement("xslt");
                            Element el = doc.createElement("name");
                            el.setTextContent(mPairs[j][0].substring(15, mPairs[j][0].length()));
                            Element el2 = doc.createElement("id");
                            el2.setTextContent(mPairs[j][1]);
                            xs.appendChild(el);
                            xs.appendChild(el2);
                            mXslts.appendChild(xs);
                            logger.debug((Object)("Metadata XSLT -> " + mPairs[j][0] + " - " + mPairs[j][1] + " added in the profile"));
                        }
                    }
                    pr = CMSUtils.createStringFromDomTree(doc);
                    cmsId = CMSUtils.createDocument(writer, docName, pr, scope);
                }
                catch (Exception e) {
                    logger.error((Object)("Error while trying to create user's profile in CMS. Throwing exception." + e.getMessage()), (Throwable)e);
                    throw new GCUBEUnrecoverableFault(new String[]{"Error while trying to create user's profile in CMS."});
                }
            }
        }
        try {
            wsResource = ptcxt.getWSHome().create(ptcxt.makeKey(username + "." + scope.getName()), new Object[]{username, cmsId});
            wsResource.store();
            epr = wsResource.getEPR();
        }
        catch (Exception e) {
            logger.error((Object)"An error occured while creating the resource. Throwing exception", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Error while creating the WS-Resource ."});
        }
        logger.info((Object)("Profile stored in cms with ID: '" + cmsId + "' for the user: " + username));
        return epr;
    }
}

