/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.personalization.userprofileaccess.impl;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentReader;
import org.gcube.contentmanagement.gcubedocumentlibrary.io.DocumentWriter;
import org.gcube.personalization.userprofileaccess.impl.CMSUtils;
import org.gcube.personalization.userprofileaccess.impl.StatefulContext;
import org.gcube.personalization.userprofileaccess.impl.UserProfileAccessResource;
import org.gcube.personalization.userprofileaccess.impl.UserProfileAccessService;
import org.globus.wsrf.ResourceKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UserProfilesUpdateIUtils {
    static GCUBELog logger = new GCUBELog(UserProfileAccessService.class);
    private static final String delChars = "-|-";

    protected static ArrayList<UserProfileAccessResource> getRIsProfilesIDs(GCUBEScope scope) {
        logger.debug((Object)("Find the ws-resources of the current RI..... for scope --> " + scope));
        ArrayList<UserProfileAccessResource> userProfilesResources = new ArrayList<UserProfileAccessResource>();
        Collection wsIDs = StatefulContext.getPortTypeContext().getWSHome().getIdentifiers();
        logger.debug((Object)("The length of the wsIDs is --> " + wsIDs.size()));
        for (GCUBEWSResourceKey key : wsIDs) {
            try {
                GCUBEWSResource resource = StatefulContext.getPortTypeContext().getWSHome().find((ResourceKey)key);
                userProfilesResources.add((UserProfileAccessResource)resource);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to get the ws-resources. " + e.getMessage()), (Throwable)e);
            }
        }
        return userProfilesResources;
    }

    protected static void removeGRReferencesFromProfiles(ArrayList<UserProfileAccessResource> profilesResources, ArrayList<String> genericResourcesIDs, GCUBEScope scope) throws GCUBEFault {
        if (profilesResources != null && !profilesResources.isEmpty()) {
            logger.debug((Object)"For each user profile ID check if any of the generic resources  should be removed from user's profile....");
            for (UserProfileAccessResource profileResource : profilesResources) {
                String userProfileID = profileResource.getUserProfileID();
                try {
                    String collectionID = CMSUtils.getCollectionByName("UserProfiles", scope);
                    DocumentReader reader = CMSUtils.getDocumentReaderByID(collectionID, scope);
                    String profileContent = CMSUtils.getDocument(reader, userProfileID, scope);
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(new InputSource(new StringReader(profileContent)));
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    for (String grID : genericResourcesIDs) {
                        try {
                            NodeList nodesToBeDeleted = (NodeList)xpath.evaluate("/userprofile/preferences/xslts//xslt[id='" + grID + "']", doc, XPathConstants.NODESET);
                            for (int i = 0; i < nodesToBeDeleted.getLength(); ++i) {
                                Node node = nodesToBeDeleted.item(i);
                                Node parentNode = node.getParentNode();
                                if (parentNode == null) continue;
                                parentNode.removeChild(node);
                            }
                        }
                        catch (Exception e) {
                            logger.debug((Object)"Element not found in profile and won't be deleted", (Throwable)e);
                        }
                    }
                    String newProfileContent = CMSUtils.createStringFromDomTree(doc);
                    try {
                        DocumentWriter writer = CMSUtils.getDocumentWriterByID(collectionID, scope);
                        CMSUtils.updateDocument(writer, userProfileID, newProfileContent, scope);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to update the profile with ID --> " + userProfileID + "  without the deleted elements."), (Throwable)e);
                        throw new GCUBERetrySameFault(new String[]{"Failed to update the profile, without the deleted elements."});
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to get the profile with ID --> " + userProfileID), (Throwable)e);
                }
            }
        }
    }

    protected static void addNewXsltsToProfiles(ArrayList<UserProfileAccessResource> profilesResources, ArrayList<String> genericResourcesIDs, GCUBEScope scope) throws GCUBEFault {
        if (profilesResources != null && !profilesResources.isEmpty()) {
            for (UserProfileAccessResource profileResource : profilesResources) {
                Boolean hasChanged = false;
                String userProfileID = profileResource.getUserProfileID();
                logger.debug((Object)("Checking profile with ID --> " + userProfileID));
                try {
                    String collectionID = CMSUtils.getCollectionByName("UserProfiles", scope);
                    DocumentReader reader = CMSUtils.getDocumentReaderByID(collectionID, scope);
                    String profileContent = CMSUtils.getDocument(reader, userProfileID, scope);
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(new InputSource(new StringReader(profileContent)));
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    List wsResourcesScopes = profileResource.getResourcePropertySet().getScope();
                    for (String grID : genericResourcesIDs) {
                        try {
                            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)UserProfileAccessService.client.getQuery(GCUBEGenericResourceQuery.class);
                            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", grID)});
                            List result = UserProfileAccessService.client.execute((ISQuery)query, scope);
                            if (result == null || result.size() == 0) {
                                throw new Exception("Generic resource not found.");
                            }
                            Boolean hasCommonScope = false;
                            Map GRscopes = ((GCUBEGenericResource)result.get(0)).getScopes();
                            for (String wsScope : wsResourcesScopes) {
                                if (!GRscopes.containsKey(wsScope)) continue;
                                hasCommonScope = true;
                                logger.debug((Object)"Ws resource and generic resource have a common scope");
                                break;
                            }
                            if (hasCommonScope.booleanValue()) {
                                String resourceName = ((GCUBEGenericResource)result.get(0)).getName();
                                logger.debug((Object)("Working on the GR with ID --> " + grID + " and name --> " + resourceName));
                                String[] nameParts = resourceName.split("-\\|-");
                                if (nameParts.length <= 0 || !nameParts[0].equals("MetadataXSLT")) continue;
                                NodeList nodes = null;
                                try {
                                    nodes = (NodeList)xpath.evaluate("/userprofile/preferences/xslts/metadataxslt/xslt[name[starts-with(.,'" + nameParts[1] + "')]]", doc, XPathConstants.NODESET);
                                }
                                catch (Exception e) {
                                    logger.error((Object)"Failed to evaluate the expression.");
                                }
                                if (nodes != null && nodes.getLength() > 0) {
                                    logger.debug((Object)"A metadata xslt already exists for that schema. Not adding anything");
                                    continue;
                                }
                                logger.debug((Object)"This metadata XSLT refers to a new schema that does not exist in user's profile. It will be added");
                                Element mXslts = (Element)xpath.evaluate("/userprofile/preferences/xslts/metadataxslt", doc, XPathConstants.NODE);
                                Element xs = doc.createElement("xslt");
                                Element el = doc.createElement("name");
                                el.setTextContent(nameParts[1] + delChars + nameParts[2]);
                                Element el2 = doc.createElement("id");
                                el2.setTextContent(grID);
                                xs.appendChild(el);
                                xs.appendChild(el2);
                                mXslts.appendChild(xs);
                                hasChanged = true;
                                continue;
                            }
                            logger.debug((Object)"The ws resource and the GR don't have a common scope. This resource won't be examined");
                        }
                        catch (Exception e) {
                            logger.error((Object)("Error while trying to retrieve the generic resource with ID: " + grID), (Throwable)e);
                        }
                    }
                    if (!hasChanged.booleanValue()) continue;
                    String newProfileContent = CMSUtils.createStringFromDomTree(doc);
                    try {
                        DocumentWriter writer = CMSUtils.getDocumentWriterByID(collectionID, scope);
                        CMSUtils.updateDocument(writer, userProfileID, newProfileContent, scope);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to update the profile, with the new elements.", (Throwable)e);
                        throw new GCUBERetrySameFault(new String[]{"Failed to update the profile with the new elements"});
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to get the profile with ID --> " + (Object)((Object)profileResource)), (Throwable)e);
                }
            }
        }
    }
}

