/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.personalization.userprofileaccess.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetrySameFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableFault;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.personalization.userprofileaccess.impl.SMSUtils;
import org.gcube.personalization.userprofileaccess.impl.ServiceContext;
import org.gcube.personalization.userprofileaccess.impl.StatefulContext;
import org.globus.wsrf.container.ServiceHost;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserProfileAccessFactoryService
extends GCUBEPortType {
    private static final String fPath = "gcube/personalization/userprofileaccess/UserProfileAccessFactory";
    private EndpointReferenceType sEpr = new EndpointReferenceType();
    private static GCUBELog logger = new GCUBELog(UserProfileAccessFactoryService.class);
    static ISClient client = null;
    private static final String UserProfileID = "UserProfileID";
    private static final String DefaultUserProfile = "DefaultUserProfile";

    public UserProfileAccessFactoryService() throws GCUBEFault {
        try {
            client = (ISClient)GHNContext.getImplementation(ISClient.class);
        }
        catch (Exception e) {
            throw new GCUBERetrySameFault(new String[]{"Failes to call the IS client"});
        }
        String address = null;
        try {
            address = ServiceHost.getBaseURL().toString() + fPath;
            this.sEpr.setAddress((AttributedURI)new Address(address));
            logger.info((Object)("own EPR is: " + this.sEpr));
        }
        catch (Exception e1) {
            throw new GCUBERetrySameFault(new String[]{"Failes to get own service epr"});
        }
    }

    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    private String getProfileId(EndpointReferenceType epr) throws GCUBEFault {
        try {
            WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            gquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/../Source", epr.getAddress().toString()), new AtomicCondition("/../SourceKey", epr.getProperties().get_any()[0].getValue())});
            Iterator i$ = client.execute((ISQuery)gquery, ServiceContext.getContext().getScope()).iterator();
            if (i$.hasNext()) {
                RPDocument d = (RPDocument)i$.next();
                return (String)d.evaluate("//UserProfileID/text()").get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the requested property.", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to get the requested property."});
        }
        return null;
    }

    private String getDefaultProfile(String name) throws GCUBEFault {
        try {
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", name)});
            List result = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
            if (result == null || result.size() == 0) {
                throw new Exception("Generic resource not found.");
            }
            logger.debug((Object)("Default profile retrieved. The ID of the resource is --> " + ((GCUBEGenericResource)result.get(0)).getID()));
            return ((GCUBEGenericResource)result.get(0)).getBody();
        }
        catch (Exception e) {
            logger.error((Object)"Error while trying to retrieve the default user profile", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Error while trying to retrieve the default user profile"});
        }
    }

    static String getGenericResourceNameByID(String id, GCUBEScope scope) throws GCUBEFault {
        try {
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/ID", id)});
            List result = client.execute((ISQuery)query, scope);
            if (result == null || result.size() == 0) {
                throw new Exception("Generic resource not found.");
            }
            return ((GCUBEGenericResource)result.get(0)).getName();
        }
        catch (Exception e) {
            logger.error((Object)("Error while trying to retrieve the name of the generic resource with ID: " + id), (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Error while trying to retrieve the name of the generic resource with ID: " + id});
        }
    }

    public EndpointReferenceType createResource(String username) throws GCUBEFault {
        logger.debug((Object)"Start creating the resource..................");
        String ID = null;
        EndpointReferenceType epr = null;
        String scope = ScopeProvider.instance.get();
        ScopeBean scopeBean = new ScopeBean(scope);
        String scopeName = scopeBean.name();
        String docName = username + "_" + scopeName;
        LinkedList<EndpointReferenceType> result = new LinkedList<EndpointReferenceType>();
        try {
            AtomicCondition cond = new AtomicCondition("/../SourceKey", username + "." + scopeName);
            WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            gquery.addAtomicConditions(new AtomicCondition[]{cond});
            gquery.addGenericCondition("$result//Data/child::*[local-name()='ServiceName']/string() eq 'UserProfileAccess'");
            for (RPDocument d : client.execute((ISQuery)gquery, ServiceContext.getContext().getScope())) {
                result.add(d.getEndpoint());
            }
            if (result == null || result.size() == 0) {
                logger.info((Object)"There is no WS-Resource for the requested profile. A new WS-Resource will be created");
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the WS-Resources", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Failed to get the WS-Resources."});
        }
        if (result != null && result.size() > 0) {
            for (int j = 0; j < result.size(); ++j) {
                logger.debug((Object)("EPR --> " + result));
                if (!((EndpointReferenceType)result.get(j)).getAddress().toString().startsWith(this.sEpr.getAddress().toString().substring(0, this.sEpr.getAddress().toString().lastIndexOf(47)))) continue;
                epr = (EndpointReferenceType)result.get(j);
                break;
            }
            if (epr != null) {
                logger.info((Object)"There is already a ws-resource that had been created by the same RI of the UserProfileAccess. Return this rersource");
                return epr;
            }
            logger.info((Object)"Ws-resources exist for this user, but they hadn't been created by this RI. A new ws-Resource will be created");
            ID = this.getProfileId((EndpointReferenceType)result.get(0));
            logger.info((Object)("The ID to be assigned to the new ws-resource is -> " + ID));
        }
        GCUBEWSResource wsResource = null;
        GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getPortTypeContext();
        if (ID == null) {
            logger.info((Object)("The returned id of the cms is null. Create a new user profile in cms for user --> " + username));
            String pr = this.getDefaultProfile(DefaultUserProfile);
            try {
                Document doc = SMSUtils.parseXMLFileToDOM(pr);
                XPath xpath = XPathFactory.newInstance().newXPath();
                Element eUsername = (Element)xpath.evaluate("/userprofile/userinfo/username", doc, XPathConstants.NODE);
                eUsername.setTextContent(username);
                pr = SMSUtils.createStringFromDomTree(doc);
                ID = SMSUtils.createDocument(docName, pr);
            }
            catch (Exception e) {
                logger.error((Object)("Error while trying to create user's profile in CMS. Throwing exception." + e.getMessage()), (Throwable)e);
                throw new GCUBEUnrecoverableFault(new String[]{"Error while trying to create user's profile in CMS."});
            }
        }
        try {
            wsResource = ptcxt.getWSHome().create(ptcxt.makeKey(username + "_" + scopeName), new Object[]{username, ID});
            wsResource.store();
            epr = wsResource.getEPR();
        }
        catch (Exception e) {
            logger.error((Object)"An error occured while creating the resource. Throwing exception", (Throwable)e);
            throw new GCUBEUnrecoverableFault(new String[]{"Error while creating the WS-Resource ."});
        }
        logger.info((Object)("Profile stored in SMS with ID: '" + ID + "' for the user: " + username));
        return epr;
    }
}

