package org.gcube.personalization.userprofileaccess.impl;

import org.gcube.common.core.state.GCUBEWSResource;
import org.globus.wsrf.ResourceException;

/**
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class UserProfileAccessResource extends GCUBEWSResource{

	 /**
	  * Resource Property 'Username'
	  */
	 protected static final String RP_USERNAME = "Username";
	 protected static final String RP_USERID = "UserProfileID";
	 /**
	  * Respource Property 'UserProfileID'
	  */
	 protected static String[] RPNames = { RP_USERNAME, RP_USERID };

	
	@Override
	protected void initialise(Object... args) throws ResourceException {
		if (args.length != 2) throw new IllegalArgumentException();
		
		try {
			this.setUsername((String) args[0]);
			this.setUserProfileID((String) args[1]);
		}
		catch (Exception e) {
			throw new ResourceException(e);
		}
		
	}
	
	/**
     * {@inheritDoc}
     */
    public String[] getPropertyNames() {
    	return RPNames;
    }


	/**
	 * 
	 * @return The UserProfileID resource property
	 */
	public String getUserProfileID() {
		return (String) this.getResourcePropertySet().get(RP_USERID).get(0);
	}

	/**
	 * Sets the UserProfileID resource property
	 * 
	 * @param id The ID
	 */
	protected synchronized void setUserProfileID(String id) {
		this.getResourcePropertySet().get(RP_USERID).clear();
		this.getResourcePropertySet().get(RP_USERID).add(id);
	}

	/**
	 * 
	 * @return The username resource property
	 */
	public String getUsername() {
		return (String) this.getResourcePropertySet().get(RP_USERNAME).get(0);
	}

	/**
	 * Sets the username resource property
	 * 
	 * @param username The username to be set
	 */
	protected synchronized void setUsername(String username) {
		this.getResourcePropertySet().get(RP_USERNAME).clear();
		this.getResourcePropertySet().get(RP_USERNAME).add(username);

	}

}
