/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.searchtester.plugin;

import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.tools.sam.reports.BaseReport;
import org.gcube.tools.sam.reports.XMLReport;
import org.gcube.tools.searchtester.plugin.PluginContext;
import org.gcube.tools.searchtester.plugin.tests.BaseTest;
import org.gcube.vremanagement.executor.state.TaskRuntime;

public class SearchTesterWorker
extends GCUBEHandler<TaskRuntime> {
    BaseTest test = null;
    boolean isSchedulded = false;

    SearchTesterWorker(boolean isScheduled) {
        this.isSchedulded = isScheduled;
    }

    public void run() throws Exception {
        for (String vre : PluginContext.getVres()) {
            TaskRuntime r = (TaskRuntime)this.getHandled();
            try {
                this.logger.debug((Object)("Running on vre " + vre));
                BaseReport report = new BaseReport(vre);
                for (Class<? extends BaseTest> t : PluginContext.getTests()) {
                    this.logger.debug((Object)("Running test " + t));
                    this.test = t.newInstance();
                    this.test.setVre(vre);
                    this.test.test();
                    for (XMLReport re : this.test.getReports()) {
                        re.store();
                    }
                    report.addReports(this.test.getReports());
                }
                this.logger.debug((Object)report.generateReportFile());
                r.addOutput("report", (Object)report.generateReportFile());
                if (this.isSchedulded) continue;
                PluginContext.cleanInput();
                this.setState((State)State.Done.INSTANCE);
            }
            catch (Exception e) {
                e.printStackTrace();
                r.throwException(e);
                this.setState((State)State.Failed.INSTANCE);
                throw new Exception("Failed to Run the Search Tester", e);
            }
        }
    }
}

