/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.searchtester.plugin.tests;

import java.util.ArrayList;
import org.gcube.tools.sam.reports.XMLReport;
import org.gcube.tools.sam.reports.search.QuickSearchReport;
import org.gcube.tools.searchtester.plugin.ASLHTTPRequest;
import org.gcube.tools.searchtester.plugin.ParamMap;
import org.gcube.tools.searchtester.plugin.PluginContext;
import org.gcube.tools.searchtester.plugin.tests.BaseTest;
import org.gcube.tools.searchtester.plugin.tests.TestResult;
import org.gcube.tools.searchtester.plugin.util.Util;

public class QuickSearchTest
extends BaseTest {
    public QuickSearchTest() {
        this.reports = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void test() {
        QuickSearchReport report = null;
        try {
            report = new QuickSearchReport();
            ParamMap parameters = new ParamMap();
            parameters.addParameter("scope", this.vre);
            parameters.addParameter("searchType", "quick");
            report.setVre(this.vre);
            String term = Util.getRandomTermFromRandomCollection(PluginContext.collectionsMap.get(this.vre));
            report.setTerm(term);
            parameters.addParameter("searchTerms", term);
            if (term.equals("")) {
                report.setResult(XMLReport.STATUS_ABORTED);
                report.setError("ERROR: null term selected");
                return;
            }
            this.logger.debug((Object)("Executing Quick Search Query with term :" + term));
            this.req = new ASLHTTPRequest("SearchResults", parameters);
            TestResult results = this.req.makeRequest();
            report.setResult(Util.checkResults(results.getResult()));
            report.setError(results.getError());
            report.setExecutionTime(results.getExecutionTime());
        }
        catch (Exception e) {
            e.printStackTrace();
            report.setError(e.toString());
            report.setResult(XMLReport.STATUS_EXCEPTION);
            report.setExecutionTime(XMLReport.NOT_EXECUTED);
        }
        finally {
            this.reports.add(report);
        }
    }
}

