/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.event.publisher.lr62.model;

import com.liferay.portal.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import org.gcube.event.publisher.Event;
import org.gcube.portal.event.publisher.lr62.model.AbstractEventPublisherBaseModelListener;
import org.gcube.portal.event.publisher.lr62.model.UserEvent;

public class UserEventPublisher
extends AbstractEventPublisherBaseModelListener<User> {
    protected static final Log log = LogFactoryUtil.getLog(UserEventPublisher.class);

    public UserEventPublisher() {
        log.info((Object)"New UserEventPublisher instance created");
    }

    public void onAfterCreate(User user) throws ModelListenerException {
        log.info((Object)"New user created");
        UserEvent userEvent = UserEvent.newCreatedEvent((User)user);
        if (log.isTraceEnabled()) {
            log.trace((Object)("User event is: " + userEvent));
        }
        this.publish((Event)userEvent);
    }

    public void onBeforeRemove(User user) throws ModelListenerException {
        log.info((Object)"User removed");
        UserEvent userEvent = UserEvent.newDeletedEvent((User)user);
        if (log.isTraceEnabled()) {
            log.trace((Object)("User event is: " + userEvent));
        }
        this.publish((Event)userEvent);
    }

    public void onAfterAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        if (Group.class.getName().equals(associationClassName)) {
            log.debug((Object)"User has been associated to a group");
            User user = this.getUser((Long)classPK);
            Group group = this.getGroup((Long)associationClassPK);
            if (user != null && group != null) {
                if (group.isSite() && group.isActive()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Target group is a site: " + group.getName()));
                    }
                    UserEvent userEvent = UserEvent.newCreatedEvent((User)user, (Group)group);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("User event is: " + userEvent));
                    }
                    this.publish((Event)userEvent);
                } else if (log.isDebugEnabled() && !group.isSite()) {
                    log.debug((Object)"Target Group is a non-site group");
                } else if (log.isDebugEnabled() && group.isSite() && !group.isActive()) {
                    log.debug((Object)"Target group is disabled");
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Uninteresting association with: " + associationClassName));
        }
    }

    public void onBeforeRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
        if (Group.class.getName().equals(associationClassName)) {
            log.debug((Object)"User has been associated to a group");
            User user = this.getUser((Long)classPK);
            Group group = this.getGroup((Long)associationClassPK);
            if (user != null && group != null) {
                if (group.isSite() && group.isActive()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Target group is a site: " + group.getName()));
                    }
                    UserEvent userEvent = UserEvent.newDeletedEvent((User)user, (Group)group);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("User event is: " + userEvent));
                    }
                    this.publish((Event)userEvent);
                } else if (log.isDebugEnabled() && !group.isSite()) {
                    log.debug((Object)"Target group is a non-site group");
                } else if (log.isDebugEnabled() && group.isSite() && !group.isActive()) {
                    log.debug((Object)"Target group is disabled");
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Uninteresting association removal with: " + associationClassName));
        }
    }

    protected User getUser(Long userPK) {
        User user = null;
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Getting user object idetified by pk: " + userPK));
            }
            user = UserLocalServiceUtil.getUser((long)userPK);
        }
        catch (PortalException | SystemException e) {
            logger.error("Cannot get user with pk: " + userPK, e);
        }
        return user;
    }

    protected Group getGroup(Long groupPK) {
        Group group = null;
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Getting group object idetified by pk: " + groupPK));
            }
            group = GroupLocalServiceUtil.getGroup((long)groupPK);
        }
        catch (PortalException | SystemException e) {
            logger.error("Cannot get group with pk: " + groupPK, e);
        }
        return group;
    }

    public void onAfterRemove(User user) throws ModelListenerException {
    }

    public void onAfterRemoveAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
    }

    public void onAfterUpdate(User user) throws ModelListenerException {
    }

    public void onBeforeAddAssociation(Object classPK, String associationClassName, Object associationClassPK) throws ModelListenerException {
    }

    public void onBeforeCreate(User user) throws ModelListenerException {
    }

    public void onBeforeUpdate(User user) throws ModelListenerException {
    }
}

