/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.removeaccount.thread;

import org.gcube.portal.removeaccount.thread.RemoveUserFromJCR;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemovedUserAccountThread
implements Runnable {
    private static final Logger _log = LoggerFactory.getLogger(RemovedUserAccountThread.class);
    final String SUBJECT = "Removed account notification";
    private String userName;
    private GroupManager gm;
    private UserManager uMan;

    public RemovedUserAccountThread(long userId, String userName) {
        this.userName = userName;
        this.uMan = new LiferayUserManager();
        this.gm = new LiferayGroupManager();
    }

    @Override
    public void run() {
        try {
            _log.info("Trying to remove user " + this.userName + " from JCR first, using storageHub with role: " + "Infrastructure-Manager");
            RemoveUserFromJCR rmJCR = new RemoveUserFromJCR(this.userName, this.gm, this.uMan);
            boolean result = rmJCR.remove();
            _log.info("The user " + this.userName + " has been removed from JCR with success? " + result);
        }
        catch (Exception e) {
            _log.error("An error occurred during user workspace removal: ", (Throwable)e);
        }
    }
}

