/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.removeaccount.thread;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class RemovedUserFromLDAPThread
implements Runnable {
    private static Log _log = LogFactoryUtil.getLog(RemovedUserFromLDAPThread.class);
    private static final String LDAP_SERVER_NAME = "LDAPServer";
    private static final String LDAP_SERVER_PRINCPAL_NAME = "ldapPrincipal";
    private static final String USER_CONTEXT = ",ou=People,o=D4Science,ou=Organizations,dc=d4science,dc=org";
    private String portalName;
    private String ldapUrl;
    private String principal;
    private String ldapPassword;
    private String username2Delete;

    public RemovedUserFromLDAPThread(String username2Delete) {
        this.username2Delete = username2Delete;
    }

    @Override
    public void run() {
        this.portalName = PortalContext.getPortalInstanceName();
        PortalContext context = PortalContext.getConfiguration();
        String scope = "/" + context.getInfrastructureName();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
        query.addCondition("$resource/Profile/Name/text() eq '" + this.portalName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List list = client.submit((Query)query);
        if (list == null || list.isEmpty()) {
            _log.error((Object)("Could not find any Service endpoint registred in the infrastructure for this portal: " + this.portalName));
        } else if (list.size() > 1) {
            _log.warn((Object)("Found more than one Service endpoint registred in the infrastructure for this portal: " + this.portalName));
        } else {
            for (ServiceEndpoint res : list) {
                Group apGroup = res.profile().accessPoints();
                ServiceEndpoint.AccessPoint[] accessPoints = (ServiceEndpoint.AccessPoint[])apGroup.toArray((Object[])new ServiceEndpoint.AccessPoint[apGroup.size()]);
                for (int i = 0; i < accessPoints.length; ++i) {
                    if (accessPoints[i].name().compareTo(LDAP_SERVER_NAME) != 0) continue;
                    _log.info((Object)"Found credentials for LDAPServer");
                    ServiceEndpoint.AccessPoint found = accessPoints[i];
                    this.ldapUrl = found.address();
                    String encrPassword = found.password();
                    try {
                        this.ldapPassword = StringEncrypter.getEncrypter().decrypt(encrPassword);
                    }
                    catch (Exception e) {
                        _log.error((Object)"Something went wrong while decrypting password for LDAPServer");
                        e.printStackTrace();
                    }
                    Group propGroup = found.properties();
                    ServiceEndpoint.Property[] props = (ServiceEndpoint.Property[])propGroup.toArray((Object[])new ServiceEndpoint.Property[propGroup.size()]);
                    for (int j = 0; j < props.length; ++j) {
                        if (props[j].name().compareTo(LDAP_SERVER_PRINCPAL_NAME) != 0) continue;
                        _log.info((Object)"\tFound properties of ldapPrincipal");
                        String encrValue = props[j].value();
                        try {
                            this.principal = StringEncrypter.getEncrypter().decrypt(encrValue);
                            continue;
                        }
                        catch (Exception e) {
                            _log.error((Object)"Something went wrong while decrypting value for ldapPrincipal");
                            e.printStackTrace();
                        }
                    }
                }
            }
            _log.debug((Object)"Got LDAP connection info from IS Resource ...");
            _log.debug((Object)"Initializing LDAP connection ...");
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.ldapUrl);
            env.put("java.naming.security.principal", this.principal);
            env.put("java.naming.security.credentials", this.ldapPassword);
            try {
                InitialContext ctx = new InitialContext(env);
                String userCtx2Delete = this.getSubContext(this.username2Delete);
                _log.debug((Object)("***** trying delete userCtx=" + userCtx2Delete));
                ctx.unbind(userCtx2Delete);
                Object obj = null;
                try {
                    obj = ctx.lookup(userCtx2Delete);
                }
                catch (NameNotFoundException ne) {
                    _log.info((Object)("unbind successful for " + userCtx2Delete));
                    return;
                }
                _log.error((Object)("unbind failed; object still there: " + obj));
                ctx.close();
            }
            catch (NamingException e) {
                _log.error((Object)"Something went Wrong during LDAP remove user");
                e.printStackTrace();
            }
            catch (Exception es) {
                _log.error((Object)"Something went Wrong during LDAP remove user in retrieving Liferay Organization");
                es.printStackTrace();
            }
        }
    }

    private String getSubContext(String username) {
        return "uid=" + username + USER_CONTEXT;
    }
}

