package org.gcube.portal.usersaccount;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.portal.oidc.lr62.OIDCUmaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceCreateAccountThread implements Runnable {

    private static Logger _log = LoggerFactory.getLogger(WorkspaceCreateAccountThread.class);

    private String newUserUserName;

    public WorkspaceCreateAccountThread(String newUserUserName, String newUserFullName, String newUserEmailAddress) {
        super();
        this.newUserUserName = newUserUserName;
        _log.info("Calling SHUB for Workspace creation to new user: " + newUserUserName + " (" + newUserFullName + ")");
    }

    @Override
    public void run() {
        String context = "/" + PortalContext.getConfiguration().getInfrastructureName();
        String authorizationToken = PortalContext.getConfiguration().getCurrentUserToken(context, newUserUserName);
        SecurityTokenProvider.instance.set(authorizationToken);
        ScopeProvider.instance.set(context);
        OIDCUmaUtil.provideConfiguredPortalClientUMATokenInThreadLocal(context);
        try {
            StorageHubClient shc = new StorageHubClient();
            shc.createUserAccount(newUserUserName);
            _log.info("Done Workspace creation for user: " + newUserUserName);
        } catch (Exception e) {
            _log.error("Creating new account on the storage HUB", e);
        }
    }
}
