/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oauth;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import net.spy.memcached.MemcachedClient;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.ClientType;
import org.gcube.portal.oauth.CredentialsBean;
import org.gcube.portal.oauth.DistributedCacheClient;
import org.gcube.portal.oauth.cache.MemCachedBean;
import org.gcube.portal.oauth.output.AccessTokenBeanResponse;
import org.gcube.portal.oauth.output.AccessTokenErrorResponse;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v2")
@Singleton
public class OauthService {
    public static final String OAUTH_TOKEN_GET_METHOD_NAME_REQUEST = "access-token";
    private static final String GRANT_TYPE_VALUE = "authorization_code";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final Logger logger = LoggerFactory.getLogger(OauthService.class);

    public OauthService() {
        logger.info("Singleton gcube-oauth service built.");
    }

    private boolean checkIsapplicationTokenType(ClientType clientType) {
        return clientType.equals((Object)ClientType.EXTERNALSERVICE);
    }

    @GET
    @Path(value="check")
    @Produces(value={"text/plain"})
    public Response checkService() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Ready!").build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Path(value="access-token")
    public Response tokenRequest(@FormParam(value="client_id") String clientId, @FormParam(value="client_secret") String clientSecret, @FormParam(value="redirect_uri") String redirectUri, @FormParam(value="code") String code, @FormParam(value="grant_type") String grantType, @Context HttpServletRequest request) {
        Response.Status status = Response.Status.BAD_REQUEST;
        logger.info("Request to exchange code for token");
        try {
            CredentialsBean credentials = new CredentialsBean(clientId, clientSecret);
            if (clientId == null) {
                credentials = this.getCredentialFromBasicAuthorization(request);
            } else if (request.getHeader(AUTHORIZATION_HEADER) != null) {
                throw new Exception("the client MUST NOT use more than one authentication method");
            }
            logger.info("Params are client_id = " + credentials.getClientId() + ", client_secret = " + credentials.getClientSecret() + "*******************, redirect_uri = " + redirectUri + ", code = " + code + "*******************, grant_type = " + grantType);
            MemCachedBean cachedBean = this.checkRequest(credentials, redirectUri, code, grantType, request);
            if (!cachedBean.isSuccess()) {
                String errorMessage = cachedBean.getErrorMessage();
                logger.error("The request fails because of " + errorMessage);
                return Response.status((Response.Status)status).entity((Object)new AccessTokenErrorResponse(errorMessage, null)).build();
            }
            logger.info("The request is ok");
            String tokenToReturn = cachedBean.getToken();
            String scope = cachedBean.getScope();
            status = Response.Status.OK;
            return Response.status((Response.Status)status).entity((Object)new AccessTokenBeanResponse(tokenToReturn, scope)).build();
        }
        catch (Exception e) {
            logger.error("Failed to perform this operation", (Throwable)e);
            status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new AccessTokenErrorResponse("invalid_request", null)).build();
        }
    }

    private CredentialsBean getCredentialFromBasicAuthorization(HttpServletRequest request) {
        String basicAuthorization = request.getHeader(AUTHORIZATION_HEADER);
        String base64Credentials = basicAuthorization.substring("Basic".length()).trim();
        String credentials = new String(DatatypeConverter.parseBase64Binary((String)base64Credentials));
        String[] splitCreds = credentials.split(":");
        String clientId = null;
        String clientSecret = null;
        try {
            clientId = URLDecoder.decode(splitCreds[0], StandardCharsets.UTF_8.toString());
            clientSecret = URLDecoder.decode(splitCreds[1], StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new CredentialsBean(clientId, clientSecret);
    }

    private MemCachedBean checkRequest(CredentialsBean credentials, String redirectUri, String code, String grantType, HttpServletRequest request) {
        try {
            if (credentials.getClientId() == null || credentials.getClientSecret() == null || redirectUri == null || code == null || grantType == null) {
                return new MemCachedBean("invalid_request");
            }
            if (credentials.getClientId().isEmpty() || credentials.getClientSecret().isEmpty() || redirectUri.isEmpty() || code.isEmpty() || grantType.isEmpty()) {
                return new MemCachedBean("invalid_request");
            }
            if (!this.checkIsapplicationTokenType(Constants.authorizationService().get(credentials.getClientSecret()).getClientInfo().getType())) {
                return new MemCachedBean("invalid_client");
            }
            MemcachedClient entries = new DistributedCacheClient().getMemcachedClient();
            if (entries.get(code) == null) {
                return new MemCachedBean("invalid_grant");
            }
            logger.debug("Got tempCode and looking into memcached for correspondance, " + code);
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse((String)entries.get(code));
            String cachedRedirectUri = (String)json.get((Object)"redirect_uri");
            String cachedClientId = (String)json.get((Object)"client_id");
            logger.debug("Found tempCode into memcached, cachedClientId=" + cachedClientId);
            if (!cachedRedirectUri.equals(redirectUri) || !cachedClientId.equals(credentials.getClientId())) {
                return new MemCachedBean("invalid_grant");
            }
            if (!grantType.equals(GRANT_TYPE_VALUE)) {
                return new MemCachedBean("unsupported_grant_type");
            }
            String cachedToken = (String)json.get((Object)"token");
            String cachedContext = (String)json.get((Object)"context");
            logger.debug("Returning cachedToken=" + cachedToken + " and cachedContext=" + cachedContext);
            return new MemCachedBean(cachedToken, cachedContext);
        }
        catch (Exception e) {
            logger.error("Failed to check the correctness of the request", (Throwable)e);
            return new MemCachedBean("invalid_request");
        }
    }
}

