/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.OIDCTokenCacheProxy;

public class PostLoginAction
extends Action {
    protected static final Log log = LogFactoryUtil.getLog(PostLoginAction.class);

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        if (log.isInfoEnabled()) {
            log.info((Object)"PostLoginAction invoked");
        }
        JWTToken token = JWTTokenUtil.getOIDCFromRequest((HttpServletRequest)request);
        HttpSession session = request.getSession();
        if (token != null && session != null) {
            User user;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Session details: id=" + session.getId() + ", instance=" + session));
            }
            if ((user = (User)session.getAttribute("USER")) != null) {
                log.info((Object)"Setting OIDC token in proxy");
                OIDCTokenCacheProxy.getInstance().setOIDCToken(user, session, token);
            } else {
                log.error((Object)"User object not found in session");
            }
            log.info((Object)"Setting OIDC token in session");
            JWTTokenUtil.putOIDCInSession((JWTToken)token, (HttpSession)session);
        }
    }
}

