/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oidc.lr62;

import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.SessionAction;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.User;
import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpSession;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.portal.oidc.lr62.JWTCacheProxy;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;

public class SessionDestroyAction
extends SessionAction {
    protected static final Log log = LogFactoryUtil.getLog(SessionDestroyAction.class);

    public void run(HttpSession session) throws ActionException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Session details " + session.getId() + " [" + Integer.toHexString(session.hashCode()) + "]"));
        }
        User user = (User)session.getAttribute("USER");
        LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration();
        if (configuration.logoutOnPortalLogout()) {
            JWTToken token = JWTCacheProxy.getInstance().getOIDCToken(user, session.getId());
            if (token != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Performing logout on OIDC server due to session destroy for user: " + user.getScreenName()));
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Performing the OIDC backchannel logout");
                    }
                    OpenIdConnectRESTHelper.logout((URL)configuration.getLogoutURL(), (JWTToken)token);
                }
                catch (IOException e) {
                    throw new ActionException("Performing logut on OIDC server", (Throwable)e);
                }
            } else {
                log.warn((Object)("Cannot find the OIDC token in session " + session.getId() + " [" + Integer.toHexString(session.hashCode()) + "]"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Don't perform OIDC logout according to configuration for user: " + user.getScreenName()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing OIDC tokens from cache proxy for user " + user.getScreenName() + " and session " + session.getId()));
        }
        JWTCacheProxy.getInstance().removeOIDCToken(user, session.getId());
        JWTCacheProxy.getInstance().removeUMAToken(user, session.getId());
    }
}

