/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins.thread;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;

public class RemoveUserTokenFromVREThread
implements Runnable {
    private static Log _log = LogFactoryUtil.getLog(RemoveUserTokenFromVREThread.class);
    private String username;
    private String scope;

    public RemoveUserTokenFromVREThread(String username, String scope) {
        this.username = username;
        this.scope = scope;
    }

    @Override
    public void run() {
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(this.scope);
        try {
            String userToken = Constants.authorizationService().resolveTokenByUserAndContext(this.username, this.scope);
            SecurityTokenProvider.instance.set(userToken);
            Constants.authorizationService().removeAllReleatedToken(this.username, this.scope);
            _log.info((Object)("*** Removed user token " + this.username + " in " + this.scope));
        }
        catch (Exception e) {
            _log.error((Object)("Could not remove user token " + this.username + " in " + this.scope), (Throwable)e);
        }
        ScopeProvider.instance.set(currScope);
    }
}

