package org.gcube.portal.databook.shared;

import java.io.Serializable;
import java.util.Date;

/**
 * Represents a feed item in the social stream.
 *
 * @author Massimiliano Assante, ISTI-CNR
 * @deprecated use {@link org.gcube.portal.databook.shared.Post} instead
 */
@SuppressWarnings("serial")
public class Feed implements Serializable, Comparable<Feed> {

	private String key;
	private FeedType type;
	private String entityId;
	private Date time;
	private String vreid;
	private String uri;
	private String uriThumbnail;
	private String description;
	private PrivacyLevel privacy;
	private String fullName;
	private String email;
	private String thumbnailURL;
	private String commentsNo;
	private String likesNo;
	private String linkTitle;
	private String linkDescription;
	private String linkHost;
	boolean applicationFeed;
	/**
	 * this boolean indicates that the attachments to the post are > 1
	 */
	boolean multiFileUpload;
	/**
	 * default constructor
	 */
	public Feed() {
		super();
	}
	/**
	 * Constructor for user-generated feeds.
	 *
	 * @param key The unique identifier (UUID) for the feed.
	 * @param type The type of the feed, from {@link FeedType}.
	 * @param entityId The unique identifier of the user creating the feed.
	 * @param time The timestamp of the feed creation.
	 * @param vreid The unique identifier of the VRE where the feed is posted.
	 * @param uri An optional URI associated with the feed.
	 * @param uriThumbnail The thumbnail for any link included in the feed.
	 * @param description The main content/description of the feed.
	 * @param privacy The privacy level, from {@link PrivacyLevel}.
	 * @param fullName The full name of the user posting the feed.
	 * @param email The email address of the user.
	 * @param thumbnailURL The URL of the user's profile thumbnail.
	 * @param linkTitle An optional title for any link included in the feed.
	 * @param linkDescription An optional description for any link included in the feed.
	 * @param linkHost The host of any link included in the feed.
	  */
	public Feed(String key, FeedType type, String entityId, Date time,
			String vreid, String uri, String uriThumbnail, String description, PrivacyLevel privacy,
			String fullName, String email, String thumbnailURL, String linkTitle, String linkDescription, String linkHost) {
		this.key = key;
		this.type = type;
		this.entityId = entityId;
		this.time = time;
		this.vreid = vreid;
		this.uri = uri;
		this.uriThumbnail = uriThumbnail;
		this.description = description;
		this.privacy = privacy;
		this.fullName = fullName;
		this.email = email;
		this.thumbnailURL = thumbnailURL;
		this.commentsNo = "0";
		this.likesNo = "0";
		this.linkDescription = linkDescription;
		this.linkTitle = linkTitle;
		this.linkHost = linkHost;
		this.applicationFeed = false;
	}
	/**
	 * Constructor for both user and application-generated feeds.
	 *
	 * @param key The unique identifier (UUID) for the feed.
	 * @param type The type of the feed, from {@link FeedType}.
	 * @param entityId The unique identifier of the user or application creating the feed.
	 * @param time The timestamp of the feed creation.
	 * @param vreid The unique identifier of the VRE where the feed is posted.
	 * @param uri An optional URI associated with the feed.
	 * @param uriThumbnail The thumbnail for any link included in the feed.
	 * @param description The main content/description of the feed.
	 * @param privacy The privacy level, from {@link PrivacyLevel}.
	 * @param fullName The full name of the user or application posting the feed.
	 * @param email The email address of the user (can be null for applications).
	 * @param thumbnailURL The URL of the user or application thumbnail.
	 * @param linkTitle An optional title for any link included in the feed.
	 * @param linkDescription An optional description for any link included in the feed.
	 * @param linkHost The host of any link included in the feed.
	 * @param applicationFeed A flag indicating if this is an application feed.
	  */
	public Feed(String key, FeedType type, String entityId, Date time,
			String vreid, String uri, String uriThumbnail, String description, PrivacyLevel privacy,
			String fullName, String email, String thumbnailURL, String linkTitle, String linkDescription, String linkHost, boolean applicationFeed) {
		this(key, type, entityId, time, vreid, uri, uriThumbnail, description, privacy, fullName, email, thumbnailURL, linkTitle, linkDescription, linkHost);
		this.applicationFeed = applicationFeed;
	}
	
	
	/**
	 * Full constructor for serialization purposes.
	 *
	 * @param key The unique identifier (UUID) for the feed.
	 * @param type The type of the feed, from {@link FeedType}.
	 * @param entityId The unique identifier of the user or application creating the feed.
	 * @param time The timestamp of the feed creation.
	 * @param vreid The unique identifier of the VRE where the feed is posted.
	 * @param uri An optional URI associated with the feed.
	 * @param uriThumbnail The thumbnail for any link included in the feed.
	 * @param description The main content/description of the feed.
	 * @param privacy The privacy level, from {@link PrivacyLevel}.
	 * @param fullName The full name of the user or application posting the feed.
	 * @param email The email address of the user (can be null for applications).
	 * @param thumbnailURL The URL of the user or application thumbnail.
	 * @param commentsNo The number of comments on the feed.
	 * @param likesNo The number of likes on the feed.
	 * @param linkTitle An optional title for any link included in the feed.
	 * @param linkDescription An optional description for any link included in the feed.
	 * @param linkHost The host of any link included in the feed.
	 * @param applicationFeed A flag indicating if this is an application feed.
	 * @param multiFileUpload A flag indicating if the feed has multiple file uploads.
	 */
	public Feed(String key, FeedType type, String entityId, Date time,
			String vreid, String uri, String uriThumbnail, String description, PrivacyLevel privacy,
			String fullName, String email, String thumbnailURL, String commentsNo,
			String likesNo, String linkTitle, String linkDescription, String linkHost, boolean applicationFeed, boolean multiFileUpload) {
		super();
		this.key = key;
		this.type = type;
		this.entityId = entityId;
		this.time = time;
		this.vreid = vreid;
		this.uri = uri;
		this.uriThumbnail = uriThumbnail;
		this.description = description;
		this.privacy = privacy;
		this.fullName = fullName;
		this.email = email;
		this.thumbnailURL = thumbnailURL;
		this.commentsNo = commentsNo;
		this.likesNo = likesNo;
		this.linkDescription = linkDescription;
		this.linkTitle = linkTitle;
		this.linkHost = linkHost;
		this.applicationFeed = applicationFeed;
		this.multiFileUpload = multiFileUpload;
	}
	/**
	 * 
	 * @return the key
	 */
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public FeedType getType() {
		return type;
	}

	public void setType(FeedType type) {
		this.type = type;
	}
	/**
	 * 
	 * @return the User or the App id
	 */
	public String getEntityId() {
		return entityId;
	}
	/**
	 * set the User or the App id
	 * @param entityId the UserId or the AppId id
	 */
	public void setEntityId(String entityId) {
		this.entityId = entityId;
	}
	
	public Date getTime() {
		return time;
	}

	public void setTime(Date time) {
		this.time = time;
	}

	public String getVreid() {
		return vreid;
	}

	public void setVreid(String vreid) {
		this.vreid = vreid;
	}

	public String getUri() {
		return uri;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public PrivacyLevel getPrivacy() {
		return privacy;
	}

	public void setPrivacy(PrivacyLevel privacy) {
		this.privacy = privacy;
	}

	public String getFullName() {
		return fullName;
	}

	public void setFullName(String fullName) {
		this.fullName = fullName;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getThumbnailURL() {
		return thumbnailURL;
	}

	public void setThumbnailURL(String thumbnailURL) {
		this.thumbnailURL = thumbnailURL;
	}
	
	public String getCommentsNo() {
		return commentsNo;
	}
	public void setCommentsNo(String commentsNo) {
		this.commentsNo = commentsNo;
	}
	public String getLikesNo() {
		return likesNo;
	}
	public void setLikesNo(String likesNo) {
		this.likesNo = likesNo;
	}	
	public String getUriThumbnail() {
		return uriThumbnail;
	}
	public void setUriThumbnail(String uriThumbnail) {
		this.uriThumbnail = uriThumbnail;
	}

	public String getLinkTitle() {
		return linkTitle;
	}
	public void setLinkTitle(String linkTitle) {
		this.linkTitle = linkTitle;
	}
	public String getLinkDescription() {
		return linkDescription;
	}
	public void setLinkDescription(String linkDescription) {
		this.linkDescription = linkDescription;
	}
	public int compareTo(Feed toCompare) {
		if (this.time.after(toCompare.getTime()))
			return 1;
		if (this.time.before(toCompare.getTime()))
			return -1;
		return 0;
	}
	public String getLinkHost() {
		return linkHost;
	}
	public void setLinkHost(String linkHost) {
		this.linkHost = linkHost;
	}
	
	public boolean isApplicationFeed() {
		return applicationFeed;
	}
	public void setApplicationFeed(boolean applicationFeed) {
		this.applicationFeed = applicationFeed;
	}
	public boolean isMultiFileUpload() {
		return multiFileUpload;
	}
	public void setMultiFileUpload(boolean multiFileUpload) {
		this.multiFileUpload = multiFileUpload;
	}
	@Override
	public String toString() {
		return "Feed [key=" + key + ", type=" + type + ", entityId=" + entityId
				+ ", time=" + time + ", vreid=" + vreid + ", uri=" + uri
				+ ", uriThumbnail=" + uriThumbnail + ", description="
				+ description + ", privacy=" + privacy + ", fullName="
				+ fullName + ", email=" + email + ", thumbnailURL="
				+ thumbnailURL + ", commentsNo=" + commentsNo + ", likesNo="
				+ likesNo + ", linkTitle=" + linkTitle + ", linkDescription="
				+ linkDescription + ", linkHost=" + linkHost
				+ ", applicationFeed=" + applicationFeed
				+ ", multiFileUpload=" + multiFileUpload + "]";
	}

}
