package org.gcube.portlets.user.warmanagementwidget.client.rpc;

import org.gcube.portlets.user.warmanagementwidget.client.data.WarProfile;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgress;

import com.google.gwt.user.client.rpc.AsyncCallback;

public interface WarManagementServiceAsync {
	
	/**
	 * Create a new session import id.
	 * @param callback the callback to return the session id.
	 */
	public void createWarSessionId(AsyncCallback<String> callback);
	
	
	/**
	 * Returns the current file upload state, used by local upload.
	 * @param sessionId the CSV session id.
	 * @param callback the callback to return the upload state.
	 */
	public void getLocalUploadStatus(String sessionId, AsyncCallback<OperationProgress> callback);


	void getWarProfile(String warId, AsyncCallback<WarProfile> callback);


	void uploadWar(String sessionId, WarProfile profile, String baseUrl,
			AsyncCallback<Void> callback);


	void getWarUploadProgress(String sessionId,
			AsyncCallback<OperationProgress> callback);


	void getWarFileName(String sessionId, AsyncCallback<String> callback);


	void deleteWar(String warId, AsyncCallback<String> callback);


	void getOperationProgress(String operationId, AsyncCallback<OperationProgress> callback);
	
}
