/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.gcube.portlets.user.warmanagementwidget.server.management.SAPublisher;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class SAServlet extends HttpServlet {
	private static final long serialVersionUID = 3918260067935455716L;

	protected static Logger logger = Logger.getLogger(SAServlet.class);

	static{
		ConsoleAppender ca = new ConsoleAppender(new SimpleLayout());
		ca.setThreshold(Level.ALL);
		ca.activateOptions();
		logger.addAppender(ca);
		logger.setLevel(Level.ALL);
	}

	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		handleRequest(req, resp);
	}

	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException  {
		handleRequest(req, resp);
	}

	protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		logger.trace("SAServlet");

		String saId = (String) request.getParameter("saId");
		logger.trace("saId: "+saId);
		
		int index = saId.indexOf("/");
		if (index>=0) saId = saId.substring(0, index);

		if (saId!=null){
			logger.trace("retrieving the sa");

			//FIXME SET A FILE NAME, SR NEED IT
			
			File war = SAPublisher.getInstance().getSAFile(saId);

			if (war != null) { 
				response.setContentType("application/octet-stream;");
				InputStream input = new FileInputStream(war);
				IOUtils.copy(input, response.getOutputStream());
				response.setStatus(HttpServletResponse.SC_OK);

				SAPublisher.getInstance().deleteSAFile(saId);
			} else response.sendError(HttpServletResponse.SC_NOT_FOUND, "SA with id "+saId+" not found");
		} else response.sendError(HttpServletResponse.SC_NOT_FOUND, "saId parameter not specified");
	}
}
