/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.local;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import org.apache.commons.io.IOUtils;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class Util {
	
	public static final String[] ZIP_MIMETYPES = new String[]{
		"application/x-compress",
		"application/x-compressed",
		"application/x-gzip",
		"application/x-winzip",
		"application/x-zip",
		"application/zip",
		"multipart/x-zip"};
	
	/**
	 * Check if the content type is a zip type.
	 * @param contentType the content type to check.
	 * @return <code>true</code> if is a zip file, <code>false</code> otherwise.
	 */
	public static boolean isZipContentType(String contentType)
	{
		for (String zip_mimetype:ZIP_MIMETYPES) if (zip_mimetype.equals(contentType)) return true;
		return false;
	}
	

	/**
	 * Unzip the specified stream
	 * @param is the zip stream.
	 * @param os the output stream.
	 * @throws Exception
	 */
	public static String unZip(InputStream is, OutputStream os) throws Exception
	{
		ZipInputStream zis = new ZipInputStream(is);
		ZipEntry entry;
		
		while ((entry = zis.getNextEntry())!=null){
			if (!entry.isDirectory()){
				IOUtils.copy(zis, os);
				zis.closeEntry();
				zis.close();
				os.close();
				return entry.getName();
			}
		}
		
		throw new Exception("No file entry found");
		
	}

}
