/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.portlets.user.warmanagementwidget.client.data.WarProfile;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgress;
import org.gcube.portlets.user.warmanagementwidget.server.management.GCubeWarUploader;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class TestSAUpload {

	/**
	 * @param args
	 * @throws Exception 
	 */
	public static void main(String[] args) throws Exception {
		WarProfile warProfile = new WarProfile(
				"43065120-8e20-11e0-9ca7-9e5a37d55c15",
				"fisheryresources-web-0.0.5.war", 
				"Fishery", 
				"My first war", 
				"fisheryresources-web", 
				"Service FisheryResources with the operations StocksBySpecies and StocksByFaoArea", 
				0,0,5, 
				new ArrayList<String>(Arrays.asList("/stocksbyspecies/fao3alphacode/SKJ","/stocksbyfaoarea/faoarea/21.3")));
		
		
		OperationProgress operationProgress = new OperationProgress();
		GCUBEScope scope = GCUBEScope.getScope("/gcube/devsec");
		GCUBESecurityManager securityManager = new GCUBESecurityManagerImpl() {
			@Override
			public boolean isSecurityEnabled() {return false;}
		};
		String user = "test.user";
		
		String sessionId = "1";
		String baseUrl = "http://devportal.d4science.research-infrastructures.eu/serviceArchive8705929978675340880tmp.tar.gz";
		
		File warFile = new File("/home/fedy2/Desktop/famfamfam_silk_icons_v013.zip");
		
		GCubeWarUploader uploader = new GCubeWarUploader(operationProgress, user, scope, securityManager, sessionId, warFile, warProfile, baseUrl);
		
		uploader.run();

	}

}
