package org.gcube.portlet.user.my_vres.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlet.user.my_vres.client.MyVREsService;
import org.gcube.portlet.user.my_vres.shared.UserBelonging;
import org.gcube.portlet.user.my_vres.shared.VO;
import org.gcube.portlet.user.my_vres.shared.VRE;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;

/**
 * The server side implementation of the RPC service.
 * @author Massimiliano Assante - ISTI CNR
 * @version 1.0 Jun 2012
 */
@SuppressWarnings("serial")
public class MyVREsServiceImpl extends RemoteServiceServlet implements	MyVREsService {

	private static GCUBELog _log = new GCUBELog(MyVREsServiceImpl.class);
	/**
	 * 
	 */
	public static final String CACHED_VOS = "CACHED_VRES";
	/**
	 * 
	 */
	public static final String ROOT_ORG = "rootorganization";

	private VO rootVO = new VO();

	private boolean withinPortal = false;

	/**
	 * the current ASLSession
	 * @return the session
	 */
	private ASLSession getASLSession() {
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		if (user == null) {
			_log.warn("USER IS NULL setting test.user");
			user = "test.user";
		}
		else {
			_log.info("LIFERAY PORTAL DETECTED user=" + user);
			withinPortal = true;
		}
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}

	/**
	 * first method called by the UI
	 */
	public ArrayList<VO> getInfrastructureVOs() {	
		getASLSession();
		//_log.trace("getInfrastructureVOs method called");
		if (!withinPortal)
			return getFakeVOs();
			//return new ArrayList<VO>();
		else 
			try {
				String username = getASLSession().getUsername();
				User currUser = OrganizationsUtil.validateUser(username);			
				
				List<Organization> organizations = OrganizationLocalServiceUtil.getOrganizations(0, OrganizationLocalServiceUtil.getOrganizationsCount());

				ThemeDisplay themeDisplay = (ThemeDisplay) this.getThreadLocalRequest().getSession().getAttribute(WebKeys.THEME_DISPLAY);

				Organization rootOrganization = null;
				for (Organization organization : organizations) {
					if (organization.getName().equals( getRootOrganizationName() ) ) {
						rootOrganization = organization;
						break;
					}
				}		
				try {
					//_log.info("root: " + rootOrganization.getName() );
				}
				catch (NullPointerException e) {
					_log.error("Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
					return new ArrayList<VO>();
				}
				// Create the list of the Infrastructure VOs
				List<VO> infrastructureVOs = new ArrayList<VO>();

				//create and check the root VO
				rootVO = new VO();
				rootVO.setName(rootOrganization.getName());
				rootVO.setGroupName("/"+rootOrganization.getName());
				rootVO.setRoot(true);	

				Group orgGroup = rootOrganization.getGroup();
				String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();

				rootVO.setFriendlyURL(getPortalBasicUrl()+friendlyURL);
				long logoId = rootOrganization.getLogoId();
				String logoURL =  themeDisplay.getPathImage()+"/organization_logo?img_id="+ logoId +"&t" + ImageServletTokenUtil.getToken(logoId);
				rootVO.setImageURL(logoURL);


				if (rootOrganization.getComments() != null)
					rootVO.setDescription(rootOrganization.getComments());


				//for each root sub organizations (VO)
				for (Organization vOrg : rootOrganization.getSuborganizations()) {

					//_log.debug("SKIP GCUBE APPS " + vOrg.getName() );

					//_log.debug("FOUND VO: " + vOrg.getName() );
					//create the VO
					VO voToAdd = new VO();
					voToAdd.setName(vOrg.getName());
					voToAdd.setGroupName("/"+vOrg.getParentOrganization().getName()+"/"+vOrg.getName());
					voToAdd.setRoot(false);	

					for (Organization vre : vOrg.getSuborganizations()) {
						VRE vreToAdd = new VRE();
						vreToAdd.setName(vre.getName());
						vreToAdd.setGroupName("/"+vOrg.getParentOrganization().getName()+"/"+vOrg.getName()+"/"+vre.getName());

						logoId = vre.getLogoId();
						logoURL =  themeDisplay.getPathImage()+"/organization_logo?img_id="+ logoId +"&t" + ImageServletTokenUtil.getToken(logoId);
						vreToAdd.setImageURL(logoURL);

						String vreUrl = vre.getGroup().getPathFriendlyURL(true, themeDisplay) + vre.getGroup().getFriendlyURL();
						vreToAdd.setFriendlyURL(getPortalBasicUrl()+vreUrl);

						//set the description for the vre
						if (vre.getComments() != null)	{
							vreToAdd.setDescription(vre.getComments());
						}

						//check if the user belongs to it
						if (currUser.getOrganizations().contains(vre)) {
							vreToAdd.setUserBelonging(UserBelonging.BELONGING);
							voToAdd.addVRE(vreToAdd);
						}		
					}



					Group group = vOrg.getGroup();
					String url = group.getPathFriendlyURL(true, themeDisplay) + group.getFriendlyURL();
					voToAdd.setFriendlyURL(getPortalBasicUrl() + url);

					//set the description for the vre
					if (vOrg.getComments() != null)	voToAdd.setDescription(vOrg.getComments());
					//check if the user belongs to it
					if (currUser.getOrganizations().contains(vOrg)) {
						voToAdd.setUserBelonging(UserBelonging.BELONGING);
					}
					else
						voToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
					infrastructureVOs.add(voToAdd);
				}


				ArrayList<VO> toReturn = new ArrayList<VO>();


				for (VO vo : infrastructureVOs) {
					for (VRE vre : vo.getVres()) {
						//_log.debug("VRE FOUND.... " + vre.getName());
					}
					toReturn.add(vo);
				}			
				//sort the VOs
				Collections.sort(toReturn, Collections.reverseOrder()); 

				//set the root vo as FIRST
				toReturn.add(0, rootVO);

				ArrayList<VO> toStoreInSession = toReturn;			
				//_log.debug("SETTING INFRASTRUCTURE VOS in ASLSession");
				getASLSession().setAttribute(CACHED_VOS, toStoreInSession);

				return toReturn;

			} 
		catch (Exception e) {			
			e.printStackTrace();
			return null;
		}
	}


	/**
	 * 
	 * @param scope
	 */
	public void loadLayout(String scope, String URL) {
		_log.trace("Calling Load Layout...");
		HttpSession session = this.getThreadLocalRequest().getSession();
		ASLSession mysession = getASLSession();
		mysession.setAttribute("loadlayout", "true");
		session.setAttribute("loadLayout", "true");
		session.setAttribute("selectedVRE", scope);
		mysession.logUserLogin(scope);
		mysession.setScope(scope);

		_log.trace("User login logged to: " + scope);
	}

	/**
	 * read the root VO name from a property file and retuns it
	 */
	protected static String getRootOrganizationName() {
		//get the portles to look for from the property file
		Properties props = new Properties();
		String toReturn = "gcube";

		try {
			String propertyfile = OrganizationsUtil.getTomcatFolder()+"conf/gcube-data.properties";			
			File propsFile = new File(propertyfile);
			FileInputStream fis = new FileInputStream(propsFile);
			props.load( fis);
			toReturn = props.getProperty(ROOT_ORG);
		}
		//catch exception in case properties file does not exist
		catch(IOException e) {
			toReturn = "gcube";
			_log.error("gcube-data.properties file not found under $CATALINA_HOME/conf dir, returning default VO Name " + toReturn);
			return toReturn;
		}
		_log.debug("Returning Root VO Name: " + toReturn );
		return toReturn;
	}

	/**
	 * 
	 * @return the portal basic url, e.g. http://www.foo.com
	 */
	private String getPortalBasicUrl() {
		HttpServletRequest request = this.getThreadLocalRequest();
		String toReturn = "";
		//protocol
		String protocol = (request.isSecure()) ? "https://" : "http://" ;
		toReturn += protocol;
		//server name
		toReturn += request.getServerName();
		//port
		toReturn +=  (request.getServerPort() == 80) ? "" : ":"+request.getServerPort() ;
	//	_log.trace("getPortalBasicUrl: " +toReturn + "queryString: " +	request.getQueryString());
		return toReturn;
	}


	/**
	 * simply returns fake VOS for debugging purpose
	 * @return
	 */
	protected static ArrayList<VO> getFakeVOs() {
		VO rootVO = new VO();
		rootVO.setRoot(true);
		rootVO.setName("/d4science.research-infrastructures.eu/");
		rootVO.setDescription("This is the description for the ROOT VO");
		rootVO.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/RedGrid.jpg");
		rootVO.setUserBelonging(UserBelonging.BELONGING);


		/***************************************/

		VO emVO = new VO();
		emVO.setRoot(false);
		emVO.setGroupName("/d4science.research-infrastructures.eu/EM/");
		emVO.setName("EM VO");
		emVO.setDescription("EM and AEM Virtual Organisation The FARM Virtual Organisation is the dynamic group of individuals and/or institutions defined around a set of sharing rules in which resource providers and consumers specify clearly and carefully just what is shared, who is allowed to share, and the conditions under which sharing occurs to serve the needs of the Fisheries and Aquaculture Resources Management.");
		emVO.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/RedGrid.jpg");

		emVO.setUserBelonging(UserBelonging.NOT_BELONGING);
		//			
		//			
		VRE cool_EM_VRE = new VRE();
		cool_EM_VRE.setName("BiodiversityResearchEnvironment");
		cool_EM_VRE.setGroupName("/d4science.research-infrastructures.eu/EM/COOLEMVRE");
		cool_EM_VRE.setDescription("cool_EM_VRE VRE Description<br />"+ 
				"This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");
		cool_EM_VRE.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/gcm-preview.jpg");
		cool_EM_VRE.setUserBelonging(UserBelonging.BELONGING);
		emVO.addVRE(cool_EM_VRE);

		VRE cool_EM_VRE2 = new VRE();
		cool_EM_VRE2.setName("COOL VRE 2");
		cool_EM_VRE2.setGroupName("/d4science.research-infrastructures.eu/EM/COOLEMVRE2");
		cool_EM_VRE2.setDescription("Cool VRE Description<br />"+ 
				"This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");

		cool_EM_VRE2.setImageURL("https://newportal.i-marine.d4science.org/image/organization_logo?img_id=13302&t1339191699773");
		cool_EM_VRE2.setUserBelonging(UserBelonging.NOT_BELONGING);

		VRE cool_EM_VRE3 = new VRE();
		cool_EM_VRE3.setName("COOL EM VRE TRE");
		cool_EM_VRE3.setGroupName("/d4science.research-infrastructures.eu/EM/COOlVRE3");
		cool_EM_VRE3.setDescription("Cool VRE Description<br />"+ 
				"This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");

		cool_EM_VRE3.setImageURL("https://newportal.i-marine.d4science.org/image/organization_logo?img_id=13302&t1339191699773");
		cool_EM_VRE3.setUserBelonging(UserBelonging.BELONGING);

		VRE demo = new VRE();
		demo.setName("Demo");
		demo.setGroupName("/d4science.research-infrastructures.eu/EM/Demo");
		demo.setDescription("Cool VRE Description<br />"+ 
				"This Virtual Research Environment is for cool authors, managers and researchers who produce reports containing cool data.");

		demo.setImageURL("http://portal.d4science.research-infrastructures.eu/vologin/html/RedGrid.jpg");
		demo.setUserBelonging(UserBelonging.BELONGING);

		VRE vreGCM = new VRE();
		vreGCM.setName("GCM");
		vreGCM.setGroupName("/d4science.research-infrastructures.eu/EM/GCM");
		vreGCM.setDescription("Global Ocean Chlorophyll Monitoring (GCM) Virtual Research Environment<br />" 
				+ "The phytoplankton plays a similar role to terrestrial green plants in the photosynthetic process and are credited with removing as much carbon dioxide from the atmosphere as their earthbound counterparts, making it important to monitor and model plankton into calculations of future climate change.");
		vreGCM.setImageURL("https://newportal.i-marine.d4science.org/image/organization_logo?img_id=13302&t1339191699773");
		vreGCM.setUserBelonging(UserBelonging.BELONGING);


		emVO.addVRE(cool_EM_VRE);
		emVO.addVRE(cool_EM_VRE2);
		emVO.addVRE(cool_EM_VRE3);
		emVO.addVRE(demo);
		emVO.addVRE(vreGCM);

		ArrayList<VO> toReturn = new ArrayList<VO>();
		toReturn.add(rootVO);
		toReturn.add(emVO);
		toReturn.add(emVO);
		return toReturn;
	}
}