package org.gcube.portlets.admin.accountingmanager.server.amservice.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;

import org.gcube.accounting.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.TemporalConstraint;
import org.gcube.portlets.admin.accountingmanager.server.amservice.PeriodModeMap;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilter;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.exception.AccountingManagerServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Accounting Query 4 Service
 * 
 * @author "Giancarlo Panichi" email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 * 
 */
public class AccountingQuery4Service extends AccountingQueryBuilder {
	protected static Logger logger = LoggerFactory
			.getLogger(AccountingQuery4Service.class);
	private SeriesRequest seriesRequest;

	public AccountingQuery4Service(SeriesRequest seriesRequest) {
		this.seriesRequest = seriesRequest;
	}

	@Override
	public void buildOpEx() throws AccountingManagerServiceException {
		
		Calendar startCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
		try {
			startCalendar.setTime(sdf.parse(seriesRequest.getAccountingPeriod().getStartDate()));
		} catch (ParseException e) {
			e.printStackTrace();
			throw new AccountingManagerServiceException("Start Date not valid!");
		}
		
		Calendar endCalendar = GregorianCalendar.getInstance(TemporalConstraint.DEFAULT_TIME_ZONE);
		try {
			endCalendar.setTime(sdf.parse(seriesRequest.getAccountingPeriod().getEndDate()));
		} catch (ParseException e) {
			e.printStackTrace();
			throw new AccountingManagerServiceException("End Date not valid!");
		}
		
		endCalendar.set(GregorianCalendar.HOUR_OF_DAY, 23);
		endCalendar.set(GregorianCalendar.MINUTE, 59);
		endCalendar.set(GregorianCalendar.SECOND, 59);
		endCalendar.set(GregorianCalendar.MILLISECOND, 999);
		
		TemporalConstraint temporalConstraint = new TemporalConstraint(
				startCalendar.getTimeInMillis(),
				endCalendar.getTimeInMillis(),
				PeriodModeMap.getMode(seriesRequest.getAccountingPeriod()
						.getPeriod()));
		
		ArrayList<AccountingFilter> accountingFilters = seriesRequest
				.getFilters();
		
		ArrayList<Filter> filters=null;
		if (accountingFilters != null) {
			filters = new ArrayList<Filter>();
			for (AccountingFilter accountigFilters : accountingFilters) {
				Filter filter = new Filter(accountigFilters.getFilterKey()
						.getKey(), accountigFilters.getFilterValue());
				filters.add(filter);
			}
		}

		AccountingQuery invocation = new AccountingQuery(
				AggregatedServiceUsageRecord.class, temporalConstraint, filters);
		
		accountingQuerySpec.setOp(invocation);

	}
}
