/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Info;
import org.gcube.accounting.analytics.NumberedFilter;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesTask;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.task.SeriesTaskDataTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.task.SeriesTaskDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.task.SeriesTaskTop;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4TaskTop
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4TaskTop.class);
    private Boolean showOthers;
    private Integer topNumber;
    private SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM;

    public SeriesResponse4TaskTop(Boolean showOthers, Integer topNumber, SortedMap<NumberedFilter, SortedMap<Calendar, Info>> topSM) {
        this.showOthers = showOthers;
        this.topNumber = topNumber;
        this.topSM = topSM;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.topSM == null || this.topSM.isEmpty()) {
                logger.error("Error creating series for task accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesTaskDataTop> seriesTaskDataTopList = new ArrayList<SeriesTaskDataTop>();
            for (NumberedFilter topValue : this.topSM.keySet()) {
                ArrayList series = new ArrayList();
                SortedMap infos = (SortedMap)this.topSM.get(topValue);
                for (Info info : infos.values()) {
                    JSONObject jSONObject = info.getValue();
                }
                SeriesTaskDataTop seriesTaskDataTop = new SeriesTaskDataTop(new FilterValue(topValue.getValue()), series);
                seriesTaskDataTopList.add(seriesTaskDataTop);
            }
            SeriesTaskTop seriesTaskTop = new SeriesTaskTop(this.showOthers, this.topNumber, seriesTaskDataTopList);
            SeriesTask seriesTask = new SeriesTask((SeriesTaskDefinition)seriesTaskTop);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesTask);
        }
        catch (Throwable e) {
            logger.error("Error creating series for portlet accounting top chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for portlet accounting top chart: " + e.getLocalizedMessage());
        }
    }
}

