/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice.response;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.SortedMap;
import org.gcube.accounting.analytics.Filter;
import org.gcube.accounting.analytics.Info;
import org.gcube.portlets.admin.accountingmanager.server.amservice.response.SeriesResponseBuilder;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesPortlet;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.portlet.SeriesPortletContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.portlet.SeriesPortletData;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.portlet.SeriesPortletDataContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.portlet.SeriesPortletDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeriesResponse4PortletContext
extends SeriesResponseBuilder {
    protected static Logger logger = LoggerFactory.getLogger(SeriesResponse4PortletContext.class);
    private Context context;
    private SortedMap<Filter, SortedMap<Calendar, Info>> contextSM;

    public SeriesResponse4PortletContext(Context context, SortedMap<Filter, SortedMap<Calendar, Info>> contextSM) {
        this.context = context;
        this.contextSM = contextSM;
    }

    public void buildSeriesResponse() throws ServiceException {
        try {
            if (this.contextSM == null || this.contextSM.isEmpty()) {
                logger.error("Error creating series for portlet accounting: No data available!");
                throw new ServiceException("No data available!");
            }
            ArrayList<SeriesPortletDataContext> seriesPortletDataContextList = new ArrayList<SeriesPortletDataContext>();
            for (Filter contextValue : this.contextSM.keySet()) {
                ArrayList<SeriesPortletData> series = new ArrayList<SeriesPortletData>();
                SortedMap infos = (SortedMap)this.contextSM.get(contextValue);
                for (Info info : infos.values()) {
                    JSONObject jso = info.getValue();
                    Long operationCount = jso.getLong("operationCount");
                    series.add(new SeriesPortletData(info.getCalendar().getTime(), operationCount));
                }
                SeriesPortletDataContext seriesPortletDataContext = new SeriesPortletDataContext(contextValue.getValue(), series);
                seriesPortletDataContextList.add(seriesPortletDataContext);
            }
            SeriesPortletContext seriesPortletContext = new SeriesPortletContext(this.context, seriesPortletDataContextList);
            SeriesPortlet seriesPortlet = new SeriesPortlet((SeriesPortletDefinition)seriesPortletContext);
            this.seriesResponseSpec.setSr((SeriesResponse)seriesPortlet);
        }
        catch (Throwable e) {
            logger.error("Error creating series for portlet accounting context chart: " + e.getLocalizedMessage());
            e.printStackTrace();
            throw new ServiceException("Error creating series for portlet accounting context chart: " + e.getLocalizedMessage());
        }
    }
}

