/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Queue;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.portlets.admin.accountingmanager.client.rpc.AccountingManagerService;
import org.gcube.portlets.admin.accountingmanager.server.AccountingManagerServiceImpl;
import org.gcube.portlets.admin.accountingmanager.server.SessionUtil;
import org.gcube.portlets.admin.accountingmanager.server.amservice.AccountingCaller;
import org.gcube.portlets.admin.accountingmanager.server.amservice.cache.AccountingCache;
import org.gcube.portlets.admin.accountingmanager.server.export.CSVManager;
import org.gcube.portlets.admin.accountingmanager.server.is.BuildEnableTabs;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.server.util.ServiceCredentials;
import org.gcube.portlets.admin.accountingmanager.server.util.TaskRequest;
import org.gcube.portlets.admin.accountingmanager.server.util.TaskWrapper;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.Spaces;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.gcube.portlets.admin.accountingmanager.shared.session.UserInfo;
import org.gcube.portlets.admin.accountingmanager.shared.tabs.EnableTabs;
import org.gcube.portlets.admin.accountingmanager.shared.workspace.ItemDescription;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingManagerServiceImpl
extends RemoteServiceServlet
implements AccountingManagerService {
    private static Logger logger = LoggerFactory.getLogger(AccountingManagerServiceImpl.class);

    public void init() throws ServletException {
        super.init();
        logger.info("Fix JAXP: jdk.xml.entityExpansionLimit=0");
        System.setProperty("jdk.xml.entityExpansionLimit", "0");
        logger.info("Initializing AccountingManager");
    }

    public void destroy() {
        super.destroy();
    }

    public UserInfo hello() throws ServiceException {
        try {
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)this.getThreadLocalRequest());
            logger.debug("hello()");
            UserInfo userInfo = new UserInfo(serviceCredentials.getUserName(), serviceCredentials.getGroupId(), serviceCredentials.getGroupName(), serviceCredentials.getScope(), serviceCredentials.getEmail(), serviceCredentials.getFullName());
            logger.debug("UserInfo: " + userInfo);
            return userInfo;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            logger.error("Hello(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public EnableTabs getEnableTabs() throws ServiceException {
        try {
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)this.getThreadLocalRequest());
            logger.debug("getEnableTabs()");
            boolean isRootScope = false;
            LiferayGroupManager groupManagement = new LiferayGroupManager();
            isRootScope = groupManagement.isRootVO(groupManagement.getGroupIdFromInfrastructureScope(serviceCredentials.getScope()));
            logger.debug("RootScope: " + isRootScope);
            EnableTabs enableTabs = BuildEnableTabs.build((String)serviceCredentials.getScope(), (boolean)isRootScope);
            logger.debug("EnableTabs: " + enableTabs);
            return enableTabs;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getEnableTabs(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public Long getClientMonitorTimeout() throws ServiceException {
        try {
            SessionUtil.getServiceCredentials((HttpServletRequest)this.getThreadLocalRequest());
            ServletContext sc = this.getServletContext();
            Long timeout = (Long)sc.getAttribute("ACCOUNTING_CLIENT_MONITOR_TIME_OUT_PERIODMILLIS");
            logger.debug("Accounting Client Monitor Time Out in milliseconds: " + timeout);
            return timeout;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getClientMonitorTimeout(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public SeriesResponse getSeriesInCache(AccountingType accountingType, SeriesRequest seriesRequest) throws ServiceException {
        try {
            HttpServletRequest httpRequest = this.getThreadLocalRequest();
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)httpRequest);
            logger.debug("getSeriesInCache(): " + accountingType);
            String key = new String(serviceCredentials.getScope() + "_" + accountingType.name() + "_" + seriesRequest.toString());
            logger.info("Search Accounting data in Cache with key: " + key);
            ServletContext sc = this.getServletContext();
            AccountingCache accountingCache = (AccountingCache)sc.getAttribute("ACCOUNTING_CACHE");
            logger.debug("Accounting Cache retrieved in Servlet: " + accountingCache);
            SeriesResponse seriesResponse = accountingCache.getSeries(key);
            if (seriesResponse == null) {
                logger.info("Accounting no data in Cache retrieved, call Service");
            } else {
                logger.info("Accounting use data in Cache");
            }
            AccountingStateData accountingStateData = new AccountingStateData(accountingType, seriesRequest, seriesResponse);
            SessionUtil.setAccountingStateData((HttpSession)httpRequest.getSession(), (ServiceCredentials)serviceCredentials, (AccountingType)accountingType, (AccountingStateData)accountingStateData);
            logger.debug("serriesResponse: " + seriesResponse);
            return seriesResponse;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            logger.error("getSeries(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public String getSeries(AccountingType accountingType, SeriesRequest seriesRequest) throws ServiceException {
        try {
            HttpServletRequest httpRequest = this.getThreadLocalRequest();
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)httpRequest);
            logger.debug("getSeries(): " + accountingType);
            String operationId = UUID.randomUUID().toString();
            logger.info("Accounting Task Operation Id: " + operationId);
            logger.info("Session Id: " + httpRequest.getSession());
            TaskRequest taskRequest = new TaskRequest(operationId, httpRequest.getSession(), serviceCredentials, accountingType, seriesRequest);
            ServletContext appScope = httpRequest.getServletContext();
            Queue queue = (Queue)appScope.getAttribute("TASK_REQUEST_QUEUE");
            queue.add(taskRequest);
            logger.debug("operationId: " + operationId);
            return operationId;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            logger.error("getSeries(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public SeriesResponse operationMonitor(String operationId) throws ServiceException {
        try {
            HttpServletRequest httpRequest = this.getThreadLocalRequest();
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)httpRequest);
            HashMap taskWrapperMap = SessionUtil.getTaskWrapperMap((HttpSession)httpRequest.getSession(), (ServiceCredentials)serviceCredentials);
            if (taskWrapperMap == null) {
                return null;
            }
            if (taskWrapperMap.containsKey(operationId)) {
                TaskWrapper taskWrapper = (TaskWrapper)taskWrapperMap.get(operationId);
                if (taskWrapper.getTaskStatus() != null) {
                    switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$server$util$TaskStatus[taskWrapper.getTaskStatus().ordinal()]) {
                        case 1: 
                        case 2: {
                            return taskWrapper.getSeriesResponse();
                        }
                        case 3: {
                            taskWrapperMap.remove(operationId);
                            return taskWrapper.getSeriesResponse();
                        }
                        case 4: {
                            taskWrapperMap.remove(operationId);
                            String errorMsg = "" + taskWrapper.getErrorMessage();
                            logger.error(errorMsg);
                            throw new ServiceException(errorMsg);
                        }
                    }
                    return taskWrapper.getSeriesResponse();
                }
                return null;
            }
            return null;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            logger.error("Operation Monitor(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public ArrayList<FilterKey> getFilterKeys(AccountingType accountingType) throws ServiceException {
        try {
            SessionUtil.getServiceCredentials((HttpServletRequest)this.getThreadLocalRequest());
            AccountingCaller accountingCaller = new AccountingCaller();
            ArrayList filterKeys = accountingCaller.getFilterKeys(accountingType);
            return filterKeys;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getFilterKeys(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public FilterValuesResponse getFilterValues(FilterValuesRequest filterValuesRequest) throws ServiceException {
        try {
            HttpServletRequest httpRequest = this.getThreadLocalRequest();
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)httpRequest);
            String key = new String(serviceCredentials.getScope() + "_" + filterValuesRequest.toString());
            logger.info("Search Accounting filter values in Cache with key: " + key);
            ServletContext sc = this.getServletContext();
            AccountingCache accountingCache = (AccountingCache)sc.getAttribute("ACCOUNTING_CACHE");
            logger.debug("Accounting Cache retrieved in Servlet: " + accountingCache);
            FilterValuesResponse filterValuesResponse = accountingCache.getFilterValues(key);
            if (filterValuesResponse == null || filterValuesResponse.getFilterValues() == null || filterValuesResponse.getFilterValues().isEmpty()) {
                AccountingCaller accountingCaller = new AccountingCaller();
                filterValuesResponse = accountingCaller.getFilterValues(filterValuesRequest);
                if (filterValuesResponse.getFilterValues() != null && !filterValuesResponse.getFilterValues().isEmpty()) {
                    accountingCache.putFilterValues(key, filterValuesResponse);
                }
                logger.info("Accounting no filter values in Cache retrieved, call Service");
            } else {
                logger.info("Accounting use filter values in Cache");
            }
            return filterValuesResponse;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getFilterValues(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public Spaces getSpaces() throws ServiceException {
        try {
            HttpServletRequest httpRequest = this.getThreadLocalRequest();
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)httpRequest);
            AccountingCaller accountingCaller = new AccountingCaller();
            Spaces categories = accountingCaller.getSpaces();
            return categories;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getCategories(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public Context getContext() throws ServiceException {
        try {
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)this.getThreadLocalRequest());
            Context context = SessionUtil.getContext((ServiceCredentials)serviceCredentials);
            logger.debug("getContext(): " + context);
            return context;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getContext(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public Boolean isRootScope() throws ServiceException {
        try {
            logger.debug("isRootScope()");
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)this.getThreadLocalRequest());
            LiferayGroupManager groupManagement = new LiferayGroupManager();
            Boolean isRoot = groupManagement.isRootVO(groupManagement.getGroupIdFromInfrastructureScope(serviceCredentials.getScope()));
            logger.debug("RootScope: " + isRoot);
            return isRoot;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("isRoot(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public ItemDescription saveCSVOnWorkspace(AccountingType accountingType) throws ServiceException {
        try {
            HttpServletRequest httpRequest = this.getThreadLocalRequest();
            ServiceCredentials serviceCredentials = SessionUtil.getServiceCredentials((HttpServletRequest)httpRequest);
            logger.debug("SaveDataOnWorkspace(): " + accountingType);
            AccountingStateData accountingStateData = SessionUtil.getAccountingStateData((HttpSession)httpRequest.getSession(), (ServiceCredentials)serviceCredentials, (AccountingType)accountingType);
            if (accountingStateData == null) {
                logger.error("No series present in session for thi accounting type: " + accountingType);
                throw new ServiceException("No series present in session for thi accounting type: " + accountingType);
            }
            CSVManager csvManager = new CSVManager(serviceCredentials.getUserName());
            ItemDescription itemDescription = csvManager.saveOnWorkspace(accountingStateData);
            return itemDescription;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            logger.error("SaveDataOnWorkspace(): " + e.getLocalizedMessage(), e);
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }
}

