/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.maindata.charts.storage;

import com.allen_sauer.gwt.log.client.Log;
import com.github.highcharts4gwt.client.view.widget.HighchartsLayoutPanel;
import com.github.highcharts4gwt.model.array.api.Array;
import com.github.highcharts4gwt.model.array.api.ArrayNumber;
import com.github.highcharts4gwt.model.array.api.ArrayString;
import com.github.highcharts4gwt.model.factory.jso.JsoHighchartsOptionFactory;
import com.github.highcharts4gwt.model.highcharts.option.api.ChartOptions;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesArea;
import com.github.highcharts4gwt.model.highcharts.option.api.SeriesColumn;
import com.github.highcharts4gwt.model.highcharts.option.api.seriesarea.point.ClickHandler;
import com.github.highcharts4gwt.model.highcharts.option.api.seriescolumn.Data;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.menu.Menu;
import com.sencha.gxt.widget.core.client.menu.MenuItem;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.Date;
import org.gcube.portlets.admin.accountingmanager.client.event.ExportRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ByteUnitMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.ChartTimeMeasure;
import org.gcube.portlets.admin.accountingmanager.client.maindata.charts.utils.StorageChartMeasure;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingClientStateData;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriod;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingPeriodMode;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesStorage;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.storage.SeriesStorageData;
import org.gcube.portlets.admin.accountingmanager.shared.export.ExportType;

public class StorageChartBasicPanel
extends SimpleContainer {
    private static final String DATA_VOLUME_UNIT = "Data Volume Unit";
    private DateTimeFormat dtf = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.YEAR_MONTH_DAY);
    private EventBus eventBus;
    private AccountingClientStateData accountingStateData;
    private HighchartsLayoutPanel highchartsLayoutPanel;
    private MenuItem downloadCSVItem;
    private MenuItem downloadXMLItem;
    private MenuItem downloadJSONItem;
    private MenuItem downloadPNGItem;
    private MenuItem downloadJPGItem;
    private MenuItem downloadPDFItem;
    private MenuItem downloadSVGItem;
    private MenuItem kBItem;
    private MenuItem MBItem;
    private MenuItem GBItem;
    private MenuItem TBItem;
    private long unitMeasure = ByteUnitMeasure.getMegaByteDimForStorage();
    private String unitMeasureLabel = "MB";
    private TextButton unitButton;
    private ChartOptions options;
    private VerticalLayoutContainer vert;

    public StorageChartBasicPanel(EventBus eventBus, AccountingClientStateData accountingStateData) {
        this.eventBus = eventBus;
        this.accountingStateData = accountingStateData;
        this.forceLayoutOnResize = true;
        this.create();
    }

    private void create() {
        ToolBar toolBar = new ToolBar();
        toolBar.setSpacing(2);
        TextButton downloadButton = new TextButton("Download", AccountingManagerResources.INSTANCE.accountingDownload24());
        downloadButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        downloadButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        downloadButton.setMenu(this.createDownloadMenu());
        this.unitButton = new TextButton(DATA_VOLUME_UNIT, AccountingManagerResources.INSTANCE.accountingUnitMB24());
        this.unitButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.unitButton.setArrowAlign(ButtonCell.ButtonArrowAlign.RIGHT);
        this.unitButton.setMenu(this.createUnitMenu());
        toolBar.add((IsWidget)downloadButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        toolBar.add((IsWidget)this.unitButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.createChart();
        this.highchartsLayoutPanel = new HighchartsLayoutPanel();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.vert = new VerticalLayoutContainer();
        this.vert.add((IsWidget)toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        this.vert.add((IsWidget)this.highchartsLayoutPanel, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        this.add((Widget)this.vert, new MarginData(0));
    }

    private void updateChart() {
        this.createChart();
        this.highchartsLayoutPanel.renderChart(this.options);
        this.forceLayout();
    }

    private Menu createUnitMenu() {
        Menu menuUnit = new Menu();
        this.kBItem = new MenuItem("KiloByte", AccountingManagerResources.INSTANCE.accountingUnitkB24());
        this.kBItem.setHeight(30);
        this.MBItem = new MenuItem("MegaByte", AccountingManagerResources.INSTANCE.accountingUnitMB24());
        this.MBItem.setHeight(30);
        this.GBItem = new MenuItem("GigaByte", AccountingManagerResources.INSTANCE.accountingUnitGB24());
        this.GBItem.setHeight(30);
        this.TBItem = new MenuItem("TeraByte", AccountingManagerResources.INSTANCE.accountingUnitTB24());
        this.TBItem.setHeight(30);
        this.kBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.MBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.GBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.TBItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuUnit.add((Widget)this.kBItem);
        menuUnit.add((Widget)this.MBItem);
        menuUnit.add((Widget)this.GBItem);
        menuUnit.add((Widget)this.TBItem);
        return menuUnit;
    }

    private Menu createDownloadMenu() {
        Menu menuDownload = new Menu();
        this.downloadCSVItem = new MenuItem("Download CSV", AccountingManagerResources.INSTANCE.accountingFileCSV24());
        this.downloadCSVItem.setHeight(30);
        this.downloadXMLItem = new MenuItem("Download XML", AccountingManagerResources.INSTANCE.accountingFileXML24());
        this.downloadXMLItem.setHeight(30);
        this.downloadJSONItem = new MenuItem("Download JSON", AccountingManagerResources.INSTANCE.accountingFileJSON24());
        this.downloadJSONItem.setHeight(30);
        this.downloadPNGItem = new MenuItem("Download PNG Image", AccountingManagerResources.INSTANCE.accountingFilePNG24());
        this.downloadPNGItem.setHeight(30);
        this.downloadJPGItem = new MenuItem("Download JPG Image", AccountingManagerResources.INSTANCE.accountingFileJPG24());
        this.downloadJPGItem.setHeight(30);
        this.downloadPDFItem = new MenuItem("Download PDF Document", AccountingManagerResources.INSTANCE.accountingFilePDF24());
        this.downloadPDFItem.setHeight(30);
        this.downloadSVGItem = new MenuItem("Download SVG Vector Image", AccountingManagerResources.INSTANCE.accountingFileSVG24());
        this.downloadSVGItem.setHeight(30);
        this.downloadCSVItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadXMLItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJSONItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPNGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadJPGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadPDFItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.downloadSVGItem.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        menuDownload.add((Widget)this.downloadCSVItem);
        menuDownload.add((Widget)this.downloadXMLItem);
        menuDownload.add((Widget)this.downloadJSONItem);
        menuDownload.add((Widget)this.downloadPNGItem);
        menuDownload.add((Widget)this.downloadJPGItem);
        menuDownload.add((Widget)this.downloadPDFItem);
        menuDownload.add((Widget)this.downloadSVGItem);
        return menuDownload;
    }

    private void onDownloadCSV() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.CSV, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void onDownloadXML() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.XML, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void onDownloadJSON() {
        ExportRequestEvent event = new ExportRequestEvent(ExportType.JSON, this.accountingStateData.getAccountingType());
        this.eventBus.fireEvent((GwtEvent)event);
    }

    public static native void onDownloadPNG(String var0);

    public static native void onDownloadJPG(String var0);

    public static native void onDownloadPDF(String var0);

    public static native void onDownloadSVG(String var0);

    private void createChart() {
        SeriesStorage seriesStorage = (SeriesStorage)this.accountingStateData.getSeriesResponse();
        if (!(seriesStorage.getSeriesStorageDefinition() instanceof SeriesStorageBasic)) {
            Log.error((String)"Invalid SeriesStorageBasic!");
            return;
        }
        SeriesStorageBasic seriesStorageBasic = (SeriesStorageBasic)seriesStorage.getSeriesStorageDefinition();
        JsoHighchartsOptionFactory highchartsFactory = new JsoHighchartsOptionFactory();
        this.options = highchartsFactory.createChartOptions();
        this.options.chart().zoomType("xy");
        this.options.exporting().buttons().contextButton().enabled(false);
        this.options.exporting().filename("AccountingStorageBasic");
        this.options.title().text("Accounting Storage");
        ArrayString colors = this.options.colors();
        String multiAxis = "[{ \"id\": \"" + StorageChartMeasure.OperationCount.name() + "\", \"labels\": {     \"format\": \"{value}\",    \"style\": {       \"color\": \"" + colors.get(1) + "\"    } }, \"title\": {     \"text\": \"" + StorageChartMeasure.OperationCount.getLabel() + "\",    \"style\": {       \"color\": \"" + colors.get(1) + "\"    } }} , { \"id\": \"" + StorageChartMeasure.DataVolume.name() + "\",  \"title\": {    \"text\": \"" + StorageChartMeasure.DataVolume.getLabel() + "\",    \"style\": {       \"color\": \"" + colors.get(0) + "\"    } }, \"labels\": {    \"format\": \"{value} " + this.unitMeasureLabel + "\",    \"style\": {       \"color\": \"" + colors.get(0) + "\"     } }, \"opposite\": \"true\"}]";
        this.options.setFieldAsJsonObject("yAxis", multiAxis);
        String fillcolor = "{\"linearGradient\": {\"x1\": 0,\"y1\": 0,\"x2\": 0,\"y2\": 1},\"stops\": [[0, \"#058DC7\"],[1, \"#FFFFFF\"]]}";
        this.options.plotOptions().area().setFieldAsJsonObject("fillColor", fillcolor).marker().radius(2.0).lineWidth(1.0).states().hover().lineWidth(1.0);
        SeriesColumn seriesOperationCount = highchartsFactory.createSeriesColumn();
        seriesOperationCount.name(StorageChartMeasure.OperationCount.getLabel());
        seriesOperationCount.color(colors.get(1));
        seriesOperationCount.type("column");
        seriesOperationCount.point().addClickHandler((com.github.highcharts4gwt.model.highcharts.option.api.seriescolumn.point.ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        SeriesArea seriesDataVolume = highchartsFactory.createSeriesArea();
        seriesDataVolume.name(StorageChartMeasure.DataVolume.getLabel());
        seriesDataVolume.color(colors.get(0));
        seriesDataVolume.yAxisAsString(StorageChartMeasure.DataVolume.name());
        seriesDataVolume.point().addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.DAILY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.HOURLY) == 0 || this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MINUTELY) == 0) {
            double minRange = ChartTimeMeasure.calculateMinRange((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            double interval = ChartTimeMeasure.calculateInterval((AccountingPeriod)this.accountingStateData.getSeriesRequest().getAccountingPeriod());
            Date dateStart = this.dtf.parse(this.accountingStateData.getSeriesRequest().getAccountingPeriod().getStartDate());
            dateStart.setTime(dateStart.getTime() + ChartTimeMeasure.timeZoneOffset() * 60000L);
            Log.debug((String)("BuildChart DateStart: " + DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_FULL).format(dateStart)));
            this.options.xAxis().type("datetime");
            this.options.xAxis().minRange(minRange);
            this.options.tooltip().xDateFormat("Selected Data");
            ArrayNumber dataOperationCount = seriesOperationCount.dataAsArrayNumber();
            seriesOperationCount.pointInterval(interval).pointStart((double)dateStart.getTime());
            ArrayNumber dataDataVolume = seriesDataVolume.dataAsArrayNumber();
            seriesDataVolume.pointInterval(interval).pointStart((double)dateStart.getTime());
            for (SeriesStorageData seriesStorageData : seriesStorageBasic.getSeries()) {
                dataOperationCount.push((double)seriesStorageData.getOperationCount().longValue());
                dataDataVolume.push((double)(seriesStorageData.getDataVolume() / this.unitMeasure));
            }
        } else {
            this.options.xAxis().type("datetime");
            if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.MONTHLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else if (this.accountingStateData.getSeriesRequest().getAccountingPeriod().getPeriod().compareTo((Enum)AccountingPeriodMode.YEARLY) == 0) {
                this.options.tooltip().xDateFormat("Selected Data");
            } else {
                this.options.tooltip().xDateFormat("Selected Data");
            }
            Array arrayDataOperationCount = seriesOperationCount.dataAsArrayObject();
            Array arrayDataVolume = seriesDataVolume.dataAsArrayObject();
            for (SeriesStorageData seriesStorageData : seriesStorageBasic.getSeries()) {
                long dateFrom1970 = seriesStorageData.getDate().getTime();
                Log.debug((String)("SeriersStorageData: " + seriesStorageData.getDate()));
                Log.debug((String)("SeriersStorageData: " + dateFrom1970));
                Data dataOperationCount = highchartsFactory.createSeriesColumnData();
                dataOperationCount.x((double)dateFrom1970);
                dataOperationCount.y((double)seriesStorageData.getOperationCount().longValue());
                arrayDataOperationCount.addToEnd((Object)dataOperationCount);
                com.github.highcharts4gwt.model.highcharts.option.api.seriesarea.Data dataVolume = highchartsFactory.createSeriesAreaData();
                dataVolume.x((double)dateFrom1970);
                dataVolume.y((double)(seriesStorageData.getDataVolume() / this.unitMeasure));
                arrayDataVolume.addToEnd((Object)dataVolume);
            }
        }
        this.options.series().addToEnd((Object)seriesOperationCount);
        this.options.series().addToEnd((Object)seriesDataVolume);
        this.options.chart().showAxes(true);
        this.options.legend().enabled(true);
    }

    static /* synthetic */ long access$002(StorageChartBasicPanel x0, long x1) {
        x0.unitMeasure = x1;
        return x0.unitMeasure;
    }

    static /* synthetic */ String access$102(StorageChartBasicPanel x0, String x1) {
        x0.unitMeasureLabel = x1;
        return x0.unitMeasureLabel;
    }

    static /* synthetic */ TextButton access$200(StorageChartBasicPanel x0) {
        return x0.unitButton;
    }

    static /* synthetic */ void access$300(StorageChartBasicPanel x0) {
        x0.updateChart();
    }

    static /* synthetic */ void access$400(StorageChartBasicPanel x0) {
        x0.onDownloadCSV();
    }

    static /* synthetic */ void access$500(StorageChartBasicPanel x0) {
        x0.onDownloadXML();
    }

    static /* synthetic */ void access$600(StorageChartBasicPanel x0) {
        x0.onDownloadJSON();
    }

    static /* synthetic */ HighchartsLayoutPanel access$700(StorageChartBasicPanel x0) {
        return x0.highchartsLayoutPanel;
    }
}

