/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.client.filters;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.cell.core.client.ButtonCell;
import com.sencha.gxt.cell.core.client.form.ComboBoxCell;
import com.sencha.gxt.core.client.IdentityValueProvider;
import com.sencha.gxt.core.client.Style;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.core.client.util.Margins;
import com.sencha.gxt.core.client.util.ToggleGroup;
import com.sencha.gxt.data.shared.LabelProvider;
import com.sencha.gxt.data.shared.ListStore;
import com.sencha.gxt.data.shared.ModelKeyProvider;
import com.sencha.gxt.dnd.core.client.DND;
import com.sencha.gxt.dnd.core.client.DndDragStartEvent;
import com.sencha.gxt.dnd.core.client.GridDragSource;
import com.sencha.gxt.dnd.core.client.GridDropTarget;
import com.sencha.gxt.widget.core.client.button.ButtonBar;
import com.sencha.gxt.widget.core.client.button.TextButton;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.HBoxLayoutContainer;
import com.sencha.gxt.widget.core.client.container.MarginData;
import com.sencha.gxt.widget.core.client.container.SimpleContainer;
import com.sencha.gxt.widget.core.client.container.VerticalLayoutContainer;
import com.sencha.gxt.widget.core.client.event.BeforeStartEditEvent;
import com.sencha.gxt.widget.core.client.event.CancelEditEvent;
import com.sencha.gxt.widget.core.client.event.CompleteEditEvent;
import com.sencha.gxt.widget.core.client.event.SelectEvent;
import com.sencha.gxt.widget.core.client.form.ComboBox;
import com.sencha.gxt.widget.core.client.form.FieldLabel;
import com.sencha.gxt.widget.core.client.form.FieldSet;
import com.sencha.gxt.widget.core.client.form.IntegerSpinnerField;
import com.sencha.gxt.widget.core.client.form.IsField;
import com.sencha.gxt.widget.core.client.form.Radio;
import com.sencha.gxt.widget.core.client.form.StringComboBox;
import com.sencha.gxt.widget.core.client.form.Validator;
import com.sencha.gxt.widget.core.client.form.validator.EmptyValidator;
import com.sencha.gxt.widget.core.client.grid.CheckBoxSelectionModel;
import com.sencha.gxt.widget.core.client.grid.ColumnConfig;
import com.sencha.gxt.widget.core.client.grid.ColumnModel;
import com.sencha.gxt.widget.core.client.grid.Grid;
import com.sencha.gxt.widget.core.client.grid.GridSelectionModel;
import com.sencha.gxt.widget.core.client.grid.editing.GridRowEditing;
import com.sencha.gxt.widget.core.client.toolbar.ToolBar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.portlets.admin.accountingmanager.client.event.AccountingPeriodEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.AccountingPeriodRequestEvent;
import org.gcube.portlets.admin.accountingmanager.client.event.StateChangeEvent;
import org.gcube.portlets.admin.accountingmanager.client.filters.ActiveFiltersPanel;
import org.gcube.portlets.admin.accountingmanager.client.monitor.AccountingMonitor;
import org.gcube.portlets.admin.accountingmanager.client.properties.AccountingFilterProperties;
import org.gcube.portlets.admin.accountingmanager.client.properties.GenresDataProperties;
import org.gcube.portlets.admin.accountingmanager.client.properties.GenresDataPropertiesCombo;
import org.gcube.portlets.admin.accountingmanager.client.resource.AccountingManagerResources;
import org.gcube.portlets.admin.accountingmanager.client.rpc.AccountingManagerServiceAsync;
import org.gcube.portlets.admin.accountingmanager.client.state.AccountingClientStateData;
import org.gcube.portlets.admin.accountingmanager.client.util.UtilsGXT3;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilter;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterBasic;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterContext;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterDefinition;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterSpaces;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingFilterTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.ChartType;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.GenresData;
import org.gcube.portlets.admin.accountingmanager.shared.data.Spaces;

public class ActiveFiltersPanel
extends SimpleContainer {
    private static final int TOP_NUMBER_DEFAULT = 5;
    private static final int TOP_NUMBER_MAX = 30;
    private static final int TOP_NUMBER_MIN = 1;
    private EventBus eventBus;
    private Grid<AccountingFilter> gridFilter;
    private ListStore<AccountingFilter> storeFilter;
    private Grid<GenresData> gridGenres;
    private ListStore<GenresData> storeGenres;
    private CheckBoxSelectionModel<GenresData> smGenres;
    private ColumnConfig<GenresData, String> labelGenresCol;
    private boolean addStatus;
    private AccountingClientStateData accountingStateData;
    private ListStore<FilterKey> storeComboFilterKey;
    private ComboBox<FilterKey> comboFilterKey;
    private ListStore<String> storeComboFilterValue;
    private StringComboBox comboFilterValue;
    private GridRowEditing<AccountingFilter> editing;
    private TextButton addButton;
    private int seq;
    private FieldLabel comboChartTypeLabel;
    private ListStore<ChartType> storeComboChartType;
    private ComboBox<ChartType> comboChartType;
    private ListStore<GenresData> storeComboScope;
    private ComboBox<GenresData> comboScope;
    private FieldLabel comboScopeLabel;
    private ListStore<FilterKey> storeComboTopFilterKey;
    private ComboBox<FilterKey> comboTopFilterKey;
    private FieldLabel comboTopFilterKeyLabel;
    private ToolBar toolBar;
    private FieldLabel showOthersLabel;
    private FieldLabel noContextLabel;
    private IntegerSpinnerField topNumber;
    private FieldLabel topNumberLabel;
    private FilterKey filterKey;
    private boolean cancelValue;
    private AccountingMonitor accountingMonitor;
    private Radio showOthersYes;
    private Radio showOthersNo;
    private ToggleGroup showOthersToggle;
    private Radio noContextYes;
    private Radio noContextNo;
    private ToggleGroup noContextToggle;

    public ActiveFiltersPanel(EventBus eventBus) {
        Log.debug((String)"ActiveFiltersPanel");
        this.eventBus = eventBus;
        this.init();
        this.create();
        this.bindToEvents();
    }

    private void init() {
    }

    private void create() {
        AccountingFilterProperties props = (AccountingFilterProperties)GWT.create(AccountingFilterProperties.class);
        ColumnConfig keyColumn = new ColumnConfig(props.filterKey(), 130, "Key");
        keyColumn.setMenuDisabled(true);
        keyColumn.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ColumnConfig valueColumn = new ColumnConfig(props.filterValue(), 130, "Value");
        valueColumn.setMenuDisabled(true);
        valueColumn.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<ColumnConfig> l = new ArrayList<ColumnConfig>();
        l.add(keyColumn);
        l.add(valueColumn);
        ColumnModel columns = new ColumnModel(l);
        this.storeFilter = new ListStore(props.id());
        GridSelectionModel sm = new GridSelectionModel();
        sm.setSelectionMode(Style.SelectionMode.SINGLE);
        this.gridFilter = new Grid(this.storeFilter, columns);
        this.gridFilter.setSelectionModel(sm);
        this.gridFilter.getView().setStripeRows(true);
        this.gridFilter.getView().setColumnLines(true);
        this.gridFilter.getView().setAutoFill(true);
        this.gridFilter.setBorders(true);
        this.gridFilter.setColumnReordering(false);
        this.gridFilter.getView().setAutoExpandColumn(valueColumn);
        this.gridFilter.getView().setSortingEnabled(false);
        GridDragSource ds = new GridDragSource(this.gridFilter);
        ds.addDragStartHandler((DndDragStartEvent.DndDragStartHandler)new /* Unavailable Anonymous Inner Class!! */);
        GridDropTarget dt = new GridDropTarget(this.gridFilter);
        dt.setFeedback(DND.Feedback.BOTH);
        dt.setAllowSelfAsSource(true);
        FilterKeyPropertiesCombo filterKeyPropertiesCombo = (FilterKeyPropertiesCombo)GWT.create(FilterKeyPropertiesCombo.class);
        this.storeComboFilterKey = new ListStore(filterKeyPropertiesCombo.id());
        this.comboFilterKey = new ComboBox(this.storeComboFilterKey, filterKeyPropertiesCombo.key());
        this.comboFilterKey.setClearValueOnParseError(false);
        this.comboFilterKey.setEditable(false);
        this.comboFilterKey.addValidator((Validator)new /* Unavailable Anonymous Inner Class!! */);
        this.comboFilterKey.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.addHandlersForComboFilterKey(filterKeyPropertiesCombo.key());
        this.storeComboFilterValue = new ListStore((ModelKeyProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.comboFilterValue = new StringComboBox();
        this.comboFilterValue.setStore(this.storeComboFilterValue);
        this.comboFilterValue.setClearValueOnParseError(false);
        this.comboFilterValue.setEditable(true);
        this.comboFilterValue.setForceSelection(false);
        this.comboFilterValue.addValidator((Validator)new EmptyValidator());
        this.comboFilterValue.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.editing = new GridRowEditing(this.gridFilter);
        this.editing.addEditor(keyColumn, (IsField)this.comboFilterKey);
        this.editing.addEditor(valueColumn, (IsField)this.comboFilterValue);
        this.addButton = new TextButton("Add Filter");
        this.addButton.setIcon(AccountingManagerResources.INSTANCE.accountingFilter24());
        this.addButton.setIconAlign(ButtonCell.IconAlign.RIGHT);
        this.addButton.setToolTip("Add Filter");
        this.addButton.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        TextButton deleteBtn = new TextButton("Delete");
        deleteBtn.addSelectHandler((SelectEvent.SelectHandler)new /* Unavailable Anonymous Inner Class!! */);
        ButtonBar buttonBar = this.editing.getButtonBar();
        buttonBar.add((Widget)deleteBtn);
        this.editing.addBeforeStartEditHandler((BeforeStartEditEvent.BeforeStartEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editing.addCancelEditHandler((CancelEditEvent.CancelEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.editing.addCompleteEditHandler((CompleteEditEvent.CompleteEditHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.toolBar = new ToolBar();
        this.toolBar.add((IsWidget)this.addButton, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.storeComboChartType = new ListStore((ModelKeyProvider)new /* Unavailable Anonymous Inner Class!! */);
        12 comboChartTypeLabelProvider = new /* Unavailable Anonymous Inner Class!! */;
        GenresDataProperties propsGenresData = (GenresDataProperties)GWT.create(GenresDataProperties.class);
        IdentityValueProvider identity = new IdentityValueProvider();
        this.smGenres = new CheckBoxSelectionModel((ValueProvider)identity);
        this.labelGenresCol = new ColumnConfig(propsGenresData.label(), 356, "Genres");
        this.labelGenresCol.setCell((Cell)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<ColumnConfig> lGenres = new ArrayList<ColumnConfig>();
        lGenres.add(this.smGenres.getColumn());
        lGenres.add(this.labelGenresCol);
        ColumnModel cmGenresData = new ColumnModel(lGenres);
        this.storeGenres = new ListStore(propsGenresData.id());
        this.gridGenres = new Grid(this.storeGenres, cmGenresData);
        sm.setSelectionMode(Style.SelectionMode.MULTI);
        this.gridGenres.setHeight("130px");
        this.gridGenres.setSelectionModel((GridSelectionModel)this.smGenres);
        this.gridGenres.getView().setStripeRows(true);
        this.gridGenres.getView().setColumnLines(true);
        this.gridGenres.getView().setAutoFill(true);
        this.gridGenres.setBorders(true);
        this.gridGenres.setColumnReordering(false);
        this.gridGenres.getView().setAutoExpandColumn(this.labelGenresCol);
        this.gridGenres.getView().setSortingEnabled(true);
        this.comboChartType = new ComboBox(this.storeComboChartType, (LabelProvider)comboChartTypeLabelProvider);
        this.comboChartType.setClearValueOnParseError(false);
        this.comboChartType.setEditable(false);
        this.comboChartType.setForceSelection(true);
        this.comboChartType.setValue((Object)ChartType.Basic);
        this.comboChartType.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.addHandlersForComboChartType((LabelProvider)comboChartTypeLabelProvider);
        this.comboChartTypeLabel = new FieldLabel((IsWidget)this.comboChartType, "Chart");
        GenresDataPropertiesCombo genresDataPropertiesCombo = (GenresDataPropertiesCombo)GWT.create(GenresDataPropertiesCombo.class);
        this.storeComboScope = new ListStore(genresDataPropertiesCombo.id());
        this.comboScope = new ComboBox(this.storeComboScope, genresDataPropertiesCombo.label());
        this.comboScope.setClearValueOnParseError(false);
        this.comboScope.setTypeAhead(true);
        this.comboScope.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.comboScope.getListView().addStyleName(AccountingManagerResources.INSTANCE.accountingManagerCSS().getScopeListView());
        this.addHandlersForComboScope(genresDataPropertiesCombo.label());
        this.comboScopeLabel = new FieldLabel((IsWidget)this.comboScope, "Scope");
        this.storeComboTopFilterKey = new ListStore(filterKeyPropertiesCombo.id());
        this.comboTopFilterKey = new ComboBox(this.storeComboTopFilterKey, filterKeyPropertiesCombo.key());
        this.comboTopFilterKey.setClearValueOnParseError(false);
        this.comboTopFilterKey.setEditable(false);
        this.comboTopFilterKey.setTriggerAction(ComboBoxCell.TriggerAction.ALL);
        this.addHandlersForComboTopFilterKey(filterKeyPropertiesCombo.key());
        this.comboTopFilterKeyLabel = new FieldLabel((IsWidget)this.comboTopFilterKey, "Key");
        this.showOthersYes = new Radio();
        this.showOthersYes.setBoxLabel("Yes");
        this.showOthersNo = new Radio();
        this.showOthersNo.setBoxLabel("No");
        this.showOthersNo.setValue(Boolean.valueOf(true));
        this.showOthersToggle = new ToggleGroup();
        this.showOthersToggle.add((HasValue)this.showOthersYes);
        this.showOthersToggle.add((HasValue)this.showOthersNo);
        this.showOthersToggle.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        HBoxLayoutContainer hp = new HBoxLayoutContainer();
        hp.setHBoxLayoutAlign(HBoxLayoutContainer.HBoxLayoutAlign.MIDDLE);
        hp.setPack(BoxLayoutContainer.BoxLayoutPack.START);
        hp.add((IsWidget)this.showOthersYes, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        hp.add((IsWidget)this.showOthersNo, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.showOthersLabel = new FieldLabel((IsWidget)hp, "Show Others");
        this.noContextYes = new Radio();
        this.noContextYes.setBoxLabel("Yes");
        this.noContextNo = new Radio();
        this.noContextNo.setBoxLabel("No");
        this.noContextNo.setValue(Boolean.valueOf(true));
        this.noContextToggle = new ToggleGroup();
        this.noContextToggle.add((HasValue)this.noContextYes);
        this.noContextToggle.add((HasValue)this.noContextNo);
        this.noContextToggle.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        HBoxLayoutContainer hpNoContext = new HBoxLayoutContainer();
        hpNoContext.setHBoxLayoutAlign(HBoxLayoutContainer.HBoxLayoutAlign.MIDDLE);
        hpNoContext.setPack(BoxLayoutContainer.BoxLayoutPack.START);
        hpNoContext.add((IsWidget)this.noContextYes, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        hpNoContext.add((IsWidget)this.noContextNo, new BoxLayoutContainer.BoxLayoutData(new Margins(0)));
        this.noContextLabel = new FieldLabel((IsWidget)hpNoContext, "No Context");
        this.topNumber = new IntegerSpinnerField();
        this.topNumber.setMaxValue((Number)30);
        this.topNumber.setMinValue((Number)1);
        this.topNumber.setAllowNegative(false);
        this.topNumber.setAllowBlank(false);
        this.topNumber.setValue((Object)5);
        this.topNumber.setEditable(false);
        this.topNumberLabel = new FieldLabel((IsWidget)this.topNumber, "Number");
        VerticalLayoutContainer vlc = new VerticalLayoutContainer();
        vlc.add((IsWidget)this.comboChartTypeLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.comboScopeLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.gridGenres, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.noContextLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.comboTopFilterKeyLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.showOthersLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.topNumberLabel, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.toolBar, new VerticalLayoutContainer.VerticalLayoutData(1.0, -1.0, new Margins(0)));
        vlc.add((IsWidget)this.gridFilter, new VerticalLayoutContainer.VerticalLayoutData(1.0, 1.0, new Margins(0)));
        FieldSet fieldSet = new FieldSet();
        fieldSet.setHeight("360px");
        fieldSet.setHeadingHtml("<b>Active Filters</b>");
        fieldSet.setCollapsible(false);
        fieldSet.add((Widget)vlc);
        this.add((Widget)fieldSet, new MarginData(0));
        this.comboChartTypeLabel.setVisible(false);
        this.comboScopeLabel.setVisible(false);
        this.gridGenres.setVisible(false);
        this.noContextLabel.setVisible(false);
        this.comboTopFilterKeyLabel.setVisible(false);
        this.showOthersLabel.setVisible(false);
        this.topNumberLabel.setVisible(false);
    }

    private void bindToEvents() {
        this.eventBus.addHandler(StateChangeEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.eventBus.addHandler(AccountingPeriodEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doStateChangeCommand(StateChangeEvent event) {
        if (event.getStateChangeType() == null) {
            return;
        }
        switch (23.$SwitchMap$org$gcube$portlets$admin$accountingmanager$client$type$StateChangeType[event.getStateChangeType().ordinal()]) {
            case 1: {
                this.onRestoreStateChange(event);
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void onRestoreStateChange(StateChangeEvent event) {
        Log.debug((String)("onRestoreStateChange: " + event));
        if (event.getAccountingStateData() != null) {
            this.accountingStateData = event.getAccountingStateData();
            if (this.accountingStateData.getAccountingType() != null) {
                switch (23.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[this.accountingStateData.getAccountingType().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        ArrayList chartsTypeForDefault = new ArrayList(ChartType.asList());
                        Log.debug((String)("ChartsType: " + chartsTypeForDefault));
                        chartsTypeForDefault.remove(ChartType.Spaces);
                        Log.debug((String)("ChartsType after remove: " + chartsTypeForDefault));
                        this.storeComboChartType.clear();
                        this.storeComboChartType.addAll(chartsTypeForDefault);
                        this.storeComboChartType.commitChanges();
                        this.comboChartTypeLabel.setVisible(true);
                        break;
                    }
                    case 6: {
                        ArrayList<ChartType> chartsTypeForSpace = new ArrayList<ChartType>();
                        chartsTypeForSpace.add(ChartType.Spaces);
                        Log.debug((String)("ChartsType: " + chartsTypeForSpace));
                        this.storeComboChartType.clear();
                        this.storeComboChartType.addAll(chartsTypeForSpace);
                        this.storeComboChartType.commitChanges();
                        this.comboChartTypeLabel.setVisible(false);
                        break;
                    }
                    default: {
                        this.storeComboChartType.clear();
                        this.storeComboChartType.commitChanges();
                        this.comboChartTypeLabel.setVisible(false);
                        break;
                    }
                }
            } else {
                this.storeComboChartType.clear();
                this.storeComboChartType.commitChanges();
                this.comboChartTypeLabel.setVisible(false);
            }
            this.changeActiveFilters();
        } else {
            this.accountingStateData = null;
            this.seq = 0;
        }
        Log.debug((String)("Set seq to: " + this.seq));
        this.forceLayout();
    }

    private void changeActiveFilters() {
        this.storeComboFilterKey.clear();
        this.storeComboFilterKey.addAll((Collection)this.accountingStateData.getAvailableFilterKeys());
        this.storeComboFilterKey.commitChanges();
        this.storeComboTopFilterKey.clear();
        this.storeComboTopFilterKey.addAll((Collection)this.accountingStateData.getAvailableFilterKeys());
        this.storeComboTopFilterKey.commitChanges();
        ChartType chartType = this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition().getChartType();
        switch (23.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[chartType.ordinal()]) {
            case 1: {
                this.changeActiveFiltersForBasic();
                break;
            }
            case 2: {
                this.changeActiveFiltersForTop();
                break;
            }
            case 3: {
                this.changeActiveFiltersForContext();
                break;
            }
            case 4: {
                this.changeActiveFiltersForSpaces();
                break;
            }
            default: {
                this.changeActiveFiltersForBasic();
            }
        }
    }

    private void changeActiveFiltersForBasic() {
        if (this.accountingStateData.getSeriesRequest() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() instanceof AccountingFilterBasic) {
            AccountingFilterBasic accountingFilterBasic = (AccountingFilterBasic)this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition();
            if (this.accountingStateData.getAvailableContext().getContexts() != null && !this.accountingStateData.getAvailableContext().getContexts().isEmpty()) {
                ArrayList scopesAvailables = this.accountingStateData.getAvailableContext().getContexts();
                ArrayList<GenresData> scopes = new ArrayList<GenresData>();
                for (String scopeAvailable : scopesAvailables) {
                    scopes.add(new GenresData(scopeAvailable));
                }
                this.storeComboScope.clear();
                this.storeComboScope.addAll(scopes);
                this.storeComboScope.commitChanges();
                if (accountingFilterBasic.getScope() != null && !accountingFilterBasic.getScope().isEmpty()) {
                    this.comboScope.setValue((Object)new GenresData(accountingFilterBasic.getScope()));
                } else {
                    this.comboScope.setValue(this.storeComboScope.get(0));
                }
            } else {
                this.storeComboScope.clear();
                this.storeComboScope.commitChanges();
            }
            if (accountingFilterBasic.getFilters() != null) {
                ArrayList filters = accountingFilterBasic.getFilters();
                this.storeFilter.clear();
                this.storeFilter.addAll((Collection)filters);
                this.seq = 0;
                for (AccountingFilter filter : filters) {
                    if (filter.getId() <= this.seq) continue;
                    this.seq = filter.getId();
                }
                this.storeFilter.commitChanges();
            } else {
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
            }
            if (this.accountingStateData.getRootScope().booleanValue()) {
                this.noContextToggle.reset();
                if (accountingFilterBasic.isNoContext()) {
                    this.noContextYes.setValue(Boolean.valueOf(true));
                } else {
                    this.noContextNo.setValue(Boolean.valueOf(true));
                }
                this.noContextLabel.setVisible(true);
            } else {
                this.noContextToggle.reset();
                this.noContextNo.setValue(Boolean.valueOf(true));
                this.noContextLabel.setVisible(false);
            }
        } else {
            this.storeFilter.clear();
            this.storeFilter.commitChanges();
            this.seq = 0;
            if (this.accountingStateData.getAvailableContext().getContexts() != null && !this.accountingStateData.getAvailableContext().getContexts().isEmpty()) {
                ArrayList scopesAvailables = this.accountingStateData.getAvailableContext().getContexts();
                ArrayList<GenresData> scopes = new ArrayList<GenresData>();
                for (String scopeAvailable : scopesAvailables) {
                    scopes.add(new GenresData(scopeAvailable));
                }
                this.storeComboScope.clear();
                this.storeComboScope.addAll(scopes);
                this.storeComboScope.commitChanges();
                this.comboScope.setValue(this.storeComboScope.get(0));
            } else {
                this.storeComboScope.clear();
                this.storeComboScope.commitChanges();
            }
            if (this.accountingStateData.getRootScope().booleanValue()) {
                this.noContextToggle.reset();
                this.noContextNo.setValue(Boolean.valueOf(true));
                this.noContextLabel.setVisible(true);
            } else {
                this.noContextToggle.reset();
                this.noContextNo.setValue(Boolean.valueOf(true));
                this.noContextLabel.setVisible(false);
            }
        }
        this.comboChartType.setValue((Object)ChartType.Basic);
        this.comboScopeLabel.setVisible(true);
        this.gridGenres.setVisible(false);
        this.comboTopFilterKey.reset();
        this.comboTopFilterKeyLabel.setVisible(false);
        this.showOthersToggle.reset();
        this.showOthersNo.setValue(Boolean.valueOf(true));
        this.showOthersLabel.setVisible(false);
        this.topNumber.reset();
        this.topNumberLabel.setVisible(false);
        this.forceLayout();
    }

    private void changeActiveFiltersForTop() {
        if (this.accountingStateData.getSeriesRequest() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() instanceof AccountingFilterTop) {
            AccountingFilterTop accountingFilterTop = (AccountingFilterTop)this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition();
            if (this.accountingStateData.getAvailableContext().getContexts() != null && !this.accountingStateData.getAvailableContext().getContexts().isEmpty()) {
                ArrayList scopesAvailables = this.accountingStateData.getAvailableContext().getContexts();
                ArrayList<GenresData> scopes = new ArrayList<GenresData>();
                for (String scopeAvailable : scopesAvailables) {
                    scopes.add(new GenresData(scopeAvailable));
                }
                this.storeComboScope.clear();
                this.storeComboScope.addAll(scopes);
                this.storeComboScope.commitChanges();
                if (accountingFilterTop.getScope() != null && !accountingFilterTop.getScope().isEmpty()) {
                    this.comboScope.setValue((Object)new GenresData(accountingFilterTop.getScope()));
                } else {
                    this.comboScope.setValue(this.storeComboScope.get(0));
                }
            } else {
                this.storeComboScope.clear();
                this.storeComboScope.commitChanges();
                this.comboScope.reset();
            }
            if (accountingFilterTop.getFilterKey() != null) {
                this.comboTopFilterKey.setValue((Object)accountingFilterTop.getFilterKey());
                this.topNumber.setValue((Object)accountingFilterTop.getTopNumber());
                if (accountingFilterTop.getFilters() != null) {
                    ArrayList filters = accountingFilterTop.getFilters();
                    this.storeFilter.clear();
                    this.storeFilter.addAll((Collection)filters);
                    this.seq = 0;
                    for (AccountingFilter filter : filters) {
                        if (filter.getId() <= this.seq) continue;
                        this.seq = filter.getId();
                    }
                    this.storeFilter.commitChanges();
                } else {
                    this.storeFilter.clear();
                    this.storeFilter.commitChanges();
                    this.seq = 0;
                }
            } else {
                this.comboTopFilterKey.reset();
                this.showOthersToggle.reset();
                this.showOthersNo.setValue(Boolean.valueOf(true));
                this.topNumber.reset();
                this.topNumber.setValue((Object)5);
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
            }
        } else {
            if (this.accountingStateData.getAvailableContext().getContexts() != null && !this.accountingStateData.getAvailableContext().getContexts().isEmpty()) {
                ArrayList scopesAvailables = this.accountingStateData.getAvailableContext().getContexts();
                ArrayList<GenresData> scopes = new ArrayList<GenresData>();
                for (String scopeAvailable : scopesAvailables) {
                    scopes.add(new GenresData(scopeAvailable));
                }
                this.storeComboScope.clear();
                this.storeComboScope.addAll(scopes);
                this.storeComboScope.commitChanges();
                this.comboScope.setValue(this.storeComboScope.get(0));
            } else {
                this.storeComboScope.clear();
                this.storeComboScope.commitChanges();
                this.comboScope.reset();
            }
            this.comboScopeLabel.setVisible(true);
            this.comboTopFilterKey.reset();
            this.showOthersToggle.reset();
            this.showOthersNo.setValue(Boolean.valueOf(true));
            this.topNumber.reset();
            this.topNumber.setValue((Object)5);
            this.storeFilter.clear();
            this.storeFilter.commitChanges();
            this.seq = 0;
        }
        this.comboChartType.setValue((Object)ChartType.Top);
        this.gridGenres.setVisible(false);
        this.comboTopFilterKeyLabel.setVisible(true);
        this.showOthersLabel.setVisible(true);
        this.noContextToggle.reset();
        this.noContextNo.setValue(Boolean.valueOf(true));
        this.noContextLabel.setVisible(false);
        this.topNumberLabel.setVisible(true);
        this.forceLayout();
    }

    private void changeActiveFiltersForContext() {
        if (this.accountingStateData.getSeriesRequest() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() instanceof AccountingFilterContext) {
            AccountingFilterContext accountingFilterContext = (AccountingFilterContext)this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition();
            if (this.accountingStateData.getAvailableContext() != null && this.accountingStateData.getAvailableContext().getContexts() != null && !this.accountingStateData.getAvailableContext().getContexts().isEmpty()) {
                if (accountingFilterContext.getContext() != null && accountingFilterContext.getContext().getContexts() != null && !accountingFilterContext.getContext().getContexts().isEmpty()) {
                    ArrayList contexts = this.accountingStateData.getAvailableContext().getContexts();
                    ArrayList<GenresData> genres = new ArrayList<GenresData>();
                    for (String context : contexts) {
                        GenresData genresData = new GenresData(context);
                        genres.add(genresData);
                    }
                    this.storeGenres.clear();
                    this.storeGenres.addAll(genres);
                    this.storeGenres.commitChanges();
                    this.smGenres.deselectAll();
                    if (accountingFilterContext.getContext().getContexts() != null && !accountingFilterContext.getContext().getContexts().isEmpty()) {
                        ArrayList<GenresData> selected = new ArrayList<GenresData>();
                        block1: for (String c : accountingFilterContext.getContext().getContexts()) {
                            for (GenresData genresData : this.storeGenres.getAll()) {
                                if (c.compareTo(genresData.getGenre()) != 0) continue;
                                selected.add(genresData);
                                continue block1;
                            }
                        }
                        if (!selected.isEmpty()) {
                            if (selected.size() == this.storeGenres.getAll().size()) {
                                this.smGenres.selectAll();
                            } else {
                                this.smGenres.select(selected, false);
                            }
                        }
                    }
                    this.smGenres.refresh();
                } else {
                    this.repopulatesContexts();
                }
            } else {
                this.resetContexts();
            }
            if (accountingFilterContext.getFilters() != null) {
                ArrayList filters = accountingFilterContext.getFilters();
                this.storeFilter.clear();
                this.storeFilter.addAll((Collection)filters);
                this.seq = 0;
                for (AccountingFilter filter : filters) {
                    if (filter.getId() <= this.seq) continue;
                    this.seq = filter.getId();
                }
                this.storeFilter.commitChanges();
            } else {
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
            }
        } else {
            this.reconfigureContext();
            this.storeFilter.clear();
            this.storeFilter.commitChanges();
            this.seq = 0;
        }
        this.comboChartType.setValue((Object)ChartType.Context);
        this.comboScopeLabel.setVisible(false);
        this.gridGenres.setVisible(true);
        this.labelGenresCol.setHeader("Scope");
        this.gridGenres.getView().refresh(true);
        this.comboTopFilterKey.reset();
        this.comboTopFilterKeyLabel.setVisible(false);
        this.showOthersToggle.reset();
        this.showOthersNo.setValue(Boolean.valueOf(true));
        this.showOthersLabel.setVisible(false);
        this.noContextToggle.reset();
        this.noContextNo.setValue(Boolean.valueOf(true));
        this.noContextLabel.setVisible(false);
        this.topNumber.reset();
        this.topNumberLabel.setVisible(false);
        this.forceLayout();
    }

    private void reconfigureContext() {
        if (this.accountingStateData.getAvailableContext() != null && this.accountingStateData.getAvailableContext().getContexts() != null && !this.accountingStateData.getAvailableContext().getContexts().isEmpty()) {
            this.repopulatesContexts();
        } else {
            this.resetContexts();
        }
    }

    private void resetContexts() {
        this.storeGenres.clear();
        this.storeGenres.commitChanges();
        this.smGenres.deselectAll();
        this.smGenres.refresh();
    }

    private void repopulatesContexts() {
        ArrayList contexts = this.accountingStateData.getAvailableContext().getContexts();
        ArrayList<GenresData> genres = new ArrayList<GenresData>();
        for (String context : contexts) {
            GenresData genresData = new GenresData(context);
            genres.add(genresData);
        }
        this.storeGenres.clear();
        this.storeGenres.addAll(genres);
        this.storeGenres.commitChanges();
        this.smGenres.selectAll();
        this.smGenres.refresh();
    }

    private void changeActiveFiltersForSpaces() {
        if (this.accountingStateData.getSeriesRequest() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() != null && this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition() instanceof AccountingFilterSpaces) {
            AccountingFilterSpaces accountingFilterSapces = (AccountingFilterSpaces)this.accountingStateData.getSeriesRequest().getAccountingFilterDefinition();
            if (this.accountingStateData.getAvailableSpaces() != null && this.accountingStateData.getAvailableSpaces().getSpacesList() != null && !this.accountingStateData.getAvailableSpaces().getSpacesList().isEmpty()) {
                if (accountingFilterSapces.getSpaces() != null && accountingFilterSapces.getSpaces().getSpacesList() != null && !accountingFilterSapces.getSpaces().getSpacesList().isEmpty()) {
                    ArrayList spacesList = this.accountingStateData.getAvailableSpaces().getSpacesList();
                    ArrayList<GenresData> genres = new ArrayList<GenresData>();
                    for (String space : spacesList) {
                        GenresData genresData = new GenresData(space);
                        genres.add(genresData);
                    }
                    this.storeGenres.clear();
                    this.storeGenres.addAll(genres);
                    this.storeGenres.commitChanges();
                    this.smGenres.deselectAll();
                    if (accountingFilterSapces.getSpaces().getSpacesList() != null && !accountingFilterSapces.getSpaces().getSpacesList().isEmpty()) {
                        ArrayList<GenresData> selected = new ArrayList<GenresData>();
                        block1: for (String s : accountingFilterSapces.getSpaces().getSpacesList()) {
                            for (GenresData genresData : this.storeGenres.getAll()) {
                                if (s.compareTo(genresData.getGenre()) != 0) continue;
                                selected.add(genresData);
                                continue block1;
                            }
                        }
                        if (!selected.isEmpty()) {
                            if (selected.size() == this.storeGenres.getAll().size()) {
                                this.smGenres.selectAll();
                            } else {
                                this.smGenres.select(selected, false);
                            }
                        }
                    }
                    this.smGenres.refresh();
                } else {
                    this.repopulatesSpaces();
                }
            } else {
                this.resetSpaces();
            }
            if (accountingFilterSapces.getFilters() != null) {
                ArrayList filters = accountingFilterSapces.getFilters();
                this.storeFilter.clear();
                this.storeFilter.addAll((Collection)filters);
                this.seq = 0;
                for (AccountingFilter filter : filters) {
                    if (filter.getId() <= this.seq) continue;
                    this.seq = filter.getId();
                }
                this.storeFilter.commitChanges();
            } else {
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
            }
        } else {
            this.reconfigureSpaces();
            this.storeFilter.clear();
            this.storeFilter.commitChanges();
            this.seq = 0;
        }
        this.comboChartType.setValue((Object)ChartType.Spaces);
        this.comboScopeLabel.setVisible(false);
        this.gridGenres.setVisible(true);
        this.labelGenresCol.setHeader("Space");
        this.gridGenres.getView().refresh(true);
        this.comboTopFilterKey.reset();
        this.comboTopFilterKeyLabel.setVisible(false);
        this.showOthersToggle.reset();
        this.showOthersNo.setValue(Boolean.valueOf(true));
        this.showOthersLabel.setVisible(false);
        this.noContextToggle.reset();
        this.noContextNo.setValue(Boolean.valueOf(true));
        this.noContextLabel.setVisible(false);
        this.topNumber.reset();
        this.topNumberLabel.setVisible(false);
        this.forceLayout();
    }

    private void reconfigureSpaces() {
        if (this.accountingStateData.getAvailableSpaces() != null && this.accountingStateData.getAvailableSpaces().getSpacesList() != null && !this.accountingStateData.getAvailableSpaces().getSpacesList().isEmpty()) {
            this.repopulatesSpaces();
        } else {
            this.resetSpaces();
        }
    }

    private void resetSpaces() {
        this.storeGenres.clear();
        this.storeGenres.commitChanges();
        this.smGenres.deselectAll();
        this.smGenres.refresh();
    }

    private void repopulatesSpaces() {
        ArrayList spaces = this.accountingStateData.getAvailableSpaces().getSpacesList();
        ArrayList<GenresData> genres = new ArrayList<GenresData>();
        for (String space : spaces) {
            GenresData genresData = new GenresData(space);
            genres.add(genresData);
        }
        this.storeGenres.clear();
        this.storeGenres.addAll(genres);
        this.storeGenres.commitChanges();
        this.smGenres.selectAll();
        this.smGenres.refresh();
    }

    public AccountingFilterDefinition getActiveFilters() {
        try {
            ChartType chartType = (ChartType)this.comboChartType.getCurrentValue();
            switch (23.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[chartType.ordinal()]) {
                case 1: {
                    return this.getActiveFiltersForBasic();
                }
                case 2: {
                    return this.getActiveFiltersForTop();
                }
                case 3: {
                    return this.getActiveFiltersForContext();
                }
                case 4: {
                    return this.getActiveFiltersForSpaces();
                }
            }
            return null;
        }
        catch (Throwable e) {
            Log.error((String)e.getLocalizedMessage());
            e.printStackTrace();
            UtilsGXT3.alert((String)"Attention", (String)e.getLocalizedMessage());
            return null;
        }
    }

    private AccountingFilterDefinition getActiveFiltersForBasic() {
        GenresData genresData;
        String scope = null;
        if (this.comboScopeLabel != null && this.comboScopeLabel.isVisible() && (genresData = (GenresData)this.comboScope.getCurrentValue()) != null) {
            scope = genresData.getLabel();
        }
        Log.debug((String)("Scope selected: " + scope));
        Boolean noContextValue = false;
        noContextValue = this.noContextLabel != null && this.noContextLabel.isVisible() ? (Boolean)this.noContextYes.getValue() : Boolean.valueOf(false);
        Log.debug((String)("noContextValue: " + noContextValue));
        if (this.storeFilter == null || this.storeFilter.size() <= 0) {
            return new AccountingFilterBasic(scope, noContextValue.booleanValue());
        }
        List filtersActives = this.storeFilter.getAll();
        ArrayList<AccountingFilter> filtersReady = new ArrayList<AccountingFilter>();
        for (AccountingFilter filter : filtersActives) {
            if (filter.getFilterValue() == null || filter.getFilterValue().isEmpty()) continue;
            filtersReady.add(filter);
        }
        if (filtersReady.size() > 0) {
            return new AccountingFilterBasic(scope, filtersReady, noContextValue.booleanValue());
        }
        return new AccountingFilterBasic(scope, noContextValue.booleanValue());
    }

    private AccountingFilterDefinition getActiveFiltersForTop() {
        GenresData genresData;
        String scope = null;
        if (this.comboScopeLabel != null && this.comboScopeLabel.isVisible() && (genresData = (GenresData)this.comboScope.getCurrentValue()) != null) {
            scope = genresData.getLabel();
        }
        Log.debug((String)("Scope selected: " + scope));
        Boolean showOthersValue = (Boolean)this.showOthersYes.getValue();
        Integer topN = (Integer)this.topNumber.getCurrentValue();
        FilterKey filterKey = (FilterKey)this.comboTopFilterKey.getCurrentValue();
        if (filterKey == null) {
            return new AccountingFilterTop(scope, showOthersValue, topN);
        }
        if (this.storeFilter == null || this.storeFilter.size() <= 0) {
            return new AccountingFilterTop(scope, filterKey, null, showOthersValue, topN);
        }
        List filtersActives = this.storeFilter.getAll();
        ArrayList<AccountingFilter> filtersReady = new ArrayList<AccountingFilter>();
        for (AccountingFilter filter : filtersActives) {
            if (filter.getFilterValue() == null || filter.getFilterValue().isEmpty()) continue;
            filtersReady.add(filter);
        }
        if (filtersReady.size() > 0) {
            return new AccountingFilterTop(scope, filterKey, filtersReady, showOthersValue, topN);
        }
        return new AccountingFilterTop(scope, filterKey, null, showOthersValue, topN);
    }

    private AccountingFilterDefinition getActiveFiltersForContext() {
        ArrayList<String> contextsSelected = new ArrayList<String>();
        if (this.storeGenres != null && this.storeGenres.size() > 0 && this.smGenres != null) {
            List selected = this.smGenres.getSelectedItems();
            for (GenresData cd : selected) {
                contextsSelected.add(cd.getGenre());
            }
        }
        Context context = new Context(contextsSelected);
        List filtersActives = this.storeFilter.getAll();
        ArrayList<AccountingFilter> filtersReady = new ArrayList<AccountingFilter>();
        for (AccountingFilter filter : filtersActives) {
            if (filter.getFilterValue() == null || filter.getFilterValue().isEmpty()) continue;
            filtersReady.add(filter);
        }
        if (filtersReady.size() > 0) {
            return new AccountingFilterContext(context, filtersReady);
        }
        return new AccountingFilterContext(context, null);
    }

    private AccountingFilterDefinition getActiveFiltersForSpaces() {
        ArrayList<String> spacesSelected = new ArrayList<String>();
        if (this.storeGenres != null && this.storeGenres.size() > 0 && this.smGenres != null) {
            List selected = this.smGenres.getSelectedItems();
            for (GenresData cd : selected) {
                spacesSelected.add(cd.getGenre());
            }
        }
        Spaces spaces = new Spaces(spacesSelected);
        List filtersActives = this.storeFilter.getAll();
        ArrayList<AccountingFilter> filtersReady = new ArrayList<AccountingFilter>();
        for (AccountingFilter filter : filtersActives) {
            if (filter.getFilterValue() == null || filter.getFilterValue().isEmpty()) continue;
            filtersReady.add(filter);
        }
        if (filtersReady.size() > 0) {
            return new AccountingFilterSpaces(spaces, filtersReady);
        }
        return new AccountingFilterSpaces(spaces, null);
    }

    private void addNewFilter(SelectEvent event) {
        List filtersSet = this.storeFilter.getAll();
        FilterKey fk = null;
        if (this.accountingStateData == null || this.accountingStateData.getAvailableFilterKeys() == null || this.accountingStateData.getAvailableFilterKeys().size() < 0) {
            UtilsGXT3.info((String)"No key available", (String)"No key available");
        } else {
            ArrayList remainingFilterKeys = new ArrayList(this.accountingStateData.getAvailableFilterKeys());
            ArrayList<Object> removableFilterKeys = new ArrayList<Object>();
            for (AccountingFilter filterSet : filtersSet) {
                removableFilterKeys.add(filterSet.getFilterKey());
            }
            if (this.comboChartType.getCurrentValue() != null && ((ChartType)this.comboChartType.getCurrentValue()).compareTo((Enum)ChartType.Top) == 0 && this.comboTopFilterKey.getCurrentValue() != null) {
                removableFilterKeys.add(this.comboTopFilterKey.getCurrentValue());
            }
            remainingFilterKeys.removeAll(removableFilterKeys);
            if (remainingFilterKeys.size() > 0) {
                fk = new FilterKey("");
                ++this.seq;
                AccountingFilter newAccountingFilter = new AccountingFilter(this.seq, fk, "");
                Log.debug((String)("newAccountingFilter: " + newAccountingFilter));
                this.editing.cancelEditing();
                this.addStatus = true;
                this.editing.getCancelButton().setVisible(false);
                this.storeFilter.add((Object)newAccountingFilter);
                int row = this.storeFilter.indexOf((Object)newAccountingFilter);
                this.storeComboFilterKey.clear();
                this.storeComboFilterKey.addAll(remainingFilterKeys);
                this.storeComboFilterKey.commitChanges();
                this.editing.startEditing(new Grid.GridCell(row, 0));
            } else {
                UtilsGXT3.info((String)"No key available", (String)"No key available");
            }
        }
    }

    private void retrieveFilterValuesByKey(FilterKey filterKey, boolean cancelValue) {
        this.filterKey = filterKey;
        this.cancelValue = cancelValue;
        AccountingPeriodRequestEvent event = new AccountingPeriodRequestEvent();
        this.eventBus.fireEvent((GwtEvent)event);
    }

    private void manageAccountingPeriodEvent(AccountingPeriodEvent event) {
        if (event == null || event.getAccountingPeriod() == null) {
            Log.debug((String)"AccountingPeriod not valid");
            return;
        }
        if (this.filterKey == null || this.filterKey.getKey() == null || this.filterKey.getKey().isEmpty()) {
            Log.debug((String)("FilterKey: " + this.filterKey));
            this.comboFilterValue.clear();
            this.storeComboFilterValue.clear();
            this.storeComboFilterValue.commitChanges();
            return;
        }
        this.accountingMonitor = new AccountingMonitor();
        FilterValuesRequest requestFilterValue = new FilterValuesRequest(this.filterKey, this.accountingStateData.getAccountingType(), event.getAccountingPeriod());
        AccountingManagerServiceAsync.INSTANCE.getFilterValues(requestFilterValue, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void editingBeforeStart(BeforeStartEditEvent<AccountingFilter> event) {
        Grid.GridCell cell = event.getEditCell();
        int rowIndex = cell.getRow();
        AccountingFilter editingFilter = (AccountingFilter)this.storeFilter.get(rowIndex);
        List filtersSet = this.storeFilter.getAll();
        ArrayList remainingFilterKeys = null;
        remainingFilterKeys = this.accountingStateData == null || this.accountingStateData.getAvailableFilterKeys() == null ? new ArrayList() : new ArrayList(this.accountingStateData.getAvailableFilterKeys());
        ArrayList<Object> setFilterKeys = new ArrayList<Object>();
        if (this.comboChartType.getCurrentValue() != null && ((ChartType)this.comboChartType.getCurrentValue()).compareTo((Enum)ChartType.Top) == 0 && this.comboTopFilterKey.getCurrentValue() != null) {
            setFilterKeys.add(this.comboTopFilterKey.getCurrentValue());
        }
        for (AccountingFilter filterSet : filtersSet) {
            if (filterSet.getFilterKey().getKey().compareTo(editingFilter.getFilterKey().getKey()) == 0) continue;
            setFilterKeys.add(filterSet.getFilterKey());
        }
        remainingFilterKeys.removeAll(setFilterKeys);
        this.storeComboFilterKey.clear();
        this.storeComboFilterKey.addAll(remainingFilterKeys);
        this.storeComboFilterKey.commitChanges();
        if (editingFilter.getFilterKey() != null) {
            this.retrieveFilterValuesByKey(editingFilter.getFilterKey(), false);
        }
        this.addButton.setEnabled(false);
    }

    private void addHandlersForComboFilterKey(LabelProvider<FilterKey> labelProvider) {
        this.comboFilterKey.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateFilterKey(FilterKey selectedFilterKey) {
        this.retrieveFilterValuesByKey(selectedFilterKey, true);
    }

    private void addHandlersForComboChartType(LabelProvider<ChartType> labelProvider) {
        this.comboChartType.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateComboChartType(ChartType chartType) {
        if (chartType == null) {
            return;
        }
        switch (23.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[chartType.ordinal()]) {
            case 1: {
                this.comboScopeLabel.setVisible(true);
                this.gridGenres.setVisible(false);
                this.comboTopFilterKey.reset();
                this.comboTopFilterKeyLabel.setVisible(false);
                this.showOthersToggle.reset();
                this.showOthersNo.setValue(Boolean.valueOf(true));
                this.showOthersLabel.setVisible(false);
                if (this.accountingStateData.getRootScope().booleanValue()) {
                    this.noContextToggle.reset();
                    this.noContextNo.setValue(Boolean.valueOf(true));
                    this.noContextLabel.setVisible(true);
                } else {
                    this.noContextToggle.reset();
                    this.noContextNo.setValue(Boolean.valueOf(true));
                    this.noContextLabel.setVisible(false);
                }
                this.topNumber.reset();
                this.topNumberLabel.setVisible(false);
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
                this.forceLayout();
                break;
            }
            case 2: {
                this.comboScopeLabel.setVisible(true);
                this.gridGenres.setVisible(false);
                this.comboTopFilterKey.reset();
                if (this.accountingStateData != null && this.accountingStateData.getAvailableFilterKeys() != null && this.accountingStateData.getAvailableFilterKeys().size() > 0) {
                    this.comboTopFilterKey.setValue(this.accountingStateData.getAvailableFilterKeys().get(0));
                }
                this.comboTopFilterKeyLabel.setVisible(true);
                this.showOthersToggle.reset();
                this.showOthersNo.setValue(Boolean.valueOf(true));
                this.showOthersLabel.setVisible(true);
                this.noContextToggle.reset();
                this.noContextYes.setValue(Boolean.valueOf(false));
                this.noContextNo.setValue(Boolean.valueOf(true));
                this.noContextLabel.setVisible(false);
                this.topNumber.reset();
                this.topNumber.setValue((Object)5);
                this.topNumberLabel.setVisible(true);
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
                this.forceLayout();
                break;
            }
            case 3: {
                this.reconfigureContext();
                this.comboScopeLabel.setVisible(false);
                this.gridGenres.setVisible(true);
                this.labelGenresCol.setHeader("Scope");
                this.gridGenres.getView().refresh(true);
                this.comboTopFilterKey.reset();
                this.comboTopFilterKeyLabel.setVisible(false);
                this.showOthersToggle.reset();
                this.showOthersNo.setValue(Boolean.valueOf(true));
                this.showOthersLabel.setVisible(false);
                this.noContextToggle.reset();
                this.noContextYes.setValue(Boolean.valueOf(false));
                this.noContextNo.setValue(Boolean.valueOf(true));
                this.noContextLabel.setVisible(false);
                this.topNumber.reset();
                this.topNumberLabel.setVisible(false);
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
                this.forceLayout();
                break;
            }
            case 4: {
                this.reconfigureSpaces();
                this.comboScopeLabel.setVisible(false);
                this.gridGenres.setVisible(true);
                this.labelGenresCol.setHeader("Space");
                this.gridGenres.getView().refresh(true);
                this.comboTopFilterKey.reset();
                this.comboTopFilterKeyLabel.setVisible(false);
                this.showOthersToggle.reset();
                this.showOthersNo.setValue(Boolean.valueOf(true));
                this.showOthersLabel.setVisible(false);
                this.noContextToggle.reset();
                this.noContextYes.setValue(Boolean.valueOf(false));
                this.noContextNo.setValue(Boolean.valueOf(true));
                this.noContextLabel.setVisible(false);
                this.topNumber.reset();
                this.topNumberLabel.setVisible(false);
                this.storeFilter.clear();
                this.storeFilter.commitChanges();
                this.seq = 0;
                this.forceLayout();
                break;
            }
        }
    }

    private void addHandlersForComboTopFilterKey(LabelProvider<FilterKey> labelProvider) {
        this.comboTopFilterKey.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateTopFilterKey(FilterKey selectedFilterKey) {
        this.storeFilter.clear();
        this.storeFilter.commitChanges();
        this.seq = 0;
    }

    private void addHandlersForComboScope(LabelProvider<GenresData> labelProvider) {
        this.comboScope.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateScope(GenresData selectedFilterKey) {
    }

    static /* synthetic */ void access$000(ActiveFiltersPanel x0, SelectEvent x1) {
        x0.addNewFilter(x1);
    }

    static /* synthetic */ GridRowEditing access$100(ActiveFiltersPanel x0) {
        return x0.editing;
    }

    static /* synthetic */ ListStore access$200(ActiveFiltersPanel x0) {
        return x0.storeFilter;
    }

    static /* synthetic */ TextButton access$300(ActiveFiltersPanel x0) {
        return x0.addButton;
    }

    static /* synthetic */ boolean access$400(ActiveFiltersPanel x0) {
        return x0.addStatus;
    }

    static /* synthetic */ boolean access$402(ActiveFiltersPanel x0, boolean x1) {
        x0.addStatus = x1;
        return x0.addStatus;
    }

    static /* synthetic */ void access$500(ActiveFiltersPanel x0, BeforeStartEditEvent x1) {
        x0.editingBeforeStart(x1);
    }

    static /* synthetic */ void access$600(ActiveFiltersPanel x0, StateChangeEvent x1) {
        x0.doStateChangeCommand(x1);
    }

    static /* synthetic */ void access$700(ActiveFiltersPanel x0, AccountingPeriodEvent x1) {
        x0.manageAccountingPeriodEvent(x1);
    }

    static /* synthetic */ AccountingMonitor access$800(ActiveFiltersPanel x0) {
        return x0.accountingMonitor;
    }

    static /* synthetic */ EventBus access$900(ActiveFiltersPanel x0) {
        return x0.eventBus;
    }

    static /* synthetic */ boolean access$1000(ActiveFiltersPanel x0) {
        return x0.cancelValue;
    }

    static /* synthetic */ StringComboBox access$1100(ActiveFiltersPanel x0) {
        return x0.comboFilterValue;
    }

    static /* synthetic */ ListStore access$1200(ActiveFiltersPanel x0) {
        return x0.storeComboFilterValue;
    }

    static /* synthetic */ void access$1300(ActiveFiltersPanel x0, FilterKey x1) {
        x0.updateFilterKey(x1);
    }

    static /* synthetic */ void access$1400(ActiveFiltersPanel x0, ChartType x1) {
        x0.updateComboChartType(x1);
    }

    static /* synthetic */ void access$1500(ActiveFiltersPanel x0, FilterKey x1) {
        x0.updateTopFilterKey(x1);
    }

    static /* synthetic */ void access$1600(ActiveFiltersPanel x0, GenresData x1) {
        x0.updateScope(x1);
    }
}

