/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.portlets.admin.accountingmanager.client.rpc.AccountingManagerService;
import org.gcube.portlets.admin.accountingmanager.server.SessionUtil;
import org.gcube.portlets.admin.accountingmanager.server.amservice.AccountingCallerTester;
import org.gcube.portlets.admin.accountingmanager.server.amservice.cache.AccountingCache;
import org.gcube.portlets.admin.accountingmanager.server.export.CSVManager;
import org.gcube.portlets.admin.accountingmanager.server.is.BuildEnableTabs;
import org.gcube.portlets.admin.accountingmanager.server.state.AccountingStateData;
import org.gcube.portlets.admin.accountingmanager.server.storage.StorageUtil;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.Context;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValue;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.gcube.portlets.admin.accountingmanager.shared.session.UserInfo;
import org.gcube.portlets.admin.accountingmanager.shared.tabs.EnableTabs;
import org.gcube.portlets.admin.accountingmanager.shared.workspace.ItemDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingManagerServiceImpl
extends RemoteServiceServlet
implements AccountingManagerService {
    private static Logger logger = LoggerFactory.getLogger(AccountingManagerServiceImpl.class);
    private static AccountingCache accountingCache;

    public void init() throws ServletException {
        super.init();
        logger.info("Fix JAXP: jdk.xml.entityExpansionLimit=0");
        System.setProperty("jdk.xml.entityExpansionLimit", "0");
        logger.info("initializing AccountingManager");
        try {
            accountingCache = new AccountingCache();
        }
        catch (ServiceException e) {
            logger.error("Error initializing AccountingCache: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        super.destroy();
        logger.info("Clear AccountingCache");
        try {
            accountingCache.finalize();
        }
        catch (Throwable e) {
            logger.error("Error initializing AccountingCache: " + e.getLocalizedMessage(), e);
        }
    }

    public UserInfo hello() throws ServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getASLSession((HttpSession)session);
            String token = SessionUtil.getToken((ASLSession)aslSession);
            UserInfo userInfo = new UserInfo(aslSession.getUsername(), aslSession.getGroupId(), aslSession.getGroupName(), aslSession.getScope(), aslSession.getScopeName(), aslSession.getUserEmailAddress(), aslSession.getUserFullName());
            logger.debug("UserInfo: " + userInfo);
            logger.debug("UserToken: " + token);
            return userInfo;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("Hello(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public EnableTabs getEnableTabs() throws ServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getASLSession((HttpSession)session);
            String token = SessionUtil.getToken((ASLSession)aslSession);
            logger.debug("UserToken: " + token);
            EnableTabs enableTabs = BuildEnableTabs.build((String)aslSession.getScope());
            return enableTabs;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getEnableTabs(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public SeriesResponse getSeries(AccountingType accountingType, SeriesRequest seriesRequest) throws ServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getASLSession((HttpSession)session);
            String token = SessionUtil.getToken((ASLSession)aslSession);
            logger.debug("UserToken: " + token);
            String key = new String(aslSession.getScope() + "_" + accountingType.name() + "_" + seriesRequest.toString());
            logger.info("Search Accounting data in Cache with key: " + key);
            SeriesResponse seriesResponse = accountingCache.get(key);
            if (seriesResponse == null) {
                logger.info("Accounting no data in Cache retrieved, call Service");
                AccountingCallerTester accountingCaller = new AccountingCallerTester();
                seriesResponse = accountingCaller.getSeries(accountingType, seriesRequest);
                accountingCache.put(key, seriesResponse);
            } else {
                logger.info("Accounting use data in Cache");
            }
            AccountingStateData accountingStateData = new AccountingStateData(accountingType, seriesRequest, seriesResponse);
            SessionUtil.setAccountingStateData((HttpSession)session, (AccountingType)accountingType, (AccountingStateData)accountingStateData);
            return seriesResponse;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getSeries(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public ArrayList<FilterKey> getFilterKeys(AccountingType accountingType) throws ServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getASLSession((HttpSession)session);
            String token = SessionUtil.getToken((ASLSession)aslSession);
            logger.debug("UserToken: " + token);
            AccountingCallerTester accountingCaller = new AccountingCallerTester();
            ArrayList filterKeys = accountingCaller.getFilterKeys(accountingType);
            return filterKeys;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getFilterKeys(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public ArrayList<FilterValue> getFilterValues(FilterValuesRequest filterValuesRequest) throws ServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getASLSession((HttpSession)session);
            String token = SessionUtil.getToken((ASLSession)aslSession);
            logger.debug("UserToken: " + token);
            AccountingCallerTester accountingCaller = new AccountingCallerTester();
            ArrayList filterValues = accountingCaller.getFilterValues(filterValuesRequest);
            return filterValues;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getFilterValues(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public Context getContext() throws ServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getASLSession((HttpSession)session);
            String token = SessionUtil.getToken((ASLSession)aslSession);
            logger.debug("UserToken: " + token);
            Context context = SessionUtil.getContext((ASLSession)aslSession);
            logger.debug("getContext(): " + context);
            return context;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            logger.error("getContext(): " + e.getLocalizedMessage(), e);
            throw new ServiceException(e.getLocalizedMessage());
        }
    }

    public ItemDescription saveCSVOnWorkspace(AccountingType accountingType) throws ServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getASLSession((HttpSession)session);
            String token = SessionUtil.getToken((ASLSession)aslSession);
            logger.debug("UserToken: " + token);
            logger.debug("SaveDataOnWorkspace(): " + accountingType);
            AccountingStateData accountingStateData = SessionUtil.getAccountingStateData((HttpSession)session, (AccountingType)accountingType);
            if (accountingStateData == null) {
                logger.error("No series present in session for thi accounting type: " + accountingType);
                throw new ServiceException("No series present in session for thi accounting type: " + accountingType);
            }
            CSVManager csvManager = new CSVManager(aslSession.getUsername());
            ItemDescription itemDescription = csvManager.saveOnWorkspace(accountingStateData);
            return itemDescription;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            logger.error("SaveDataOnWorkspace(): " + e.getLocalizedMessage(), e);
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }

    public String getPublicLink(ItemDescription itemDescription) throws ServiceException {
        try {
            HttpSession session = this.getThreadLocalRequest().getSession();
            ASLSession aslSession = SessionUtil.getASLSession((HttpSession)session);
            String token = SessionUtil.getToken((ASLSession)aslSession);
            logger.debug("UserToken: " + token);
            logger.debug("GetPublicLink(): " + itemDescription);
            String link = StorageUtil.getPublicLink((String)aslSession.getUsername(), (String)itemDescription.getId());
            return link;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable e) {
            logger.error("getPublicLink(): " + e.getLocalizedMessage(), e);
            e.printStackTrace();
            throw new ServiceException(e.getLocalizedMessage(), e);
        }
    }
}

