/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.accountingmanager.server.amservice;

import java.util.ArrayList;
import org.gcube.portlets.admin.accountingmanager.server.amservice.AccountingCaller;
import org.gcube.portlets.admin.accountingmanager.server.amservice.AccountingCallerInterface;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandBasic;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandContext;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandGetFilterKeys;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandGetFilterValues;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandGetSpaces;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandSpaces;
import org.gcube.portlets.admin.accountingmanager.server.amservice.command.AccountingCommandTop;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Job;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Portlet;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Service;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Space;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Storage;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuery4Task;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryBasic;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryBuilder;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryContext;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryDirector;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQuerySpaces;
import org.gcube.portlets.admin.accountingmanager.server.amservice.query.AccountingQueryTop;
import org.gcube.portlets.admin.accountingmanager.shared.data.AccountingType;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterKey;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.FilterValuesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.data.Spaces;
import org.gcube.portlets.admin.accountingmanager.shared.data.query.SeriesRequest;
import org.gcube.portlets.admin.accountingmanager.shared.data.response.SeriesResponse;
import org.gcube.portlets.admin.accountingmanager.shared.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingCaller
implements AccountingCallerInterface {
    private static Logger logger = LoggerFactory.getLogger(AccountingCaller.class);

    public ArrayList<FilterKey> getFilterKeys(AccountingType accountingType) throws ServiceException {
        AccountingCommandGetFilterKeys accountingCommand = new AccountingCommandGetFilterKeys(accountingType);
        return accountingCommand.execute();
    }

    public FilterValuesResponse getFilterValues(FilterValuesRequest filterValuesRequest) throws ServiceException {
        AccountingCommandGetFilterValues accountingCommand = new AccountingCommandGetFilterValues(filterValuesRequest);
        return accountingCommand.execute();
    }

    public Spaces getSpaces() throws ServiceException {
        AccountingCommandGetSpaces accountingCommand = new AccountingCommandGetSpaces();
        return accountingCommand.execute();
    }

    public SeriesResponse getSeries(AccountingType accountingType, SeriesRequest seriesRequest) throws ServiceException {
        try {
            logger.debug("getSeries(): [AccountingType=" + accountingType + " , seriesRequest=" + seriesRequest + "]");
            AccountingQueryBuilder queryBuilder = this.getAccountQueryBuilder(accountingType, seriesRequest);
            AccountingQueryDirector director = new AccountingQueryDirector();
            director.setAccountingQueryBuilder(queryBuilder);
            director.constructAccountingQuery();
            AccountingQuery query = director.getAccountingQuery();
            logger.info("AccountingQuery: " + query);
            if (query == null || query.getChartType() == null) {
                throw new ServiceException("Error in invocation: Operation not supported");
            }
            switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$ChartType[query.getChartType().ordinal()]) {
                case 1: {
                    AccountingQueryBasic accountingQueryBasic = (AccountingQueryBasic)query;
                    AccountingCommandBasic accountingCommandBasic = new AccountingCommandBasic(accountingQueryBasic, accountingType);
                    return accountingCommandBasic.execute();
                }
                case 2: {
                    AccountingQueryTop accountingQueryTop = (AccountingQueryTop)query;
                    AccountingCommandTop accountingCommandTop = new AccountingCommandTop(accountingQueryTop, accountingType);
                    return accountingCommandTop.execute();
                }
                case 3: {
                    AccountingQueryContext accountingQueryContext = (AccountingQueryContext)query;
                    AccountingCommandContext accountingCommandContext = new AccountingCommandContext(accountingQueryContext, accountingType);
                    return accountingCommandContext.execute();
                }
                case 4: {
                    AccountingQuerySpaces accountingQuerySpace = (AccountingQuerySpaces)query;
                    AccountingCommandSpaces accountingCommandSpace = new AccountingCommandSpaces(accountingQuerySpace, accountingType);
                    return accountingCommandSpace.execute();
                }
            }
            throw new ServiceException("Error in invocation: Operation not supported");
        }
        catch (Throwable e) {
            logger.error("Error in GetSeries(): " + e.getLocalizedMessage(), e);
            throw new ServiceException("No data available!");
        }
    }

    private AccountingQueryBuilder getAccountQueryBuilder(AccountingType accountingType, SeriesRequest seriesRequest) throws ServiceException {
        if (accountingType == null) {
            throw new ServiceException("Error accounting type is null");
        }
        logger.debug("StartCalendar: " + seriesRequest.getAccountingPeriod().getStartDate());
        logger.debug("EndCalendar: " + seriesRequest.getAccountingPeriod().getEndDate());
        switch (1.$SwitchMap$org$gcube$portlets$admin$accountingmanager$shared$data$AccountingType[accountingType.ordinal()]) {
            case 1: {
                return new AccountingQuery4Job(seriesRequest);
            }
            case 2: {
                return new AccountingQuery4Portlet(seriesRequest);
            }
            case 3: {
                return new AccountingQuery4Service(seriesRequest);
            }
            case 4: {
                return new AccountingQuery4Storage(seriesRequest);
            }
            case 5: {
                return new AccountingQuery4Task(seriesRequest);
            }
            case 6: {
                return new AccountingQuery4Space(seriesRequest);
            }
        }
        throw new ServiceException("Error request type is unknow!");
    }
}

